/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.modelling.util;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.CardinalityEnum;
import com.ibm.bi.platform.moser.common.generated.metadata.HighLevelDataType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.PropertyType;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.utils.MoserCommonUtils;
import com.ibm.smarts.schema.util.JAXBHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import shaded.com.google.common.graph.Graph;
import shaded.com.google.common.graph.GraphBuilder;
import shaded.com.google.common.graph.ImmutableGraph;
import shaded.com.google.common.graph.MutableGraph;

public class ModuleUtil {
    public static final String MODULE_SEPARATOR = ".";
    public static final String BASE_MODULE_IDENTIFIER = "base";
    public static final String DOT_BASE = ".base";
    @Deprecated
    public static final String DT_CATEGORY_NUMBER = "number";

    private ModuleUtil() {
    }

    public static boolean isAutoJoinDiscoveryRequired(Module module) {
        return !ModuleUtil.hasDBDefinedRelationships(module) && module.getQuerySubject().size() > 1;
    }

    public static boolean hasDBDefinedRelationships(Module module) {
        Predicate<Relationship> isSystemDiscovered = r -> r.getProperty().stream().map(PropertyType::getName).anyMatch("SystemDiscovered"::equals);
        return module.getRelationship().stream().anyMatch(isSystemDiscovered.negate());
    }

    public static Pair<List<String>, List<String>> getJoinedQuerySubjectIDsThroughForeignKeyRelationship(String qsIdentifier, Module module) {
        ArrayList dbDefinedJoinedQSNames = new ArrayList();
        ArrayList systemDiscoveredJoinedQSNames = new ArrayList();
        Predicate<Relationship> isSystemDiscovered = r -> r.getProperty().stream().map(PropertyType::getName).anyMatch("SystemDiscovered"::equals);
        module.getRelationship().stream().forEach(r -> {
            List container = null;
            container = isSystemDiscovered.test((Relationship)r) ? systemDiscoveredJoinedQSNames : dbDefinedJoinedQSNames;
            if (r.getRight().getRef().equals(qsIdentifier) || r.getLeft().getRef().equals(qsIdentifier)) {
                container.add(r.getLeft().getRef());
            }
        });
        return new ImmutablePair(dbDefinedJoinedQSNames, systemDiscoveredJoinedQSNames);
    }

    public static Map<String, Set<String>> getJoinGraphMap(Module module) {
        Map<String, Set<String>> joinGraph = module.getRelationship().stream().collect(Collectors.groupingBy(r -> r.getLeft().getRef(), Collectors.mapping(r -> r.getRight().getRef(), Collectors.toSet())));
        joinGraph.putAll(module.getRelationship().stream().collect(Collectors.groupingBy(r -> r.getRight().getRef(), Collectors.mapping(r -> r.getLeft().getRef(), Collectors.toSet()))));
        return joinGraph;
    }

    public static ImmutableGraph<String> getJoinGraph(Module module) {
        MutableGraph joinGraph = GraphBuilder.undirected().allowsSelfLoops(true).build();
        module.getRelationship().stream().forEach(r -> joinGraph.putEdge((Object)r.getLeft().getRef(), (Object)r.getRight().getRef()));
        return ImmutableGraph.copyOf((Graph)joinGraph);
    }

    public static List<String> getShortestJoinPath(String source, String target, ImmutableGraph<String> graph) {
        if (!graph.nodes().contains(source)) {
            return Collections.emptyList();
        }
        String currentNode = source;
        LinkedList<String> queue = new LinkedList<String>();
        HashMap<String, String> mapChildParent = new HashMap<String, String>();
        HashSet<String> visited = new HashSet<String>();
        queue.push(currentNode);
        visited.add(currentNode);
        while (!queue.isEmpty() && !(currentNode = (String)queue.removeFirst()).equals(target)) {
            for (String child : graph.adjacentNodes((Object)currentNode)) {
                if (visited.contains(child)) continue;
                queue.addLast(child);
                visited.add(child);
                mapChildParent.put(child, currentNode);
            }
        }
        if (!currentNode.equals(target)) {
            return Collections.emptyList();
        }
        ArrayList<String> path = new ArrayList<String>();
        String node = target;
        while (node != null) {
            path.add(node);
            node = (String)mapChildParent.get(node);
        }
        Collections.reverse(path);
        return path;
    }

    public static QuerySubject getQuerySubject(String identifier, Module module) {
        return module.getQuerySubject().stream().filter(qs -> identifier.equals(qs.getIdentifier())).findFirst().orElse(null);
    }

    public static Map<String, QuerySubject> createIDToQuerySubjectDictionary(Module module) {
        HashMap<String, QuerySubject> dictionary = new HashMap<String, QuerySubject>();
        List querySubjects = module.getQuerySubject();
        for (QuerySubject querySubject : querySubjects) {
            dictionary.put(querySubject.getIdentifier(), querySubject);
        }
        return dictionary;
    }

    public static QuerySubject cloneQuerySubject(QuerySubject originalQuerySubject) {
        return (QuerySubject)ModuleUtil.cloneBaseObjectType((BaseObjectType)originalQuerySubject);
    }

    public static Relationship cloneRelationship(Relationship originalRelationship) {
        return (Relationship)ModuleUtil.cloneBaseObjectType((BaseObjectType)originalRelationship);
    }

    private static BaseObjectType cloneBaseObjectType(BaseObjectType originalObject) {
        BaseObjectType object = null;
        try {
            object = (BaseObjectType)originalObject.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public static String relationshipToString(Relationship relationship) {
        try {
            return JAXBHelper.marshalToJSON((Object)relationship);
        }
        catch (IOException e) {
            return "";
        }
    }

    public static void setRelationshipIDandLabel(Relationship relationship, String leftQS, String rightQS) {
        String relationIdentifier = leftQS + "_" + rightQS;
        relationship.setIdentifier(relationIdentifier);
        String relationName = leftQS + "<-->" + rightQS;
        relationship.setDescription(relationName);
        relationship.setLabel(relationName);
    }

    public static boolean hasOneToNJoinPath(Module module, String leftID, String rightID, Map<String, Set<String>> joinGraph) {
        Set<String> joinedQS = joinGraph.get(leftID);
        if (joinedQS == null) {
            return false;
        }
        if (joinedQS.contains(rightID)) {
            return ModuleUtil.isOneToNJoinRelationship(module, leftID, rightID) || ModuleUtil.isOneToNJoinRelationship(module, rightID, leftID);
        }
        Set mediators = joinedQS.stream().filter(a -> joinGraph.containsKey(a) && ((Set)joinGraph.get(a)).contains(rightID)).collect(Collectors.toSet());
        return mediators.stream().filter(m -> ModuleUtil.isOneToNJoinRelationship(module, leftID, m) && ModuleUtil.isOneToNJoinRelationship(module, m, rightID)).count() > 0L;
    }

    public static boolean isOneToNJoinRelationship(Module module, String idA, String idB) {
        return module.getRelationship().stream().filter(r -> r.getLeft().getRef().equals(idA) && r.getRight().getRef().equals(idB) || r.getRight().getRef().equals(idA) && r.getLeft().getRef().equals(idB)).filter(r -> r.getLeft().getMincard().equals((Object)CardinalityEnum.ONE) && r.getLeft().getMaxcard().equals((Object)CardinalityEnum.ONE) || r.getRight().getMincard().equals((Object)CardinalityEnum.ONE) && r.getRight().getMaxcard().equals((Object)CardinalityEnum.ONE)).count() > 0L;
    }

    public static String generateDatatypeCategory(String dataType) {
        HighLevelDataType highlevelDatatype = MoserCommonUtils.generateHighlevelDatatype((String)dataType);
        return ModuleUtil.converToDatatypeCategory(highlevelDatatype);
    }

    private static String converToDatatypeCategory(HighLevelDataType highlevelDatatype) {
        if (highlevelDatatype == null) {
            return null;
        }
        switch (highlevelDatatype) {
            case INTEGER: 
            case DECIMAL: {
                return DT_CATEGORY_NUMBER;
            }
            case DATE: 
            case TIME: {
                return HighLevelDataType.DATETIME.value();
            }
        }
        return highlevelDatatype.value();
    }
}

