/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.modelling.util;

import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.Relation;
import com.ibm.smarts.schema.RelationType;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;
import java.util.Comparator;
import java.util.Optional;

public class TempUtil {
    private TempUtil() {
    }

    public static Optional<ConceptInfo> getCategoryConcept(ColumnInfo column) {
        Optional<Relation> relation = column.getSemanticInfo().getRelations().stream().filter(r -> r.getRelationType().equals((Object)RelationType.HAS_ATTRIBUTE)).findFirst();
        if (relation.isPresent()) {
            return Optional.of(relation.get().getEndFrom());
        }
        return Optional.empty();
    }

    public static Optional<ConceptInfo> getAttributeConcept(ColumnInfo column) {
        Optional<Relation> relation = column.getSemanticInfo().getRelations().stream().filter(r -> r.getRelationType().equals((Object)RelationType.HAS_ATTRIBUTE)).findFirst();
        if (relation.isPresent()) {
            return Optional.of(relation.get().getEndTo());
        }
        return column.getSemanticInfo().getConcepts().stream().sorted(Comparator.comparing(ConceptInfo::getConfidence).reversed()).findFirst();
    }

    public static boolean isPKFeature(ColumnInfo column) {
        Value countValue = column.getStatistics().stream().filter(s -> s.getType().equals((Object)StatisticType.COUNT)).map(Statistic::getValue).findFirst().orElse(null);
        Value distinctCountValue = column.getStatistics().stream().filter(s -> s.getType().equals((Object)StatisticType.DISTINCT_COUNT)).map(Statistic::getValue).findFirst().orElse(null);
        return countValue != null && distinctCountValue != null && countValue.equals((Object)distinctCountValue);
    }
}

