/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.common.util;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import java.util.ArrayList;
import java.util.List;

public class QuerySubjectUtil {
    public static final String COGNOS_ROW_IDENTIFIER = "_row_id";
    public static final String COGNOS_ROW_IDENTIFIER_DISPLAY_NAME = "__row_id__";

    public static List<QueryItem> getVisiableQueryItems(QuerySubject qs) {
        if (!qs.getQueryItem().isEmpty()) {
            return qs.getQueryItem();
        }
        ArrayList<QueryItem> result = new ArrayList<QueryItem>();
        QuerySubjectUtil.getVisibleQueryItems(result, qs.getItem(), false);
        return result;
    }

    public static List<QueryItem> getVisibleQueryItems(QuerySubject qs, boolean includeRowId) {
        ArrayList<QueryItem> result = new ArrayList<QueryItem>();
        if (!qs.getQueryItem().isEmpty()) {
            for (QueryItem queryItem : qs.getQueryItem()) {
                if (!QuerySubjectUtil.isVisible((BaseQueryItemType)queryItem, includeRowId)) continue;
                result.add(queryItem);
            }
            return result;
        }
        QuerySubjectUtil.getVisibleQueryItems(result, qs.getItem(), includeRowId);
        return result;
    }

    public static boolean isVisible(BaseQueryItemType baseQueryItem, boolean includeRowId) {
        return baseQueryItem.isHidden() == null || baseQueryItem.isHidden() == false || includeRowId && QuerySubjectUtil.isRowIdentifier(baseQueryItem);
    }

    public static void getVisibleQueryItems(List<QueryItem> result, List<ItemType> items, boolean includeRowId) {
        for (ItemType item : items) {
            if (item.getQueryItem() != null) {
                QuerySubjectUtil.addQueryItemAndChildrenIfVisible(result, item, (BaseQueryItemType)item.getQueryItem(), includeRowId);
                continue;
            }
            if (item.getFolder() == null) continue;
            QuerySubjectUtil.getVisibleQueryItems(result, item.getFolder().getItem(), includeRowId);
        }
    }

    public static void getAllItems(List<ItemType> result, List<ItemType> hidden, List<ItemType> items, boolean includeRowId) {
        for (ItemType item : items) {
            if (item.getQueryItem() != null) {
                QuerySubjectUtil.addAllItemAndChildren(result, hidden, item, (BaseQueryItemType)item.getQueryItem(), includeRowId);
                continue;
            }
            if (item.getFolder() != null) {
                QuerySubjectUtil.getAllItems(result, hidden, item.getFolder().getItem(), includeRowId);
                continue;
            }
            if (item.getNamedSet() == null) continue;
            QuerySubjectUtil.addAllItemAndChildren(result, hidden, item, (BaseQueryItemType)item.getNamedSet(), includeRowId);
        }
    }

    private static void addAllItemAndChildren(List<ItemType> result, List<ItemType> hidden, ItemType item, BaseQueryItemType baseQueryItem, boolean includeRowId) {
        if (QuerySubjectUtil.isVisible(baseQueryItem, includeRowId)) {
            result.add(item);
            QuerySubjectUtil.getAllItems(result, hidden, baseQueryItem.getItem(), includeRowId);
        } else if (!QuerySubjectUtil.isRowIdentifier(baseQueryItem)) {
            ArrayList<ItemType> returnedItems = new ArrayList<ItemType>();
            hidden.addAll(QuerySubjectUtil.getDescendants(item, returnedItems));
        }
    }

    private static List<ItemType> getDescendants(ItemType item, List<ItemType> returnedItems) {
        if (item.getQueryItem() != null) {
            returnedItems.add(item);
            item.getQueryItem().getItem().forEach(it -> QuerySubjectUtil.getDescendants(it, returnedItems));
        } else if (item.getFolder() != null) {
            returnedItems.add(item);
            item.getFolder().getItem().forEach(it -> QuerySubjectUtil.getDescendants(it, returnedItems));
        } else if (item.getNamedSet() != null) {
            returnedItems.add(item);
            item.getNamedSet().getItem().forEach(it -> QuerySubjectUtil.getDescendants(it, returnedItems));
        }
        return returnedItems;
    }

    public static void getVisibleItems(List<ItemType> result, List<ItemType> items, boolean includeRowId) {
        for (ItemType item : items) {
            if (item.getQueryItem() != null) {
                QuerySubjectUtil.addItemAndChildrenIfVisible(result, item, (BaseQueryItemType)item.getQueryItem(), includeRowId);
                continue;
            }
            if (item.getFolder() != null) {
                QuerySubjectUtil.getVisibleItems(result, item.getFolder().getItem(), includeRowId);
                continue;
            }
            if (item.getNamedSet() == null) continue;
            QuerySubjectUtil.addItemAndChildrenIfVisible(result, item, (BaseQueryItemType)item.getNamedSet(), includeRowId);
        }
    }

    private static void addQueryItemAndChildrenIfVisible(List<QueryItem> result, ItemType item, BaseQueryItemType baseQueryItem, boolean includeRowId) {
        QueryItem qi = item.getQueryItem();
        if (QuerySubjectUtil.isVisible((BaseQueryItemType)qi, includeRowId)) {
            result.add(qi);
            QuerySubjectUtil.getVisibleQueryItems(result, qi.getItem(), includeRowId);
        }
    }

    private static void addItemAndChildrenIfVisible(List<ItemType> result, ItemType item, BaseQueryItemType baseQueryItem, boolean includeRowId) {
        if (QuerySubjectUtil.isVisible(baseQueryItem, includeRowId)) {
            result.add(item);
            QuerySubjectUtil.getVisibleItems(result, baseQueryItem.getItem(), includeRowId);
        }
    }

    public static boolean isRowIdentifier(String qiiId) {
        return qiiId.equals(COGNOS_ROW_IDENTIFIER);
    }

    public static boolean isRowIdentifier(BaseQueryItemType qi) {
        return qi != null && qi.getIdentifier() != null && QuerySubjectUtil.isRowIdentifier(qi.getIdentifier());
    }

    public static QueryItem firstColumnRowIdentifier(QuerySubject qs) {
        QueryItem qi;
        List queryItemList = qs.getQueryItem();
        if (queryItemList.isEmpty() && !qs.getItem().isEmpty()) {
            ItemType item = (ItemType)qs.getItem().get(0);
            QueryItem qi2 = item.getQueryItem();
            if (QuerySubjectUtil.isRowIdentifier((BaseQueryItemType)qi2)) {
                return qi2;
            }
        } else if (!queryItemList.isEmpty() && QuerySubjectUtil.isRowIdentifier((BaseQueryItemType)(qi = (QueryItem)queryItemList.get(0)))) {
            return qi;
        }
        return null;
    }
}

