/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.contentrecommender;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ca.core.impl.contentrecommender.ChartContent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ContentGroup {
    private final String label;
    private final String description;
    private final List<ChartContent> contents = new ArrayList<ChartContent>();

    public ContentGroup(List<ChartContent> contents) {
        this.label = null;
        this.description = null;
        this.contents.addAll(contents);
    }

    @JsonCreator
    public ContentGroup(@JsonProperty(value="label") String label, @JsonProperty(value="description") String description, @JsonProperty(value="contents") List<ChartContent> contents) {
        this.label = label;
        this.description = description;
        this.contents.addAll(contents);
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ChartContent> getContents() {
        return Collections.unmodifiableList(this.contents);
    }

    public JSONObject toJSONObjcet() {
        JSONObject json = new JSONObject();
        json.put((Object)"label", (Object)this.label);
        json.put((Object)"description", (Object)this.description);
        JSONArray jsonContents = new JSONArray();
        this.contents.stream().forEach(c -> jsonContents.add((Object)c.toJSONObjcet()));
        json.put((Object)"contents", (Object)jsonContents);
        return json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContentGroup)) {
            return false;
        }
        ContentGroup that = (ContentGroup)o;
        return Objects.equals(this.getLabel(), that.getLabel()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getContents(), that.getContents());
    }

    public int hashCode() {
        return Objects.hash(this.getLabel(), this.getDescription(), this.getContents());
    }

    public String toString() {
        return super.toString();
    }
}

