/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.contentrecommender;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.ca.core.impl.contentrecommender.QualifierType;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.exceptions.json.JsonDeserializeException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrescriptionRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrescriptionRequest.class);
    private final String sourceModuleId;
    private final String sourceModule;
    private final String sourceModuleURI;
    private final String sourceType;
    private final String targetColumnId;
    private final QualifierType qualifier;
    private List<BaseFilter> filters = new ArrayList<BaseFilter>();
    private String tempModule;

    @JsonCreator
    public PrescriptionRequest(@JsonProperty(value="sourceModuleId") String sourceModuleId, @JsonProperty(value="sourceModule") String sourceModule, @JsonProperty(value="sourceModuleURI") String sourceModuleURI, @JsonProperty(value="sourceType") String sourceType, @JsonProperty(value="targetColumnId") String targetColumnId, @JsonProperty(value="qualifier") QualifierType qualifier, @JsonProperty(value="filters") List<BaseFilter> filters, @JsonProperty(value="tempModule") String tempModule) {
        this.sourceModuleId = sourceModuleId;
        this.sourceModule = sourceModule;
        this.sourceModuleURI = sourceModuleURI;
        this.sourceType = sourceType;
        this.targetColumnId = targetColumnId;
        this.qualifier = qualifier;
        this.filters = filters;
        this.setTempModule(tempModule);
    }

    public String getTargetColumnId() {
        return this.targetColumnId;
    }

    public QualifierType getQualifier() {
        return this.qualifier;
    }

    public List<BaseFilter> getFilters() {
        return this.filters;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public String getSourceModuleId() {
        return this.sourceModuleId;
    }

    public String getSourceModule() {
        return this.sourceModule;
    }

    public String getSourceModuleURI() {
        return this.sourceModuleURI;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String toJSON() {
        return CommonJAXBHelper.marshalToJSON((Object)this, (boolean)true);
    }

    public static PrescriptionRequest fromJSON(String str) {
        try {
            return (PrescriptionRequest)CommonJAXBHelper.unmarshalFromJSON(PrescriptionRequest.class, (String)str);
        }
        catch (JsonDeserializeException e) {
            LOGGER.error("Error parsing ExplainByComparison request", (Throwable)e);
            return null;
        }
    }

    public String getTempModule() {
        return this.tempModule;
    }

    public void setTempModule(String tempModule) {
        this.tempModule = tempModule;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filters == null ? 0 : this.filters.hashCode());
        result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        result = 31 * result + (this.sourceModule == null ? 0 : this.sourceModule.hashCode());
        result = 31 * result + (this.sourceModuleId == null ? 0 : this.sourceModuleId.hashCode());
        result = 31 * result + (this.sourceModuleURI == null ? 0 : this.sourceModuleURI.hashCode());
        result = 31 * result + (this.sourceType == null ? 0 : this.sourceType.hashCode());
        result = 31 * result + (this.targetColumnId == null ? 0 : this.targetColumnId.hashCode());
        result = 31 * result + (this.tempModule == null ? 0 : this.tempModule.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrescriptionRequest other = (PrescriptionRequest)obj;
        if (this.filters == null ? other.filters != null : !this.filters.equals(other.filters)) {
            return false;
        }
        if (this.qualifier != other.qualifier) {
            return false;
        }
        if (this.sourceModule == null ? other.sourceModule != null : !this.sourceModule.equals(other.sourceModule)) {
            return false;
        }
        if (this.sourceModuleId == null ? other.sourceModuleId != null : !this.sourceModuleId.equals(other.sourceModuleId)) {
            return false;
        }
        if (this.sourceModuleURI == null ? other.sourceModuleURI != null : !this.sourceModuleURI.equals(other.sourceModuleURI)) {
            return false;
        }
        if (this.sourceType == null ? other.sourceType != null : !this.sourceType.equals(other.sourceType)) {
            return false;
        }
        if (this.targetColumnId == null ? other.targetColumnId != null : !this.targetColumnId.equals(other.targetColumnId)) {
            return false;
        }
        return !(this.tempModule == null ? other.tempModule != null : !this.tempModule.equals(other.tempModule));
    }
}

