/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.store;

import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.ca.core.impl.content.CaContentRestClient;
import com.ibm.smarts.ca.core.impl.content.CaMoserRestClient;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.common.content.ContentObject;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.store.api.config.StoreConfig;
import com.ibm.smarts.store.api.provider.IDataSourceStore;
import java.util.List;

public class SmartsCaDataSourceStore
implements IDataSourceStore {
    CaMoserRestClient moserClient = null;
    CaContentRestClient cmClient = null;

    public SmartsCaDataSourceStore(StoreConfig storeConfig, RequestContext requestContext, String baseUri) {
        SmartsCaClientManager cm = (SmartsCaClientManager)((Object)((ObjectCreator)requestContext.getRequestAttribute("com.ibm.smarts.rest.clientManager")).create(requestContext));
        this.moserClient = cm.getMoserClient();
        this.cmClient = cm.getContentClient();
    }

    public List<ContentObject> getDataSources(String type) {
        List<ContentObject> objects = null;
        if ("module".equals(type)) {
            objects = this.moserClient.getModules();
        }
        return objects;
    }

    public SmartsModule getById(String moduleId) {
        return this.cmClient.getObjectSmartsModule(moduleId);
    }

    public ContentObject getObjectBaseModule(String objectId, String ... fields) {
        return this.cmClient.getObjectBaseModule(objectId, fields);
    }
}

