/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.store.util;

import com.ibm.smarts.ca.core.impl.search.CaSearchClient;
import com.ibm.smarts.core.resource.ResourceHelper;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import javax.ws.rs.WebApplicationException;

public final class SmartsCaIndexHelper {
    private static final String SCHEMA_RESOURCE_BASE_PATH = "/com/ibm/smarts/ca/search/";
    private final CaSearchClient client;

    public SmartsCaIndexHelper(CaSearchClient client) {
        this.client = client;
    }

    public void createIndexIfAbsent(String index, String schemaResName) {
        if (this.client.indexExists(index)) {
            return;
        }
        try {
            String schemaResPath = SCHEMA_RESOURCE_BASE_PATH.concat(schemaResName);
            String schema = ResourceHelper.stringFromResource((String)schemaResPath);
            this.client.createIndex(schema);
        }
        catch (JaxRs20Exceptions.ProcessingException ex) {
            WebApplicationException webAppEx;
            Throwable cause = ex.getCause();
            if (cause instanceof WebApplicationException && (webAppEx = (WebApplicationException)cause).getResponse().getStatus() == 409) {
                return;
            }
            throw ex;
        }
    }
}

