/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.userprofile;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ca.core.rest.client.CaRestClient;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.RequestContext;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public class CaUserProfileServiceRestClient
extends CaRestClient {
    public CaUserProfileServiceRestClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        super(rccf, requestContext, uri);
    }

    public JSONArray getUserInfo(String infoType) {
        CompletableFuture<JSONArray> future = this.getUserInfoAsync(infoType);
        return (JSONArray)this.get(future);
    }

    public CompletableFuture<JSONArray> getUserInfoAsync(String infoType) {
        return this.getAsync(Paths.getPath(infoType)).thenApply(jsonResponse -> this.parseResponse((String)jsonResponse, "userCapabilities"));
    }

    public JSONObject getUserProfileSettings(String infoType) {
        CompletableFuture<JSONObject> future = this.getUserProfileSettingsAsync(infoType);
        return (JSONObject)this.get(future);
    }

    public CompletableFuture<JSONObject> getUserProfileSettingsAsync(String infoType) {
        return this.getAsync(Paths.getPath(infoType)).thenApply(jsonResponse -> this.parseUserProfileSettingsResponse((String)jsonResponse));
    }

    public boolean canUseDashboard() {
        JSONArray capabilities = this.getUserInfo("capabilities");
        return capabilities.contains((Object)"canAuthorDashboard");
    }

    public boolean canUseAssistant() {
        JSONArray capabilities = this.getUserInfo("capabilities");
        return capabilities.contains((Object)"canUseAssistant");
    }

    public boolean canLearnFromUsage() {
        JSONArray capabilities = this.getUserInfo("capabilities");
        return capabilities.contains((Object)"canLearnFromProductUsage");
    }

    public boolean isLearningEnabled() {
        boolean enabled = false;
        JSONObject response = this.getUserProfileSettings("user_profile_settings");
        if (response != null) {
            enabled = (Boolean)response.getOrDefault((Object)LearningTypes.IMPLICIT_LEARNING.getValue(), (Object)false);
        }
        return enabled;
    }

    private JSONArray parseResponse(String response, String infoType) {
        if (response.isEmpty()) {
            return new JSONArray();
        }
        try {
            JSONObject responseJSON = JSONObject.parse((String)response);
            return (JSONArray)responseJSON.get((Object)infoType);
        }
        catch (IOException e) {
            LOGGER.warn(String.format("No %s found", infoType));
            return new JSONArray();
        }
    }

    private JSONObject parseUserProfileSettingsResponse(String response) {
        JSONObject parsedResponse = new JSONObject();
        if (StringUtils.isBlank((CharSequence)response)) {
            return parsedResponse;
        }
        try {
            parsedResponse = JSONObject.parse((String)response);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to parse");
        }
        return parsedResponse;
    }

    public static enum LearningTypes {
        IMPLICIT_LEARNING("implicit_learning");

        private String value;

        private LearningTypes(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Capabilities {
        private static final String CAN_AUTHOR_DASHBOARD = "canAuthorDashboard";
        private static final String CAN_USE_ASSISTANT = "canUseAssistant";
        private static final String CAN_LEARN_FROM_PROD_USAGE = "canLearnFromProductUsage";

        private Capabilities() {
        }
    }

    public static class ResponseType {
        public static final String USER_CAPABILITIES = "userCapabilities";

        private ResponseType() {
        }
    }

    public static class Paths {
        public static final String USERS = "/bi/v1/users/~/";
        public static final String CAPABILITIES = "capabilities";
        public static final String USER_PROFILE_SETTINGS = "user_profile_settings";

        private Paths() {
        }

        public static String getPath(String infoType) {
            return USERS + infoType;
        }
    }
}

