/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.rest.server.handlers;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.smarts.ca.core.rest.client.SmartsCaRestClientHelper;
import com.ibm.smarts.ca.core.rest.server.SmartsCaCoreRestHandlers;
import com.ibm.smarts.core.rest.server.BaseRestApi;
import com.ibm.smarts.core.util.RequestContext;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;

public class SmartsCaCoreBaseRestApi
extends BaseRestApi
implements SmartsCaCoreRestHandlers {
    private static final String PRODUCT_LOCALE = "productLocale";
    private static final String CONTENT_LOCALE = "contentLocale";
    private static final String EN = "en";
    private static final String USER_PREFERENCES_URL = "/bi/v1/users/~/preferences";
    private static final String COOKIE = "Cookie";
    private static final String X_CA_TRANSACTION = "X-CA-Transaction";
    private static Properties __static_caConfig;
    @Context
    protected HttpServletRequest httpServletRequest;
    protected Properties caConfig;
    JsonObject userPreferences = null;

    public static void setStaticCaConfig(Properties config) {
        __static_caConfig = config;
    }

    @PostConstruct
    public void setUpContext() {
        this.caConfig = __static_caConfig;
    }

    protected RequestContext extractRequestContext() {
        RequestContext rc = super.extractRequestContext();
        SmartsCaRestClientHelper.injectRCCF(rc, this.httpServletRequest);
        return rc;
    }

    protected Locale getLocale() {
        String s = this.getUserPreferenceValue(CONTENT_LOCALE, EN);
        return Locale.forLanguageTag(s);
    }

    protected Locale getProductLocale() {
        String s = this.getUserPreferenceValue(PRODUCT_LOCALE, EN);
        return Locale.forLanguageTag(s);
    }

    private String getUserPreferenceValue(String key, String defValue) {
        Object o;
        String value = defValue;
        if (this.userPreferences == null) {
            RESTClient client = RESTClientFactory.getInstance().getClient(this.httpServletRequest);
            try {
                client.getResource(this.caConfig.getProperty("smarts.ca.core.caServer.url") + USER_PREFERENCES_URL);
                this.userPreferences = client.getResponseAsJsonObject();
            }
            catch (IOException e) {
                LOGGER.error("Unable to retrieve setting " + key + " in user preferences.  Using default " + defValue + ".", (Throwable)e);
                return defValue;
            }
        }
        if ((o = this.userPreferences.get(key)) != null && o instanceof String) {
            value = (String)o;
        } else {
            LOGGER.error("Object retrieved from user preferences JSON was null or not a string for key " + key + ".  Using default " + defValue + ".");
        }
        return value;
    }

    @Override
    public Properties getCaConfig() {
        return this.caConfig;
    }
}

