/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.entity_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.crf.CRFDictionary;
import com.ibm.dltj.crf.FeatureMapping;
import com.ibm.dltj.crf.SimpleFeatureMapping;
import com.ibm.dltj.crf.feature.CSVFeatureTable;
import com.ibm.dltj.uima_annotator.entity_analysis.CASFeaturePath;
import com.ibm.dltj.uima_annotator.entity_analysis.CASFeaturePathFactory;
import com.ibm.dltj.uima_annotator.lex_analysis.TokenInfo;
import com.ibm.dltj.util.ArrayUtils;
import com.ibm.langware.annotator.Copyright;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.text.AnnotationFS;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class CASFeatureTable
extends CSVFeatureTable {
    private CAS _cas;
    private LowLevelCAS _llCas;
    private LowLevelTypeSystem _llTypeSystem;
    private int _featureCodeBegin;
    private int _featureCodeEnd;
    private int[] _begin = ArrayUtils.EMPTY_INT_ARRAY;
    private int[] _end = ArrayUtils.EMPTY_INT_ARRAY;
    private final ArrayList<BitSet> _typeSets = new ArrayList();
    private String _text;
    private int _tail;
    private CASFeaturePathFactory _factory;
    private final String[] _featurePaths;
    private HashMap<Type, CASFeaturePath[]> _featurePathMap;
    private final String _labelPath;
    private HashMap<Type, CASFeaturePath> _labelPathMap;

    CASFeatureTable(String[] stringArray, String string, FeatureMapping featureMapping) throws DLTException {
        super(stringArray.length, featureMapping);
        this._featurePaths = stringArray;
        this._labelPath = string;
    }

    public static CASFeatureTable newInstance(CRFDictionary cRFDictionary) throws DLTException {
        String[] stringArray = cRFDictionary.getFeaturePathList();
        assert (stringArray.length > 1);
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
        String string = null;
        if (cRFDictionary.isEditable()) {
            string = stringArray[stringArray.length - 1];
        }
        return new CASFeatureTable(stringArray2, string, (FeatureMapping)cRFDictionary.getFeatureMapping());
    }

    public static CASFeatureTable newInstance(String[] stringArray) throws DLTException {
        assert (stringArray.length > 1);
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
        String string = stringArray[stringArray.length - 1];
        return new CASFeatureTable(stringArray2, string, (FeatureMapping)new SimpleFeatureMapping());
    }

    public void setCas(CAS cAS) {
        assert (cAS != null);
        this._text = cAS.getDocumentText();
        this._tail = -1;
        if (this._cas == cAS) {
            return;
        }
        this._cas = cAS;
        this._llCas = cAS.getLowLevelCAS();
        this._llTypeSystem = this._llCas.ll_getTypeSystem();
        this._featureCodeBegin = this._llTypeSystem.ll_getCodeForFeatureName("uima.tcas.Annotation:begin");
        this._featureCodeEnd = this._llTypeSystem.ll_getCodeForFeatureName("uima.tcas.Annotation:end");
        assert (this._featureCodeBegin > 0);
        assert (this._featureCodeEnd > 0);
        this._factory = CASFeaturePathFactory.newInstance(this._cas, this._mapping);
        this._featurePathMap = new HashMap();
        this._labelPathMap = new HashMap();
    }

    int getBegin(int n) {
        if (n < 0 || n >= this._begin.length) {
            return 0;
        }
        return this._begin[n];
    }

    int getEnd(int n) {
        if (n < 0 || n >= this._end.length) {
            return 0;
        }
        return this._end[n];
    }

    private void setBegin(int n, int n2) {
        if (this._begin.length <= n) {
            this._begin = ArrayUtils.resize((int[])this._begin, (int)(n + 16));
        }
        this._begin[n] = n2;
    }

    private void setEnd(int n, int n2) {
        if (this._end.length <= n) {
            this._end = ArrayUtils.resize((int[])this._end, (int)(n + 16));
        }
        this._end[n] = n2;
    }

    int indexOfBegin(int n, int n2) {
        int n3 = this.getRowSize();
        while (0 < n && n2 <= this._begin[n]) {
            --n;
        }
        while (n < n3 - 1 && this._begin[n] < n2) {
            ++n;
        }
        return this._begin[n] == n2 ? n : -1;
    }

    int indexOfEnd(int n, int n2) {
        int n3 = this.getRowSize();
        while (n < n3 - 1 && this._end[n] < n2) {
            ++n;
        }
        return this._end[n] == n2 ? n : -1;
    }

    public int addToken() {
        int n = this.getRowSize();
        this.setBegin(n, 0);
        this.setEnd(n, 0);
        for (int i = 0; i < this._colSize; ++i) {
            this.setFeature(n, i, 1);
        }
        this.setLabel(n, null);
        return n;
    }

    public int addToken(AnnotationFS annotationFS) throws DLTException {
        assert (annotationFS != null);
        return this.addToken(this._llCas.ll_getFSRef((FeatureStructure)annotationFS));
    }

    public int addToken(int n) throws DLTException {
        assert (n > 0);
        int n2 = this.getRowSize();
        int n3 = 0;
        int n4 = this._llCas.ll_getIntValue(n, this._featureCodeBegin);
        int n5 = this._llCas.ll_getIntValue(n, this._featureCodeEnd);
        this.setBegin(n2, n4);
        this.setEnd(n2, n5);
        Type type = this._llTypeSystem.ll_getTypeForCode(this._llCas.ll_getFSRefType(n));
        CASFeaturePath[] cASFeaturePathArray = this.getFeaturePaths(type);
        for (CASFeaturePath cASFeaturePath : cASFeaturePathArray) {
            this.setFeature(n2, n3, cASFeaturePath.getValue(n, this._text, this._tail));
            ++n3;
        }
        if (this._labelPath != null) {
            CASFeaturePath cASFeaturePath = this.getLabelPath(type);
            this.setLabel(n2, cASFeaturePath.getValueString(n, this._text, this._tail));
        }
        assert (n3 == this._colSize);
        this._tail = n5;
        return n2;
    }

    public int addToken(TokenInfo tokenInfo) throws DLTException {
        assert (tokenInfo != null);
        int n = this.getRowSize();
        int n2 = 0;
        this.setBegin(n, tokenInfo.begin);
        this.setEnd(n, tokenInfo.end);
        Type type = this._llCas.ll_getTypeSystem().ll_getTypeForCode(this._llCas.ll_getFSRefType(tokenInfo.addr));
        CASFeaturePath[] cASFeaturePathArray = this.getFeaturePaths(type);
        for (CASFeaturePath cASFeaturePath : cASFeaturePathArray) {
            this.setFeature(n, n2, cASFeaturePath.getValue(tokenInfo, this._text, this._tail));
            ++n2;
        }
        if (this._labelPath != null) {
            CASFeaturePath cASFeaturePath = this.getLabelPath(type);
            this.setLabel(n, cASFeaturePath.getValueString(tokenInfo, this._text, this._tail));
        }
        assert (n2 == this._colSize);
        this._tail = tokenInfo.end;
        return n;
    }

    int getColumnIndex(String string) {
        return ArrayUtils.indexOf((String[])this._featurePaths, (String)string);
    }

    BitSet getTypeSet(int n) {
        BitSet bitSet;
        assert (n >= 0);
        if (this._typeSets.size() <= n) {
            this._typeSets.ensureCapacity(n);
            while (this._typeSets.size() <= n) {
                this._typeSets.add(null);
            }
        }
        if ((bitSet = this._typeSets.get(n)) == null) {
            bitSet = new BitSet();
            this._typeSets.set(n, bitSet);
        }
        return bitSet;
    }

    private CASFeaturePath[] getFeaturePaths(Type type) throws DLTException {
        CASFeaturePath[] cASFeaturePathArray = this._featurePathMap.get(type);
        if (cASFeaturePathArray == null) {
            cASFeaturePathArray = new CASFeaturePath[this._featurePaths.length];
            for (int i = 0; i < this._featurePaths.length; ++i) {
                cASFeaturePathArray[i] = this._factory.createCASFeaturePath(type, this._featurePaths[i], this._handler[i]);
            }
            this._featurePathMap.put(type, cASFeaturePathArray);
        }
        assert (cASFeaturePathArray != null);
        return cASFeaturePathArray;
    }

    private CASFeaturePath getLabelPath(Type type) throws DLTException {
        CASFeaturePath cASFeaturePath = this._labelPathMap.get(type);
        if (cASFeaturePath == null) {
            cASFeaturePath = this._factory.createCASFeaturePath(type, this._labelPath);
            this._labelPathMap.put(type, cASFeaturePath);
        }
        assert (cASFeaturePath != null);
        return cASFeaturePath;
    }
}

