/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.entity_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.crf.CRFDictionary;
import com.ibm.dltj.crf.CRFTagger;
import com.ibm.dltj.crf.FeatureMapping;
import com.ibm.dltj.crf.FeatureValueMapping;
import com.ibm.dltj.crf.feature.FeatureTable;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.uima_annotator.entity_analysis.BitIndexIterator;
import com.ibm.dltj.uima_annotator.entity_analysis.CASFeatureTable;
import com.ibm.dltj.uima_annotator.entity_analysis.LowLevelSubIterator;
import com.ibm.dltj.uima_annotator.entity_analysis.Method;
import com.ibm.dltj.uima_annotator.entity_analysis.Parameter;
import com.ibm.dltj.uima_annotator.util.TypeSystemUtil;
import com.ibm.dltj.util.IntArray;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelIndexRepository;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.util.Level;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
final class MethodCRFExtractor
extends Method {
    private final CRFTagger _tagger;
    private final CRFDictionary _dic;
    private final CASFeatureTable _table;
    private int _sofa;
    private Type _blockType;
    private Type _baseType;
    private List<Type> _extTypes;
    private int[] _typeMap;
    private final IntArray _queue = new IntArray();

    MethodCRFExtractor(UimaContext uimaContext, String string, File file) throws IOException, DLTException {
        super(uimaContext, string);
        this._dic = CRFDictionary.newInstance((File)file);
        this._tagger = new CRFTagger(this._dic);
        this._table = new CASFeatureTable(this._dic.getFeaturePathList(), null, (FeatureMapping)this._dic.getFeatureMapping());
        this._table.setHandler(this._dic.getFeatureHandlerList());
        assert (this._dic != null);
        assert (this._tagger != null);
        assert (this._table != null);
    }

    @Override
    void typeSystemInit(TypeSystem typeSystem) throws DLTException {
        super.typeSystemInit(typeSystem);
        TypeSystemUtil typeSystemUtil = new TypeSystemUtil(this._typeSystem);
        this._blockType = this._typeSystem.getType(this._dic.getAttribute((Object)Parameter.BlockTokenType.caps()));
        this._baseType = this._typeSystem.getType(this._dic.getAttribute((Object)Parameter.BaseTokenType.caps()));
        this._extTypes = typeSystemUtil.getTypeList(this._dic.getAttributeList((Object)Parameter.ExtTokenType.caps()));
        this._typeMap = typeSystemUtil.getTypeMap(this._extTypes);
        if (this._blockType == null && this._logger.isLoggable(Level.WARNING)) {
            this._logger.log(Level.WARNING, Messages.getFormattedMessage("EntityExtractor.Warning_parameter_not_found", new Object[]{this._language.getFullLanguage(), Parameter.BlockTokenType}));
        }
        if (this._baseType == null && this._logger.isLoggable(Level.WARNING)) {
            this._logger.log(Level.WARNING, Messages.getFormattedMessage("EntityExtractor.Warning_parameter_not_found", new Object[]{this._language.getFullLanguage(), Parameter.BaseTokenType}));
        }
        assert (this._extTypes != null);
        assert (this._typeMap != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void process(CAS cAS) throws DLTException {
        int n;
        assert (cAS != null);
        assert (cAS.getTypeSystem() == this._typeSystem);
        if (this._blockType == null) {
            return;
        }
        if (this._baseType == null) {
            return;
        }
        this._table.setCas(cAS);
        FeatureValueMapping featureValueMapping = this._dic.getFeatureMapping();
        int n2 = featureValueMapping.getFeature((CharSequence)"__nil__");
        int n3 = this._table.getColumnIndex("/:coveredType()");
        LowLevelCAS lowLevelCAS = cAS.getLowLevelCAS();
        SofaFS sofaFS = cAS.getSofa();
        this._sofa = sofaFS != null ? lowLevelCAS.ll_getFSRef((FeatureStructure)sofaFS) : 0;
        LowLevelIndexRepository lowLevelIndexRepository = lowLevelCAS.ll_getIndexRepository();
        LowLevelIterator lowLevelIterator = lowLevelIndexRepository.ll_getIndex("AnnotationIndex", this._llTypeSystem.ll_getCodeForType(this._blockType)).ll_iterator(false);
        LowLevelSubIterator lowLevelSubIterator = new LowLevelSubIterator(cAS, this._baseType);
        LowLevelSubIterator lowLevelSubIterator2 = new LowLevelSubIterator(cAS, this._extTypes);
        while (lowLevelIterator.isValid()) {
            n = lowLevelIterator.ll_get();
            try {
                int n4;
                int n5;
                lowLevelSubIterator.moveTo(n);
                while (lowLevelSubIterator.isValid()) {
                    n5 = lowLevelSubIterator.ll_get();
                    n4 = this._table.addToken(n5);
                    this._table.setLabel(n4, "__nil__");
                    lowLevelSubIterator.moveToNext();
                }
                if (!this._table.isEmpty()) {
                    int n6;
                    int n7;
                    if (n3 >= 0) {
                        BitSet bitSet;
                        n5 = 0;
                        n4 = 0;
                        lowLevelSubIterator2.moveTo(n);
                        while (lowLevelSubIterator2.isValid()) {
                            n7 = lowLevelSubIterator2.ll_get();
                            n6 = this._typeMap[lowLevelCAS.ll_getFSRefType(n7)];
                            if (n6 >= 0) {
                                if ((n5 = this._table.indexOfBegin(n5, lowLevelCAS.ll_getIntValue(n7, this._featureCodeBegin))) >= 0 && (n4 = this._table.indexOfEnd(n5, lowLevelCAS.ll_getIntValue(n7, this._featureCodeEnd))) >= n5) {
                                    while (n5 <= n4) {
                                        bitSet = this._table.getTypeSet(n5++);
                                        bitSet.set(n6);
                                    }
                                }
                                n5 = Math.max(n5, 0);
                            }
                            lowLevelSubIterator2.moveToNext();
                        }
                        n7 = this._table.getRowSize();
                        for (n6 = 0; n6 < n7; ++n6) {
                            bitSet = this._table.getTypeSet(n6);
                            if (bitSet.isEmpty()) {
                                this._table.setFeature(n6, n3, n2);
                                continue;
                            }
                            this._table.setFeature(n6, n3, featureValueMapping.getFeature((NetGeneric.IndexIterator)new BitIndexIterator(bitSet)));
                            bitSet.clear();
                        }
                    }
                    this._tagger.process((FeatureTable)this._table);
                    String string = null;
                    n4 = 0;
                    n7 = 0;
                    n6 = this._table.getRowSize();
                    for (int i = 0; i < n6; ++i) {
                        String string2 = ((Object)this._table.getLabel(i)).toString();
                        if (string == null) {
                            if (!string2.startsWith("B-")) continue;
                            string = string2.substring(2);
                            n4 = this._table.getBegin(i);
                            n7 = this._table.getEnd(i);
                            continue;
                        }
                        if (string2.startsWith("B-")) {
                            this.createAnnotation(lowLevelCAS, string, n4, n7);
                            string = string2.substring(2);
                            n4 = this._table.getBegin(i);
                            n7 = this._table.getEnd(i);
                            continue;
                        }
                        if (string2.startsWith("I-")) {
                            if (string2.regionMatches(2, string, 0, string.length())) {
                                n7 = this._table.getEnd(i);
                                continue;
                            }
                            this.createAnnotation(lowLevelCAS, string, n4, n7);
                            string = null;
                            n7 = 0;
                            n4 = 0;
                            continue;
                        }
                        if (!string2.equals("__nil__")) continue;
                        this.createAnnotation(lowLevelCAS, string, n4, n7);
                        string = null;
                        n7 = 0;
                        n4 = 0;
                    }
                    if (string != null) {
                        this.createAnnotation(lowLevelCAS, string, n4, this._table.getEnd(n6 - 1));
                    }
                }
            }
            finally {
                this._table.clear();
            }
            lowLevelIterator.moveToNext();
        }
        try {
            for (n = 0; n < this._queue.size(); ++n) {
                int n8 = this._queue.get(n);
                lowLevelIndexRepository.ll_addFS(n8);
            }
        }
        finally {
            this._queue.clear();
        }
    }

    @Override
    void collectionProcessComplete() throws DLTException {
    }

    private void createAnnotation(LowLevelCAS lowLevelCAS, String string, int n, int n2) {
        int n3;
        int n4;
        if (n < n2 && this._capability.isRequiredType(this._language.getFullLanguage(), string) && (n4 = this._llTypeSystem.ll_getCodeForTypeName(string)) > 0 && (n3 = lowLevelCAS.ll_createFS(n4)) > 0) {
            lowLevelCAS.ll_setRefValue(n3, this._featureCodeSofa, this._sofa);
            lowLevelCAS.ll_setIntValue(n3, this._featureCodeBegin, n);
            lowLevelCAS.ll_setIntValue(n3, this._featureCodeEnd, n2);
            this._queue.add(n3);
        }
    }
}

