/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis;

import com.ibm.dltj.CapMatrix;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.uima_annotator.AnalyzerContext;
import com.ibm.dltj.uima_annotator.ConfigurationManager;
import com.ibm.dltj.uima_annotator.ResultSpecManager;
import com.ibm.dltj.uima_annotator.TypeSystemManager;
import com.ibm.dltj.uima_annotator.implBase.AnalyzerContext_ImplBase;
import com.ibm.dltj.uima_annotator.lex_analysis.ConfigurationMgr;
import com.ibm.dltj.uima_annotator.lex_analysis.LanguageDictionaries;
import com.ibm.dltj.uima_annotator.lex_analysis.ResultSpecMgr;
import com.ibm.dltj.uima_annotator.lex_analysis.TypeSystemMgr;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import com.ibm.langware.annotator.jFrostResourceInitException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class LexicalAnalyzerContext
extends AnalyzerContext_ImplBase {
    private static final String CLASS_NAME = LexicalAnalyzerContext.class.getName();
    public final LanguageDictionaries mLanguageDicts;

    public LexicalAnalyzerContext(UimaContext uimaContext) throws ResourceInitializationException {
        super(uimaContext);
        try {
            this.mLanguageDicts = this.getNewLanguageDictionariesInstance(this);
        }
        catch (DLTException dLTException) {
            throw new jFrostResourceInitException(dLTException);
        }
    }

    public void preloadDictsForLanguages(String[] stringArray) throws AnalysisEngineProcessException {
        for (String string : stringArray) {
            this.mLanguageDicts.resetForLanguage(string);
        }
    }

    public void logDataPath(String string, String string2, String string3) {
        this.logMsg(Level.CONFIG, CLASS_NAME, "logDataPath", Messages.MessageKeys.LexicalAnalyzer__Using_frost_data_path__CONFIG.name(), string);
        if (string2 != null && string2.length() > 0) {
            this.logMsg(Level.CONFIG, CLASS_NAME, "logDataPath", Messages.MessageKeys.LexicalAnalyzer__Using_frost_break_iterator_file__CONFIG.name(), string2);
        }
        if (string3 != null && string3.length() > 0) {
            this.logMsg(Level.CONFIG, CLASS_NAME, "logDataPath", Messages.MessageKeys.LexicalAnalyzer__Using_decomposition_rules_file__CONFIG.name(), string3);
        }
    }

    public void logAvailableDicts() throws ResourceInitializationException {
        CapMatrix capMatrix = this.getConfigurationManager().getjFrostCapabilityMatrix();
        if (capMatrix == null) {
            this.logMsg(Level.CONFIG, CLASS_NAME, "logAvailableDicts", Messages.MessageKeys.LexicalAnalyzer__No_CapMatrix__CONFIG.name());
            return;
        }
        this.logAvailableDicts(capMatrix, 22, "Synonym");
        this.logAvailableDicts(capMatrix, 15, "Featureset");
        this.logAvailableDicts(capMatrix, 13, "Grammar");
        this.logAvailableDicts(capMatrix, 32, "JA-Morph");
        this.logAvailableDicts(capMatrix, 4, "JKomCol");
        this.logAvailableDicts(capMatrix, 23, "Phonetic Spelling");
    }

    private void logAvailableDicts(CapMatrix capMatrix, int n, String string) throws ResourceInitializationException {
        try {
            this.logMsg(Level.CONFIG, CLASS_NAME, "logAvailableDicts", Messages.MessageKeys.LexicalAnalyzer__Looking_for_Frost_dictionaries_of_type_X__CONFIG.name(), string, n);
            CapMatrix.Entry[] entryArray = capMatrix.getAvailableEntries("*", n);
            if (entryArray.length == 0) {
                this.logMsg(Level.CONFIG, CLASS_NAME, "logAvailableDicts", Messages.MessageKeys.LexicalAnalyzer__No_Frost_dictionaries_of_type_X_found__CONFIG.name(), string);
                return;
            }
            for (CapMatrix.Entry entry : entryArray) {
                this.log(Level.CONFIG, entry.getDescription());
            }
        }
        catch (Exception exception) {
            throw new jFrostResourceInitException("com.ibm.langware.annotator.messages", Messages.MessageKeys.FROST_EXCEPTION_ENCOUNTERED__SEVERE.name(), new Object[0], exception);
        }
    }

    protected LanguageDictionaries getNewLanguageDictionariesInstance(AnalyzerContext analyzerContext) throws DLTException {
        return new LanguageDictionaries(analyzerContext);
    }

    @Override
    protected ConfigurationManager getNewConfigMgrInstance(UimaContext uimaContext) {
        return new ConfigurationMgr(uimaContext);
    }

    @Override
    protected TypeSystemManager getNewTypeSystemMgrInstance() {
        return new TypeSystemMgr();
    }

    @Override
    protected ResultSpecManager getNewResultSpecMgrInstance() {
        return new ResultSpecMgr();
    }
}

