/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis;

import com.ibm.dltj.token.TokenType;
import com.ibm.dltj.uima_annotator.implBase.TypeSystemMgr_ImplBase;
import com.ibm.langware.annotator.Copyright;
import java.util.Arrays;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class TypeSystemMgr
extends TypeSystemMgr_ImplBase {
    public int mStartFeatCode;
    public int mEndFeatCode;
    public int mSofaFeatCode;
    protected int mParagraphTypeCode;
    protected int mParagraphNumFeatCode;
    protected int mSentenceTypeCode;
    protected int mSentenceNumFeatCode;
    public int mTokenTypeCode;
    protected int mMWUTypeCode;
    protected int mLemmaAtTokenFeatCode;
    protected int mLemmaEntriesListFeatCode;
    public int mDictionaryMatch;
    protected int mTokenNumFeatCode;
    protected int mTokenPropsFeatCode;
    protected int mFrostTokenTypeFeatCode;
    protected int mSynonymEntriesListFeatCode;
    public int mPosTagFeatCode;
    protected int mSynonymTypeCode;
    protected int mLemmaTypeCode;
    protected int mKeyFeatCode;
    protected int mPosFeatCode;
    protected int mIsLemmaStopwordFeatCode;
    protected int mFrostConstraintsFeatCode;
    protected int mFrostMorphBitMasksFeatCode;
    protected int mFrostExtPosFeatCode;
    protected int mFrostJPStartFeatCode;
    protected int mFrostJKomFeatCode;
    protected int mCompoundPartTypeCode;
    protected int mDecompFeatCode;
    protected int mDecompAnalysisTypeCode;
    protected int mDecompAnRouteFeatCode;
    private int[] mTokenSubtypeCodes;
    protected int mHeadFeatCode;
    protected int mTailFeatCode;
    protected int mNeFsListTypeCode;
    protected int mEFsListTypeCode;
    protected int mFsArrayTypeCode;
    protected int mIntArrayTypeCode;
    public int mStringArrayTypeCode;

    @Override
    public void initTypeSystem() throws AnalysisEngineProcessException {
        this.mStartFeatCode = this.initFeatureCode("uima.tcas.Annotation:begin", MANDATORY);
        this.mEndFeatCode = this.initFeatureCode("uima.tcas.Annotation:end", MANDATORY);
        this.mSofaFeatCode = this.initFeatureCode("uima.tcas.Annotation:sofa", MANDATORY);
        this.mParagraphTypeCode = this.initTypeCode("uima.tt.ParagraphAnnotation", MANDATORY);
        this.mParagraphNumFeatCode = this.initFeatureCode("uima.tt.ParagraphAnnotation:paragraphNumber", OPTIONAL);
        this.mSentenceTypeCode = this.initTypeCode("uima.tt.SentenceAnnotation", MANDATORY);
        this.mSentenceNumFeatCode = this.initFeatureCode("uima.tt.SentenceAnnotation:sentenceNumber", OPTIONAL);
        this.mTokenTypeCode = this.initTypeCode("uima.tt.TokenAnnotation", MANDATORY);
        this.mMWUTypeCode = this.initTypeCode("com.ibm.dlt.uimatypes.MWU", OPTIONAL);
        this.mLemmaAtTokenFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:lemma", OPTIONAL);
        this.mLemmaEntriesListFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:lemmaEntries", OPTIONAL);
        this.mDictionaryMatch = this.initFeatureCode("uima.tt.TokenAnnotation:dictionaryMatch", OPTIONAL);
        this.mTokenNumFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:tokenNumber", OPTIONAL);
        this.mTokenPropsFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:tokenProperties", OPTIONAL);
        this.mFrostTokenTypeFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:frost_TokenType", OPTIONAL);
        this.mSynonymEntriesListFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:synonymEntries", OPTIONAL);
        this.mPosTagFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:posTag", OPTIONAL);
        this.mSynonymTypeCode = this.initTypeCode("uima.tt.Synonym", this.mSynonymEntriesListFeatCode > 0);
        this.mLemmaTypeCode = this.initTypeCode("uima.tt.Lemma", MANDATORY);
        this.mKeyFeatCode = this.initFeatureCode("uima.tt.KeyStringEntry:key", MANDATORY);
        this.mPosFeatCode = this.initFeatureCode("uima.tt.Lemma:partOfSpeech", OPTIONAL);
        this.mIsLemmaStopwordFeatCode = this.initFeatureCode("uima.tt.Lemma:isStopword", OPTIONAL);
        this.mFrostConstraintsFeatCode = this.initFeatureCode("uima.tt.Lemma:frost_Constraints", OPTIONAL);
        this.mFrostMorphBitMasksFeatCode = this.initFeatureCode("uima.tt.Lemma:frost_MorphBitMasks", OPTIONAL);
        this.mFrostExtPosFeatCode = this.initFeatureCode("uima.tt.Lemma:frost_ExtendedPOS", OPTIONAL);
        this.mFrostJPStartFeatCode = this.initFeatureCode("uima.tt.Lemma:frost_JPStart", OPTIONAL);
        this.mFrostJKomFeatCode = this.initFeatureCode("uima.tt.Lemma:frost_JKom", OPTIONAL);
        this.mCompoundPartTypeCode = this.initTypeCode("uima.tt.CompPartAnnotation", MANDATORY);
        this.mDecompFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:decomposition", OPTIONAL);
        this.mDecompAnalysisTypeCode = this.initTypeCode("com.ibm.dlt.uimatypes.Decomp_Analysis", this.mDecompFeatCode > 0);
        this.mDecompAnRouteFeatCode = this.initFeatureCode("com.ibm.dlt.uimatypes.Decomp_Analysis:route", this.mDecompAnalysisTypeCode > 0);
        int n = 0;
        for (TokenType tokenType : TokenType.values()) {
            n = Math.max(n, tokenType.getRegexCode());
        }
        this.mTokenSubtypeCodes = new int[n + 1];
        Arrays.fill(this.mTokenSubtypeCodes, this.mTokenTypeCode);
        for (TokenType tokenType : TokenType.values()) {
            int n2 = this.initTypeCode(tokenType.getTokenTypeName(), OPTIONAL);
            if (n2 <= 0) {
                n2 = this.mTokenSubtypeCodes[tokenType.getParentRegexCode()];
            }
            this.mTokenSubtypeCodes[tokenType.getRegexCode()] = n2;
        }
        this.mHeadFeatCode = this.initFeatureCode("uima.cas.NonEmptyFSList:head", MANDATORY);
        this.mTailFeatCode = this.initFeatureCode("uima.cas.NonEmptyFSList:tail", MANDATORY);
        this.mNeFsListTypeCode = this.initTypeCode("uima.cas.NonEmptyFSList", MANDATORY);
        this.mEFsListTypeCode = this.initTypeCode("uima.cas.EmptyFSList", MANDATORY);
        this.mFsArrayTypeCode = this.initTypeCode("uima.cas.FSArray", MANDATORY);
        this.mIntArrayTypeCode = this.initTypeCode("uima.cas.IntegerArray", MANDATORY);
        this.mStringArrayTypeCode = this.initTypeCode("uima.cas.StringArray", MANDATORY);
    }

    public int getTokenSubtype(char[] cArray, int n, int n2) {
        TokenType tokenType = TokenType.valueOf((char[])cArray, (int)n, (int)n2);
        assert (tokenType != null);
        return this.mTokenSubtypeCodes[tokenType.getRegexCode()];
    }

    public boolean isSubtype(int n, int n2) {
        return this.subsumes(n, n2);
    }
}

