/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.pos_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.crf.CRFDictionary;
import com.ibm.dltj.crf.CRFTagger;
import com.ibm.dltj.crf.feature.FeatureTable;
import com.ibm.dltj.tagger.feature.DefaultTagHandler;
import com.ibm.dltj.tagger.feature.POSTag;
import com.ibm.dltj.tagger.feature.PennTag;
import com.ibm.dltj.tagger.feature.RawTagHandler;
import com.ibm.dltj.tagger.feature.SimplifiedTag;
import com.ibm.dltj.uima_annotator.entity_analysis.CASFeatureTable;
import com.ibm.dltj.uima_annotator.lex_analysis.TokenInfo;
import com.ibm.dltj.uima_annotator.pos_analysis.Method;
import com.ibm.dltj.uima_annotator.pos_analysis.PartOfSpeechAnnotationCreator;
import com.ibm.dltj.util.PooledList;
import com.ibm.langware.annotator.Copyright;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceConfigurationException;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
final class MethodCRF<T>
extends Method<T> {
    private final CRFTagger _tagger;
    private final CRFDictionary _dic;
    private final CASFeatureTable _table;

    MethodCRF(UimaContext uimaContext, String string, URL uRL) throws IOException, ResourceConfigurationException, DLTException {
        super(uimaContext, string, uRL);
        try {
            this._dic = CRFDictionary.newInstance((File)new File(uRL.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ResourceConfigurationException((Throwable)uRISyntaxException);
        }
        this._tagger = new CRFTagger(this._dic);
        this._table = CASFeatureTable.newInstance(this._dic);
        this._table.setHandler(this._dic.getFeatureHandlerList());
        Class<PennTag> clazz = this._dic.getLabelClass();
        if (clazz == null) {
            List list = this._dic.getLabelSet().getUserLabels();
            if (list.size() + 2 == PennTag.values().length && PennTag.containsAll((Collection)list)) {
                clazz = PennTag.class;
            } else if (list.size() + 2 == SimplifiedTag.values().length && SimplifiedTag.containsAll((Collection)list)) {
                clazz = SimplifiedTag.class;
            }
        }
        this._handler = clazz != null && Enum.class.isAssignableFrom(clazz) ? new DefaultTagHandler((Class)clazz) : new RawTagHandler("__state__", "__state__", "__nil__", null);
        assert (this._tagger != null);
        assert (this._handler != null);
        assert (this._dic != null);
        assert (this._table != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void invoke(CAS cAS, int n, int n2, PooledList<TokenInfo> pooledList, PartOfSpeechAnnotationCreator partOfSpeechAnnotationCreator) throws DLTException {
        try {
            this._table.setCas(cAS);
            int n3 = 0;
            for (Object object : pooledList) {
                if (((TokenInfo)((Object)object)).begin < n3) {
                    ((TokenInfo)((Object)object)).skipped = true;
                    continue;
                }
                this._table.addToken((TokenInfo)((Object)object));
                n3 = ((TokenInfo)((Object)object)).end;
            }
            this._tagger.process((FeatureTable)this._table);
            int n4 = 0;
            for (TokenInfo tokenInfo : pooledList) {
                CharSequence charSequence;
                if (tokenInfo.skipped) {
                    this.annotate(tokenInfo, null, partOfSpeechAnnotationCreator);
                    continue;
                }
                Object object = "__nil__".equals(charSequence = this._table.getLabel(n4++)) ? this._handler.getUnknownTag() : this._handler.parse(((Object)charSequence).toString());
                this.annotate(tokenInfo, object, partOfSpeechAnnotationCreator);
            }
            assert (n4 == this._table.getRowSize());
        }
        finally {
            this._table.clear();
        }
    }

    @Override
    protected final int seek(TokenInfo tokenInfo, T t) {
        int n = -1;
        if (t instanceof POSTag) {
            POSTag pOSTag = (POSTag)t;
            int n2 = 0;
            Iterator iterator = tokenInfo.iterator();
            while (iterator.hasNext()) {
                TokenInfo.LemmaEntry lemmaEntry = (TokenInfo.LemmaEntry)((Object)iterator.next());
                if (pOSTag.matches(lemmaEntry.pos)) {
                    return n2;
                }
                if (n < 0 && pOSTag.matches(lemmaEntry.pos, false)) {
                    n = n2;
                }
                ++n2;
            }
        }
        return n;
    }
}

