/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.util;

import com.ibm.dltj.util.IntArray;
import com.ibm.langware.annotator.Copyright;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.LowLevelTypeSystem;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class TypeSystemUtil {
    private final LowLevelTypeSystem _llTypeSystem;
    private final int _typeCodeSize;

    public TypeSystemUtil(TypeSystem typeSystem) {
        this(typeSystem.getLowLevelTypeSystem());
    }

    public TypeSystemUtil(LowLevelTypeSystem lowLevelTypeSystem) {
        assert (lowLevelTypeSystem != null);
        this._llTypeSystem = lowLevelTypeSystem;
        int n = 1;
        while (this._llTypeSystem.ll_isValidTypeCode(n)) {
            ++n;
        }
        this._typeCodeSize = n;
    }

    public final int getTypeCode(String string, boolean bl) throws AnalysisEngineProcessException {
        if (this._llTypeSystem != null) {
            int n = this._llTypeSystem.ll_getCodeForTypeName(string);
            if (n > 0) {
                return n;
            }
            if (!bl) {
                return -1;
            }
        }
        throw new AnalysisEngineProcessException("annotator_ex_type_not_found", new Object[]{TypeSystemUtil.class.getName(), string});
    }

    public final int getFeatureCode(String string, boolean bl) throws AnalysisEngineProcessException {
        if (this._llTypeSystem != null) {
            int n = this._llTypeSystem.ll_getCodeForFeatureName(string);
            if (n > 0) {
                return n;
            }
            if (!bl) {
                return -1;
            }
        }
        throw new AnalysisEngineProcessException("annotator_ex_feature_not_found", new Object[]{this.getClass(), string});
    }

    public boolean subsumes(int n, int n2) {
        return this._llTypeSystem.ll_subsumes(n, n2);
    }

    public int getSuperAnnotationTypeCode(int[] nArray) throws AnalysisEngineProcessException {
        int n = this.getCommonSuperTypeCode(this.getTypeCode("uima.tcas.Annotation", true), nArray);
        if (n == -1) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int n2 : nArray) {
                stringBuilder.append(this._llTypeSystem.ll_getTypeForCode(n2).getName());
                stringBuilder.append(',');
            }
            throw new AnalysisEngineProcessException("annotator_ex_type_not_found", new Object[]{this.getClass().getName(), stringBuilder.toString()});
        }
        return n;
    }

    private int getCommonSuperTypeCode(int n, int[] nArray) {
        int[] nArray2 = this.ll_getSubsumedTypes(n);
        int[] nArray3 = nArray;
        int n2 = nArray3.length;
        block0: for (int i = 0; i < n2; ++i) {
            int n3 = nArray3[i];
            for (int n4 : nArray2) {
                if (n3 == n4) continue block0;
            }
            return -1;
        }
        for (int n5 : nArray3 = this.ll_getDirectSubtypes(n)) {
            int n6 = this.getCommonSuperTypeCode(n5, nArray);
            if (n6 == -1) continue;
            return n6;
        }
        return n;
    }

    private int[] ll_getSubsumedTypes(int n) {
        IntArray intArray = new IntArray();
        for (int i = 1; i < this._typeCodeSize; ++i) {
            assert (this._llTypeSystem.ll_isValidTypeCode(i));
            if (!this._llTypeSystem.ll_subsumes(n, i)) continue;
            intArray.add(i);
        }
        return intArray.toArray();
    }

    private int[] ll_getDirectSubtypes(int n) {
        IntArray intArray = new IntArray();
        for (int i = 1; i < this._typeCodeSize; ++i) {
            assert (this._llTypeSystem.ll_isValidTypeCode(i));
            if (n != this._llTypeSystem.ll_getParentType(i)) continue;
            intArray.add(i);
        }
        return intArray.toArray();
    }

    public int getTypesCount() {
        return this._typeCodeSize;
    }

    public boolean isSubType(String string, Type type) {
        return this.isSubType(this._llTypeSystem.ll_getCodeForTypeName(string), this._llTypeSystem.ll_getCodeForType(type), true);
    }

    public boolean isSubType(String string, Type type, boolean bl) {
        return this.isSubType(this._llTypeSystem.ll_getCodeForTypeName(string), this._llTypeSystem.ll_getCodeForType(type), bl);
    }

    public boolean isSubType(Type type, Type type2) {
        return this.isSubType(this._llTypeSystem.ll_getCodeForType(type), this._llTypeSystem.ll_getCodeForType(type2), true);
    }

    public boolean isSubType(Type type, Type type2, boolean bl) {
        if (type == null) {
            return false;
        }
        return this.isSubType(this._llTypeSystem.ll_getCodeForType(type), this._llTypeSystem.ll_getCodeForType(type2), bl);
    }

    public boolean isSubType(int n, int n2, boolean bl) {
        if (n == 0 || n2 == 0) {
            return false;
        }
        if (!bl && n == n2) {
            return false;
        }
        return this._llTypeSystem.ll_subsumes(n, n2);
    }

    public boolean isSubType(Collection<Type> collection, Type type) {
        return this.isSubType(collection, type, true);
    }

    public boolean isSubType(Collection<Type> collection, Type type, boolean bl) {
        assert (collection != null);
        assert (type != null);
        for (Type type2 : collection) {
            if (!this.isSubType(type2, type, bl)) continue;
            return true;
        }
        return false;
    }

    public List<Type> getTypeList(List<String> list) {
        ArrayList<Type> arrayList = new ArrayList<Type>(list.size());
        for (String string : list) {
            int n = this._llTypeSystem.ll_getCodeForTypeName(string);
            arrayList.add(n > 0 ? this._llTypeSystem.ll_getTypeForCode(n) : null);
        }
        if (arrayList.isEmpty()) {
            return Collections.emptyList();
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public List<String> getTypeNameList(List<Type> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Type type : list) {
            arrayList.add(type != null ? type.getName() : null);
        }
        if (arrayList.isEmpty()) {
            return Collections.emptyList();
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public int[] getTypeMap(List<Type> list) {
        int[] nArray = new int[this._typeCodeSize];
        Arrays.fill(nArray, -1);
        block0: for (int i = 1; i < this._typeCodeSize; ++i) {
            assert (this._llTypeSystem.ll_isValidTypeCode(i));
            int n = i;
            while (n > 0) {
                for (int j = 0; j < list.size(); ++j) {
                    if (n != this._llTypeSystem.ll_getCodeForType(list.get(j))) continue;
                    nArray[i] = j;
                    continue block0;
                }
                n = this._llTypeSystem.ll_getParentType(n);
            }
        }
        return nArray;
    }
}

