/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.langware.annotator;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.nondeterm.AdvancedLookupDriver;
import com.ibm.dltj.uima_annotator.lex_analysis.DictionariesCacheManager;
import com.ibm.icu.text.Normalizer;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.util.ArrayList;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class SpellSuggestionsCreator {
    private AdvancedLookupDriver mAdvancedLookupDriver = null;
    private String mQueryLanguage = "";
    private Dictionary[] mSpellMatchDicts = null;
    private Dictionary[] mTCRDicts = null;

    public SpellSuggestionsCreator() {
    }

    public SpellSuggestionsCreator(String string, String[] stringArray, String[] stringArray2) throws Exception {
        this.setLanguageResources(string, stringArray, stringArray2);
    }

    public synchronized void setLanguageResources(String string, String[] stringArray, String[] stringArray2) throws Exception {
        this.mQueryLanguage = string;
        this.mSpellMatchDicts = this.getDictsFromCacheMgr(stringArray);
        this.mTCRDicts = this.getDictsFromCacheMgr(stringArray2);
        this.mAdvancedLookupDriver = new AdvancedLookupDriver(this.mSpellMatchDicts);
        this.mAdvancedLookupDriver.allowExactMatch = false;
        this.mAdvancedLookupDriver.extraRanking = true;
        this.mAdvancedLookupDriver.strictMWU = true;
        this.mAdvancedLookupDriver.doWhiteSpaces = true;
        this.mAdvancedLookupDriver.whiteSpaceTokenization = true;
        if (this.mQueryLanguage.equalsIgnoreCase("ja")) {
            this.mAdvancedLookupDriver.doKatakanaMiddleDot = true;
        }
    }

    public Suggestion[] getSuggestions(String string, int n) {
        Suggestion[] suggestionArray;
        if (this.mQueryLanguage.equalsIgnoreCase("ja")) {
            return new Suggestion[0];
        }
        if (this.mSpellMatchDicts == null || this.mSpellMatchDicts.length == 0 || this.mAdvancedLookupDriver == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return new Suggestion[0];
        }
        Suggestion suggestion = this.getSuggestionsForQuery(string, n);
        if (suggestion != null) {
            Suggestion[] suggestionArray2 = new Suggestion[1];
            suggestionArray = suggestionArray2;
            suggestionArray2[0] = suggestion;
        } else {
            suggestionArray = new Suggestion[]{};
        }
        return suggestionArray;
    }

    private synchronized Suggestion getSuggestionsForQuery(String string, int n) {
        String[] stringArray = this.getSuggestionsForString(string, n);
        return stringArray.length > 0 ? new Suggestion(stringArray, 0, 1) : null;
    }

    /*
     * Unable to fully structure code
     */
    private String[] getSuggestionsForString(String var1_1, int var2_2) {
        var3_3 = new ArrayList<String>();
        if (var1_1 == null || var1_1.equals("")) {
            return new String[0];
        }
        if (this.mTCRDicts == null || this.mTCRDicts.length == 0) {
            try {
                this.mAdvancedLookupDriver.obeyRules = false;
                var4_4 = this.mAdvancedLookupDriver.match(var1_1, 3, var2_2);
                if (var4_4 == null) ** GOTO lbl41
                for (String var8_15 : var4_4) {
                    if (this.mQueryLanguage.equalsIgnoreCase("ja")) {
                        var9_17 = Normalizer.normalize((String)var8_15, (Normalizer.Mode)Normalizer.NFKC);
                        var3_3.add(var9_17);
                        continue;
                    }
                    var3_3.add(var8_15);
                }
            }
            catch (DLTException var4_5) {}
        } else {
            for (var4_6 = 0; var4_6 < this.mTCRDicts.length; ++var4_6) {
                try {
                    this.mAdvancedLookupDriver.setRules(this.mTCRDicts[var4_6]);
                    var5_9 = this.mAdvancedLookupDriver.match(var1_1, 3, var2_2);
                    if (var5_9 == null) continue;
                    for (String var9_18 : var5_9) {
                        if (this.mQueryLanguage.equalsIgnoreCase("ja")) {
                            var10_19 = Normalizer.normalize((String)var9_18, (Normalizer.Mode)Normalizer.NFKC);
                            if (var4_6 != 0 && var3_3.indexOf(var10_19) >= 0) continue;
                            var3_3.add(var10_19);
                            continue;
                        }
                        if (var4_6 != 0 && var3_3.indexOf(var9_18) >= 0) continue;
                        var3_3.add(var9_18);
                    }
                    continue;
                }
                catch (DLTException var5_10) {
                    // empty catch block
                }
            }
        }
lbl41:
        // 4 sources

        var4_7 = new String[var3_3.size()];
        return var3_3.toArray(var4_7);
    }

    private Dictionary[] getDictsFromCacheMgr(String[] stringArray) throws Exception {
        DictionariesCacheManager dictionariesCacheManager = DictionariesCacheManager.getInstance();
        if (dictionariesCacheManager == null) {
            throw new Exception(Messages.getMessage(Messages.MessageKeys.SpellSuggestionsCreator__Cannot_retrieve_dictionaries.name()));
        }
        ArrayList<Dictionary> arrayList = new ArrayList<Dictionary>();
        Dictionary dictionary = null;
        if (stringArray != null) {
            for (String string : stringArray) {
                try {
                    dictionary = dictionariesCacheManager.getDictionaryByFilename(string);
                }
                catch (DLTException dLTException) {
                    continue;
                }
                if (dictionary == null) continue;
                arrayList.add(dictionary);
            }
        }
        String[] stringArray2 = new Dictionary[arrayList.size()];
        return (Dictionary[])arrayList.toArray(stringArray2);
    }

    public class Suggestion {
        private final String[] suggestions;
        private final int fromTokenNumber;
        private final int toTokenNumber;

        public Suggestion(String[] stringArray, int n, int n2) {
            this.suggestions = stringArray;
            this.fromTokenNumber = n;
            this.toTokenNumber = n2;
        }

        public String[] getSuggestions() {
            return this.suggestions;
        }

        public int getFromTokenNumber() {
            return this.fromTokenNumber;
        }

        public int getToTokenNumber() {
            return this.toTokenNumber;
        }
    }
}

