/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.utils;

import com.ibm.bi.platform.commons.http.BIHttpClientPool;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BaseUpgrade {
    private static final String VALUE = "value";
    protected static final String SEARCH_PATH = "searchPath";
    private static final String APPLICATION_JSON = "application/json";
    private static final String ACCEPT = "accept";
    private static final String CONTENT_TYPE = "Content-Type";
    protected static final String PARAMS_OPTION = "-params";
    protected static final String NAMESPACE_OPTION = "-n";
    protected static final String USER_OPTION = "-u";
    protected static final String INSTALL_OPTION = "-i";
    protected static final String PWD_OPTION = "-p";
    protected static final String CONVERT_OPTION = "-d";
    protected static final String LAST_USED_OPTION = "-l";
    protected static final String IGNORE_SSL = "-k";
    protected static final String VERBOSE_OPTION = "-v";
    protected static final String URL_OPTION = "-h";
    protected static final String UTF_8 = "UTF-8";
    protected static final String NEWLINE = System.getProperty("line.separator");
    private static final String COOKIE = "Cookie";
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String XSRF_TOKEN = "XSRF-TOKEN";
    private static final String X_XSRF_TOKEN = "X-XSRF-TOKEN";
    private static final String MODELING_SERVICE_URL = "/bi/v1/metadata/";
    private static final String SEARCH_SERVICE_URL = "/bi/v1/search/cm";
    protected static final String TASKID_OPTION = "-t";
    protected static final String SEARCH_OPTION = "-s";
    protected static final String SMART_OPTION = "-m";
    protected static final String SMART_ONLY = "-a";
    private static final String BASE_URL_LOGON = "/bi/v1/login";
    private static final Set<String> OPTIONS = new HashSet<String>(Arrays.asList("-params", "-n", "-u", "-i", "-p", "-d", "-l", "-v", "-h", "-k", "-s", "-t"));
    HTTPClientBase httpClient;
    protected String namespace;
    protected String user;
    protected String password;
    private URL dispURL;

    public BaseUpgrade(String namespace, String user, String password, boolean verbose, URL url, boolean ignoreSSL) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        this.namespace = namespace;
        this.user = user;
        this.password = password;
        this.dispURL = url;
        this.httpClient = new HTTPUpgradeClient(this.dispURL, verbose);
        this.httpClient.init(ignoreSSL);
    }

    public BaseUpgrade(String namespace, String user, String password, boolean verbose, URL url) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        this.namespace = namespace;
        this.user = user;
        this.password = password;
        this.dispURL = url;
        this.httpClient = new BIUpgradeClient(this.dispURL, verbose);
        this.httpClient.init(false);
    }

    protected void terminate() throws IOException {
        try {
            if (this.httpClient != null) {
                this.httpClient.terminate();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    static String findNameAttribute(String lookupName, Node node, NamedNodeMap attr) {
        Node name = attr.getNamedItem("name");
        if (lookupName.equals(name.getTextContent())) {
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = node.getChildNodes().item(j);
                if (child.getTextContent().contains("\n")) continue;
                return child.getTextContent();
            }
        }
        return null;
    }

    static String findConfig(File configFile, String lookupName) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setExpandEntityReferences(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document config = documentBuilder.parse(configFile);
        NodeList nodes = config.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String value;
            Node node = nodes.item(i);
            NamedNodeMap attr = node.getAttributes();
            if (attr == null || (value = BaseUpgrade.findNameAttribute(lookupName, node, attr)) == null) continue;
            return value.replaceFirst("/bi/v1/disp", "");
        }
        return null;
    }

    protected String getSearchService(String path) throws IOException {
        StringBuilder url = new StringBuilder(this.dispURL.toString());
        url.append(SEARCH_SERVICE_URL);
        url.append(path);
        return url.toString();
    }

    protected String getModelingService(String path) throws IOException {
        StringBuilder url = new StringBuilder(this.dispURL.toString());
        url.append(MODELING_SERVICE_URL);
        url.append(path);
        return url.toString();
    }

    protected boolean doLogon() throws IOException {
        int status = this.httpClient.loginAs();
        if (this.namespace == null) {
            return status == 200;
        }
        this.httpClient.loginAs(this.createLoginJSON());
        return this.httpClient.loginAs(BaseUpgrade.createLoginJSON(this.namespace, this.user, this.password)) == 200;
    }

    private static JSONObject createLoginJSON(String namespace, String user, String password) {
        JSONObject loginObject = new JSONObject();
        if (BaseUpgrade.isEmpty(namespace) || BaseUpgrade.isEmpty(user) || BaseUpgrade.isEmpty(password)) {
            return loginObject;
        }
        JSONObject namespaceObject = new JSONObject();
        namespaceObject.put((Object)"name", (Object)"CAMNamespace");
        namespaceObject.put((Object)VALUE, (Object)namespace);
        JSONObject userObject = new JSONObject();
        userObject.put((Object)"name", (Object)"CAMUsername");
        userObject.put((Object)VALUE, (Object)user);
        JSONObject passwordObject = new JSONObject();
        passwordObject.put((Object)"name", (Object)"CAMPassword");
        passwordObject.put((Object)VALUE, (Object)password);
        JSONArray parametersObject = new JSONArray();
        parametersObject.add((Object)namespaceObject);
        parametersObject.add((Object)userObject);
        parametersObject.add((Object)passwordObject);
        loginObject.put((Object)"parameters", (Object)parametersObject);
        return loginObject;
    }

    private JSONObject createLoginJSON() {
        JSONObject loginObject = new JSONObject();
        if (BaseUpgrade.isEmpty(this.namespace) || BaseUpgrade.isEmpty(this.user) || BaseUpgrade.isEmpty(this.password)) {
            return loginObject;
        }
        JSONObject namespaceObject = new JSONObject();
        namespaceObject.put((Object)"name", (Object)"CAMNamespace");
        namespaceObject.put((Object)VALUE, (Object)this.namespace);
        JSONArray parametersObject = new JSONArray();
        parametersObject.add((Object)namespaceObject);
        loginObject.put((Object)"parameters", (Object)parametersObject);
        return loginObject;
    }

    public static String getString(InputStream is) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = is.read()) != -1) {
            sb.append((char)ch);
        }
        return sb.toString();
    }

    protected static Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            int next;
            if (VERBOSE_OPTION.equals(args[i])) {
                m.put(args[i], "true");
            }
            if (CONVERT_OPTION.equals(args[i])) {
                m.put(args[i], "true");
            }
            if (IGNORE_SSL.equals(args[i])) {
                m.put(args[i], "true");
            }
            if (SMART_OPTION.equals(args[i])) {
                m.put(args[i], "true");
            }
            if (SMART_ONLY.equals(args[i])) {
                m.put(args[i], "true");
                continue;
            }
            if (!OPTIONS.contains(args[i]) || (next = i + 1) >= args.length || OPTIONS.contains(args[next])) continue;
            m.put(args[i], args[next]);
        }
        return m;
    }

    protected static String[] parseLine(byte[] line) {
        ArrayList<String> argList = new ArrayList<String>();
        try (Scanner sc = new Scanner((InputStream)new ByteArrayInputStream(line), UTF_8);){
            while (sc.hasNext()) {
                if (sc.hasNext("\\\".*")) {
                    String quotedString = sc.findInLine("\\\".*?\\\"");
                    if (quotedString == null) continue;
                    argList.add(quotedString.substring(1, quotedString.length() - 1));
                    continue;
                }
                argList.add(sc.next());
            }
        }
        String[] args = new String[argList.size()];
        return argList.toArray(args);
    }

    protected static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    protected static void printError(Object s) {
        System.err.println(s);
    }

    protected static void printOutput(Object s) {
        try {
            System.out.println(s);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    protected static class HTTPUpgradeClient
    extends HTTPClientBase {
        public HTTPUpgradeClient(URL dispURL, boolean verbose) {
            super(dispURL, verbose);
        }

        @Override
        protected CloseableHttpClient createHTTPClient(boolean ignoreSSL) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
            BaseUpgrade.printOutput("HTTP Client");
            if (ignoreSSL) {
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (x509CertChain, authType) -> true).build();
                return HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSSLContext(sslContext).build();
            }
            return HttpClients.createDefault();
        }

        @Override
        protected void terminate() throws IOException {
            this.httpClient.close();
        }
    }

    protected static class BIUpgradeClient
    extends HTTPClientBase {
        private BIHttpClientPool clientPool = new BIHttpClientPool();

        public BIUpgradeClient(URL dispURL, boolean verbose) {
            super(dispURL, verbose);
        }

        @Override
        protected CloseableHttpClient createHTTPClient(boolean ignoreSSL) {
            BaseUpgrade.printOutput("BI Client");
            this.clientPool.initialize();
            return this.clientPool.getClient();
        }

        @Override
        protected void terminate() throws IOException {
            this.httpClient.close();
            this.clientPool.terminate();
        }
    }

    protected static abstract class HTTPClientBase {
        protected CloseableHttpClient httpClient = null;
        protected Map<String, String> cookies = new HashMap<String, String>();
        protected String xsrfHeader = null;
        protected final URL dispURL;
        protected final boolean verbose;

        public HTTPClientBase(URL dispURL, boolean verbose) {
            this.dispURL = dispURL;
            this.verbose = verbose;
            System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
        }

        public void init(boolean ignoreSSL) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
            this.httpClient = this.createHTTPClient(ignoreSSL);
        }

        protected abstract CloseableHttpClient createHTTPClient(boolean var1) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException;

        protected abstract void terminate() throws IOException;

        protected String getLoginService(String path) throws IOException {
            StringBuilder url = new StringBuilder(this.dispURL.toString());
            url.append(BaseUpgrade.BASE_URL_LOGON);
            url.append(path);
            return url.toString();
        }

        public int loginAs() throws IOException {
            HttpGet request = new HttpGet(this.getLoginService(""));
            return this.doLogonRequest((HttpRequestBase)request).getStatusLine().getStatusCode();
        }

        public int loginAs(JSONObject json) throws IOException {
            HttpPost post = new HttpPost(this.getLoginService(""));
            post.setEntity((HttpEntity)new StringEntity(json.toString()));
            post.setHeader(BaseUpgrade.CONTENT_TYPE, BaseUpgrade.APPLICATION_JSON);
            CloseableHttpResponse response = this.doLogonRequest((HttpRequestBase)post);
            return response.getStatusLine().getStatusCode();
        }

        protected CloseableHttpResponse doLogonRequest(HttpRequestBase request) throws IOException {
            request.addHeader(BaseUpgrade.ACCEPT, BaseUpgrade.APPLICATION_JSON);
            try (CloseableHttpResponse response = this.executeHttpRequestWithCookies(request);){
                int statusCode;
                CloseableHttpResponse headers;
                for (Header header : headers = response.getHeaders(BaseUpgrade.SET_COOKIE)) {
                    List<HttpCookie> setCookies = HttpCookie.parse(header.getValue());
                    for (HttpCookie cookie : setCookies) {
                        this.cookies.put(cookie.getName(), header.getValue());
                        if (this.xsrfHeader != null || !BaseUpgrade.XSRF_TOKEN.equals(cookie.getName())) continue;
                        this.xsrfHeader = cookie.getValue();
                    }
                }
                if (this.verbose && (statusCode = response.getStatusLine().getStatusCode()) != 200) {
                    HttpEntity entity = response.getEntity();
                    BaseUpgrade.printError(entity != null ? BaseUpgrade.getString(entity.getContent()) : "");
                    BaseUpgrade.printError(response);
                }
                CloseableHttpResponse closeableHttpResponse = response;
                return closeableHttpResponse;
            }
        }

        public String doPut(String url, HttpEntity entity, Integer expectedStatus, String expectedResponse) throws IOException {
            HttpPut httpPut = new HttpPut(url);
            httpPut.setHeader(BaseUpgrade.CONTENT_TYPE, BaseUpgrade.APPLICATION_JSON);
            if (entity != null) {
                httpPut.setEntity(entity);
            }
            return this.doHttpRequest((HttpRequestBase)httpPut, expectedStatus, expectedResponse, null);
        }

        public String doGet(String url, Integer expectedStatus, String expectedResult, List<Header> returnedHeaders) throws IOException {
            HttpGet getRequest = new HttpGet(url);
            getRequest.addHeader(BaseUpgrade.ACCEPT, BaseUpgrade.APPLICATION_JSON);
            return this.doHttpRequest((HttpRequestBase)getRequest, expectedStatus, expectedResult, returnedHeaders);
        }

        protected String doHttpRequest(HttpRequestBase getRequest, Integer expectedStatus, String expectedResult, List<Header> returnedHeaders) throws IOException {
            String result;
            block17: {
                result = null;
                try (CloseableHttpResponse response = this.executeHttpRequestWithCookies(getRequest);){
                    Header[] headers;
                    HttpEntity entity;
                    if (returnedHeaders != null) {
                        returnedHeaders.addAll(Arrays.asList(response.getAllHeaders()));
                    }
                    if ((entity = response.getEntity()) != null) {
                        result = BaseUpgrade.getString(entity.getContent());
                    }
                    if (!(expectedResult == null || result != null && result.contains(expectedResult))) {
                        BaseUpgrade.printOutput("Unexpected result : '" + result + "' instead of :'" + expectedResult + "'");
                    }
                    if (expectedStatus != null && !expectedStatus.equals(response.getStatusLine().getStatusCode())) {
                        BaseUpgrade.printOutput("Status :'" + response.getStatusLine().getStatusCode() + "' instead of :" + expectedStatus);
                        BaseUpgrade.printOutput("Unexpected result : '" + result);
                    }
                    if (!(getRequest instanceof HttpPost) || result != null && !result.isEmpty()) break block17;
                    for (Header current : headers = response.getAllHeaders()) {
                        if (!current.getName().equals("Location")) continue;
                        String id = current.getValue();
                        result = id.substring(id.lastIndexOf(47) + 1);
                        break;
                    }
                }
            }
            return result;
        }

        protected CloseableHttpResponse executeHttpRequestWithCookies(HttpRequestBase request) throws IOException {
            for (String cookie : this.cookies.values()) {
                request.addHeader(BaseUpgrade.COOKIE, cookie);
                if (!this.verbose) continue;
                BaseUpgrade.printError(cookie);
            }
            if (this.xsrfHeader != null) {
                request.addHeader(BaseUpgrade.X_XSRF_TOKEN, this.xsrfHeader);
            }
            RequestConfig config = RequestConfig.custom().setCookieSpec(null).build();
            request.setConfig(config);
            return this.httpClient.execute((HttpUriRequest)request);
        }
    }
}

