/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.model.overwrites.OverwriteMap;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.UsageType;
import com.ibm.smarts.schema.util.JAXBHelper;
import java.util.Collections;
import java.util.List;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class ConceptAssertion
extends AbstractSmartsModuleClassificationStep {
    private List<Ontology<OWLOntology>> mOntologies = null;

    protected ConceptAssertion(List<Ontology<OWLOntology>> ontologies, RequestContext requestContext) {
        super(requestContext);
        this.mOntologies = ontologies;
    }

    @Override
    public void execute(SmartsModuleClassificationPkg smPkg) {
        Ontology<OWLOntology> ontology = this.mOntologies.get(0);
        OWLDataFactory factory = ((OWLOntology)ontology.getValue()).getOWLOntologyManager().getOWLDataFactory();
        OWLReasoner reasoner = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getDomainOntologyManager().getReasoner(ontology);
        smPkg.setModified(smPkg.getDatasetClassificationPkgs().stream().map(dsPkg -> this.classify((SmartsModuleClassificationPkg.DatasetClassificationPkg)dsPkg, reasoner, factory)).reduce(Boolean::logicalOr).orElse(false));
        this.clearMDC();
    }

    private boolean classify(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg, OWLReasoner reasoner, OWLDataFactory factory) {
        this.mdcDSInfo(dsPkg);
        boolean bModified = false;
        List<SmartsModuleClassificationPkg.ColumnClassificationPkg> inScopeColPkgs = dsPkg.getInScopeColumnClassificationPkgs();
        if (inScopeColPkgs.isEmpty()) {
            return bModified;
        }
        for (int i = 0; i < inScopeColPkgs.size(); ++i) {
            if (!this.classify(i, inScopeColPkgs.get(i), dsPkg.getDelatAnalysisScope(), reasoner, factory)) continue;
            bModified = true;
        }
        return bModified;
    }

    private boolean classify(int index, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, DeltaAnalysisScope deltaAnalysisScope, OWLReasoner reasoner, OWLDataFactory factory) {
        this.mdcColInfo(index, columnPkg);
        try {
            if (columnPkg.getColumnInfo().getSemanticInfo() != null) {
                OverwriteMap overwrites;
                List remainingConcepts = columnPkg.getColumnInfo().getSemanticInfo().getConcepts();
                boolean addRemainingConcepts = false;
                if (this.shouldExecute(columnPkg, deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty.CONCEPTS, DeltaAnalysisScope.ModifiableProperty.ALL)) {
                    List<ConceptInfo> conceptOverwrites = Collections.emptyList();
                    String conceptOverwritesString = "";
                    overwrites = columnPkg.getColumnInfo().getSemanticInfo().getOverwrites();
                    if (overwrites != null) {
                        conceptOverwritesString = (String)overwrites.getOrDefault((Object)DeltaAnalysisScope.ModifiableProperty.CONCEPTS.name(), (Object)"");
                        List<ConceptInfo> list = conceptOverwrites = conceptOverwritesString.isEmpty() ? Collections.emptyList() : JAXBHelper.unmarshalListFromJSON(ConceptInfo.class, (String)conceptOverwritesString);
                    }
                    if (!conceptOverwritesString.isEmpty()) {
                        LOGGER.info("Apply concetp overwrites {} for Column {}.", (Object)conceptOverwritesString, (Object)columnPkg.getColumnInfo().getId());
                        remainingConcepts.removeIf(c -> this.isMoserTaxonomyConcept((ConceptInfo)c, reasoner, factory));
                        if (!conceptOverwrites.isEmpty()) {
                            conceptOverwrites.forEach(c -> columnPkg.getConcepts().add((ConceptInfo)c));
                        } else {
                            this.addConcept(columnPkg, ENTITY_ROOT_IRI, this.objFactory, 1.0f);
                        }
                        addRemainingConcepts = true;
                    }
                }
                if (this.shouldExecute(columnPkg, deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty.USAGE, DeltaAnalysisScope.ModifiableProperty.ALL)) {
                    UsageType usage = null;
                    OverwriteMap overwrites2 = columnPkg.getColumnInfo().getSemanticInfo().getOverwrites();
                    if (overwrites2 != null) {
                        String usageOverwritesString = (String)overwrites2.getOrDefault((Object)DeltaAnalysisScope.ModifiableProperty.USAGE.name(), (Object)"");
                        UsageType usageType = usage = usageOverwritesString.isEmpty() ? null : (UsageType)JAXBHelper.unmarshalFromJSON(UsageType.class, (String)usageOverwritesString);
                    }
                    if (usage != null) {
                        columnPkg.getColumnInfo().getSemanticInfo().setUsage(usage);
                        switch (usage) {
                            case IDENTIFIER: {
                                LOGGER.info("Add concept {} due to usage overwrites {} for Column {}.", new Object[]{"http://www.ibm.com/ontologies/waca/domain/common#Identifier", usage.name(), columnPkg.getColumnInfo().getId()});
                                columnPkg.removeCandidate(IDENTIFIER_IRI);
                                this.addConcept(columnPkg, IDENTIFIER_IRI, this.objFactory, 1.0f);
                                addRemainingConcepts = true;
                                break;
                            }
                            case FACT: {
                                LOGGER.info("Add concept {} due to usage overwrites {} for Column {}.", new Object[]{"http://www.ibm.com/ontologies/waca/domain/common#Measure", usage.name(), columnPkg.getColumnInfo().getId()});
                                this.addConcept(columnPkg, IRI.create((String)"http://www.ibm.com/ontologies/waca/application#MeasureType"), this.objFactory, 1.0f);
                                this.addConcept(columnPkg, IRI.create((String)"http://www.ibm.com/ontologies/waca/domain/common#Measure"), this.objFactory, 1.0f);
                                columnPkg.getConcepts().removeIf(c -> IRI.create((String)c.getConceptID()).equals((Object)ENTITY_ROOT_IRI));
                                addRemainingConcepts = true;
                                break;
                            }
                        }
                    }
                }
                if (this.shouldExecute(columnPkg, deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty.AGGREGATION, DeltaAnalysisScope.ModifiableProperty.ALL)) {
                    AggregationType aggregate = null;
                    String aggregateOverwritesString = "";
                    overwrites = columnPkg.getColumnInfo().getSemanticInfo().getOverwrites();
                    if (overwrites != null) {
                        aggregateOverwritesString = (String)overwrites.getOrDefault((Object)DeltaAnalysisScope.ModifiableProperty.AGGREGATION.name(), (Object)"");
                        AggregationType aggregationType = aggregate = aggregateOverwritesString.isEmpty() ? null : (AggregationType)JAXBHelper.unmarshalFromJSON(AggregationType.class, (String)aggregateOverwritesString);
                    }
                    if (aggregate != null) {
                        columnPkg.getColumnInfo().getSemanticInfo().setDefaultAggregation(aggregate);
                    }
                }
                if (addRemainingConcepts) {
                    remainingConcepts.forEach(c -> {
                        IRI iri;
                        if (this.isApplicatoinConcept((ConceptInfo)c)) {
                            columnPkg.getConcepts().add((ConceptInfo)c);
                        } else if (!this.shouldExecute(columnPkg, deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty.ALL, DeltaAnalysisScope.ModifiableProperty.NAME) && !columnPkg.getCandidate(iri = IRI.create((String)c.getConceptID())).isPresent()) {
                            SmartsModuleClassificationPkg.Candidate candidate = new SmartsModuleClassificationPkg.Candidate(iri);
                            candidate.setConfidence(c.getConfidence());
                            candidate.setRelevance(c.getConfidence());
                            columnPkg.getCandidates().add(candidate);
                        }
                    });
                }
                columnPkg.setDefaultAggregation(columnPkg.getColumnInfo().getSemanticInfo().getDefaultAggregation());
                columnPkg.setUsage(columnPkg.getColumnInfo().getSemanticInfo().getUsage());
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            LOGGER.error("Caught exception while processing concept overwrites for [{}]", (Object)columnPkg, (Object)ex);
            return true;
        }
    }
}

