/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.common.util.SampleDataHelper;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.schema.ColumnInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class LogicalGrouping
extends AbstractSmartsModuleClassificationStep {
    private List<Ontology<OWLOntology>> mOntologies = null;

    LogicalGrouping(List<Ontology<OWLOntology>> ontologies, RequestContext requestContext) {
        super(requestContext);
        this.mOntologies = ontologies;
    }

    @Override
    public void execute(SmartsModuleClassificationPkg smPkg) {
        smPkg.setModified(smPkg.getDatasetClassificationPkgs().parallelStream().map(this::classify).reduce(Boolean::logicalOr).orElse(false));
        this.clearMDC();
    }

    private boolean classify(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        this.mdcDSInfo(dsPkg);
        List<SmartsModuleClassificationPkg.ColumnClassificationPkg> inScopeColPkgs = dsPkg.getInScopeColumnClassificationPkgs();
        if (inScopeColPkgs.isEmpty()) {
            return false;
        }
        IntStream.range(0, inScopeColPkgs.size()).forEach(i -> this.classify(i, (SmartsModuleClassificationPkg.ColumnClassificationPkg)inScopeColPkgs.get(i), dsPkg));
        while (this.adjustAttributeConcept(dsPkg)) {
        }
        return false;
    }

    private boolean classify(int index, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        int groupIndex;
        if (this.onlyPropModified(columnPkg, dsPkg.getDelatAnalysisScope(), DeltaAnalysisScope.ModifiableProperty.AGGREGATION) || columnPkg.getColumnInfo().getSamples().isEmpty()) {
            return false;
        }
        this.mdcColInfo(index, columnPkg);
        Ontology<OWLOntology> ontology = this.mOntologies.get(0);
        OWLDataFactory factory = ((OWLOntology)ontology.getValue()).getOWLOntologyManager().getOWLDataFactory();
        OWLReasoner reasoner = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getDomainOntologyManager().getReasoner(ontology);
        Optional<Object> bestMatchingGroup = Optional.empty();
        for (groupIndex = dsPkg.getGroups().size() - 1; groupIndex >= 0; --groupIndex) {
            SmartsModuleClassificationPkg.LogicalGroup aGroup = dsPkg.getGroups().get(groupIndex);
            if (!aGroup.getGroupKey().isPresent()) continue;
            if (this.getCompatibilityScore(aGroup, columnPkg, ontology, reasoner, factory) <= 0) break;
            bestMatchingGroup = Optional.of(dsPkg.getGroups().get(groupIndex));
            break;
        }
        if (!bestMatchingGroup.isPresent()) {
            int maxScore = 0;
            --groupIndex;
            while (groupIndex >= 0) {
                SmartsModuleClassificationPkg.LogicalGroup g = dsPkg.getGroups().get(groupIndex);
                int score = this.getCompatibilityScore(g, columnPkg, ontology, reasoner, factory);
                if (score > maxScore) {
                    maxScore = score;
                    bestMatchingGroup = Optional.of(g);
                }
                --groupIndex;
            }
        }
        Optional<SmartsModuleClassificationPkg.Candidate> groupKey = this.getEntity(columnPkg, reasoner, factory);
        columnPkg.getCandidates().sort(Comparator.comparing(SmartsModuleClassificationPkg.Candidate::getRelevance).reversed());
        if (!bestMatchingGroup.isPresent()) {
            SmartsModuleClassificationPkg.LogicalGroup newGroup = new SmartsModuleClassificationPkg.LogicalGroup(groupKey, dsPkg.getGroups().size());
            dsPkg.getGroups().add(newGroup);
            bestMatchingGroup = Optional.of(newGroup);
        }
        Optional<Object> attribute = Optional.empty();
        if (groupKey.isPresent()) {
            attribute = this.getAttributeOfEntity(columnPkg, groupKey);
        } else if (!columnPkg.getCandidates().isEmpty()) {
            attribute = this.getAttribute(columnPkg);
        }
        if (attribute.isPresent() && bestMatchingGroup.isPresent()) {
            ((SmartsModuleClassificationPkg.LogicalGroup)bestMatchingGroup.get()).getGroupMembers().add(new Pair<Optional<Object>, SmartsModuleClassificationPkg.ColumnClassificationPkg>(attribute, columnPkg));
        }
        return false;
    }

    private boolean hasOneWayIsRelationship(Optional<SmartsModuleClassificationPkg.Candidate> c1, Optional<SmartsModuleClassificationPkg.Candidate> c2, OWLReasoner reasoner, OWLDataFactory factory) {
        if (c1.isPresent() && c2.isPresent()) {
            if (c1.equals(c2)) {
                return true;
            }
            if (reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(c1.get().getConceptID()), false).containsEntity((OWLObject)factory.getOWLClass(c2.get().getConceptID()))) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getCompatibilityScore(SmartsModuleClassificationPkg.LogicalGroup group, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology, OWLReasoner reasoner, OWLDataFactory factory) {
        Optional<SmartsModuleClassificationPkg.Candidate> columnAttribute;
        Optional<SmartsModuleClassificationPkg.Candidate> columnEntity = this.getEntity(columnPkg, reasoner, factory);
        if (!this.hasBasicCompatbilityRequirement(group, columnEntity, columnAttribute = this.getAttributeOfEntity(columnPkg, columnEntity), reasoner, factory)) {
            return 0;
        }
        int result = 1;
        int nameSimilarityScore = this.getNameMatchingScore(group, columnPkg);
        if (this.isIdentifierOrCaption(columnAttribute) && nameSimilarityScore == 0) {
            return 0;
        }
        result += nameSimilarityScore;
        boolean hasHierarchicalConceptRelationship = false;
        if (group.getGroupKey().isPresent() && columnEntity.isPresent()) {
            HashSet<OWLClass> descendants = new HashSet<OWLClass>();
            this.getDescendantLevelsConcepts(descendants, factory.getOWLClass(group.getGroupKey().get().getConceptID()), (OWLOntology)ontology.getValue());
            hasHierarchicalConceptRelationship = descendants.contains(factory.getOWLClass(columnEntity.get().getConceptID()));
        }
        boolean bSpecificIdentifier = this.isSpecificIdentifier(columnAttribute, reasoner, factory);
        Optional<Pair<Optional<SmartsModuleClassificationPkg.Candidate>, SmartsModuleClassificationPkg.ColumnClassificationPkg>> groupIdColumn = this.getGroupIDOrDetailMember(group, false);
        if (groupIdColumn.isPresent() && this.isSpecificIdentifier(groupIdColumn.get().getFirst(), reasoner, factory)) {
            bSpecificIdentifier = true;
        }
        boolean biDirectional = bSpecificIdentifier;
        if (this.isExplicitAttribute(columnAttribute)) {
            if (!this.isCommonAttribute(columnAttribute)) {
                Optional<Object> groupIDMember = Optional.empty();
                if (bSpecificIdentifier) {
                    Optional<SmartsModuleClassificationPkg.ColumnClassificationPkg> detailColumn = this.getGroupIDOrDetailMemberColumn(group, false);
                    if (detailColumn.isPresent()) {
                        groupIDMember = Optional.of(detailColumn.get().getColumnInfo());
                    }
                } else {
                    groupIDMember = this.getExplicitGroupIDMember(group);
                }
                if (!groupIDMember.isPresent()) return result;
                if (!this.isOneToOne(groupIDMember, columnPkg, columnAttribute, biDirectional, hasHierarchicalConceptRelationship)) return 0;
                ++result;
                return result;
            } else {
                if (!this.isOneToOne(group, columnPkg, columnAttribute, biDirectional, true)) return 0;
                ++result;
            }
            return result;
        } else {
            if (!this.isOneToOne(group, columnPkg, columnAttribute, biDirectional, true)) return 0;
            ++result;
        }
        return result;
    }

    private boolean hasBasicCompatbilityRequirement(SmartsModuleClassificationPkg.LogicalGroup group, Optional<SmartsModuleClassificationPkg.Candidate> entity, Optional<SmartsModuleClassificationPkg.Candidate> attribute, OWLReasoner reasoner, OWLDataFactory factory) {
        if (!group.getGroupKey().isPresent()) {
            return false;
        }
        if (this.isTemporal(group.getGroupKey(), reasoner, factory)) {
            return false;
        }
        if (!this.hasOneWayIsRelationship(group.getGroupKey(), entity, reasoner, factory)) {
            return false;
        }
        List conflictAttributes = group.getGroupMembers().stream().map(Pair::getFirst).filter(c -> this.hasIsRelationship((Optional<SmartsModuleClassificationPkg.Candidate>)c, attribute, reasoner, factory)).collect(Collectors.toList());
        long count = Stream.concat(conflictAttributes.stream(), Stream.of(attribute)).filter(c -> !this.isDefaultCommonAttribute((Optional<SmartsModuleClassificationPkg.Candidate>)c)).collect(Collectors.counting());
        return conflictAttributes.isEmpty() || count == 1L;
    }

    private boolean isExplicitAttribute(Optional<SmartsModuleClassificationPkg.Candidate> attribute) {
        if (attribute.isPresent()) {
            return Float.compare(attribute.get().getRelevance(), 0.01f) > 0;
        }
        return false;
    }

    private boolean isHasPartRelationship(Optional<SmartsModuleClassificationPkg.Candidate> groupKey, Optional<SmartsModuleClassificationPkg.Candidate> columnEntity, Ontology<OWLOntology> ontology, OWLDataFactory factory) {
        if (groupKey.isPresent() && columnEntity.isPresent()) {
            OWLClass gClass = factory.getOWLClass(groupKey.get().getConceptID());
            OWLClass cClass = factory.getOWLClass(columnEntity.get().getConceptID());
            if (this.collectHasPartRestriction(gClass, (OWLOntology)ontology.getValue()).contains(cClass) || this.collectHasPartRestriction(cClass, (OWLOntology)ontology.getValue()).contains(gClass)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasIsRelationship(Optional<SmartsModuleClassificationPkg.Candidate> candidateOne, Optional<SmartsModuleClassificationPkg.Candidate> candidateTwo, OWLReasoner reasoner, OWLDataFactory factory) {
        if (candidateOne.isPresent() && candidateTwo.isPresent()) {
            if (candidateOne.equals(candidateTwo)) {
                return true;
            }
            if (reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(candidateOne.get().getConceptID()), true).containsEntity((OWLObject)factory.getOWLClass(candidateTwo.get().getConceptID()))) {
                return true;
            }
            if (reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(candidateTwo.get().getConceptID()), true).containsEntity((OWLObject)factory.getOWLClass(candidateOne.get().getConceptID()))) {
                return true;
            }
        }
        return false;
    }

    private boolean isCommonAttribute(Optional<SmartsModuleClassificationPkg.Candidate> attribute) {
        if (attribute.isPresent()) {
            SmartsModuleClassificationPkg.Candidate c = attribute.get();
            return c.getConceptID().equals((Object)IDENTIFIER_IRI) || c.getConceptID().equals((Object)CAPTION_IRI) || c.getConceptID().equals((Object)DESCRIPTION_IRI);
        }
        return false;
    }

    private boolean isIdentifierOrCaption(Optional<SmartsModuleClassificationPkg.Candidate> attribute) {
        if (attribute.isPresent()) {
            SmartsModuleClassificationPkg.Candidate c = attribute.get();
            return c.getConceptID().equals((Object)IDENTIFIER_IRI) || c.getConceptID().equals((Object)CAPTION_IRI);
        }
        return false;
    }

    private boolean isSpecificIdentifier(Optional<SmartsModuleClassificationPkg.Candidate> attribute, OWLReasoner reasoner, OWLDataFactory factory) {
        if (attribute.isPresent()) {
            SmartsModuleClassificationPkg.Candidate c = attribute.get();
            if (c.getConceptID().equals((Object)IDENTIFIER_IRI)) {
                return false;
            }
            OWLClass cClass = factory.getOWLClass(c.getConceptID());
            return reasoner.getSuperClasses((OWLClassExpression)cClass, false).containsEntity((OWLObject)factory.getOWLClass(IDENTIFIER_IRI));
        }
        return false;
    }

    private boolean isOneToOne(Optional<ColumnInfo> left, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Optional<SmartsModuleClassificationPkg.Candidate> columnAttribute, boolean biDirectional, boolean checkRatio) {
        ColumnInfo right = null;
        if (!left.isPresent()) {
            return false;
        }
        right = columnPkg.getColumnInfo();
        if (checkRatio && this.meetOneManyRatioRequirement(columnPkg.getColumnInfo(), left.get())) {
            return SampleDataHelper.haveOneOneAssociation((ColumnInfo)right, (ColumnInfo)left.get(), (boolean)biDirectional);
        }
        return SampleDataHelper.haveOneOneAssociation((ColumnInfo)left.get(), (ColumnInfo)right, (boolean)biDirectional);
    }

    private boolean isOneToOne(SmartsModuleClassificationPkg.LogicalGroup group, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Optional<SmartsModuleClassificationPkg.Candidate> columnAttribute, boolean biDirectional, boolean checkRatio) {
        ColumnInfo right;
        ColumnInfo left;
        Optional<SmartsModuleClassificationPkg.ColumnClassificationPkg> groupIDMember = this.getGroupIDOrDetailMemberColumn(group, false);
        if (!groupIDMember.isPresent()) {
            return false;
        }
        if (checkRatio && this.meetOneManyRatioRequirement(columnPkg.getColumnInfo(), groupIDMember.get().getColumnInfo())) {
            left = columnPkg.getColumnInfo();
            right = groupIDMember.get().getColumnInfo();
        } else {
            left = groupIDMember.get().getColumnInfo();
            right = columnPkg.getColumnInfo();
        }
        return SampleDataHelper.haveOneOneAssociation((ColumnInfo)left, (ColumnInfo)right, (boolean)biDirectional);
    }

    private Optional<ColumnInfo> getExplicitGroupIDMember(SmartsModuleClassificationPkg.LogicalGroup group) {
        Optional<ColumnInfo> idGroupMember = group.getGroupMembers().stream().filter(m -> ((SmartsModuleClassificationPkg.Candidate)((Optional)m.getFirst()).get()).getConceptID().equals((Object)IDENTIFIER_IRI)).filter(m -> Float.compare(((SmartsModuleClassificationPkg.Candidate)((Optional)m.getFirst()).get()).getRelevance(), 0.01f) > 0).map(m -> ((SmartsModuleClassificationPkg.ColumnClassificationPkg)m.getSecond()).getColumnInfo()).findFirst();
        if (idGroupMember.isPresent()) {
            return idGroupMember;
        }
        return Optional.empty();
    }

    private boolean isDefaultCommonAttribute(Optional<SmartsModuleClassificationPkg.Candidate> attribute) {
        if (attribute.isPresent()) {
            return this.isCommonAttribute(attribute) && Float.compare(attribute.get().getRelevance(), 0.01f) == 0;
        }
        return false;
    }

    private Optional<SmartsModuleClassificationPkg.Candidate> getAttribute(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg) {
        if (columnPkg.getCandidates().isEmpty()) {
            return Optional.empty();
        }
        Optional<SmartsModuleClassificationPkg.Candidate> attr = columnPkg.getCandidates().stream().filter(c -> c.getConceptID().equals((Object)IDENTIFIER_IRI) || c.getConceptID().equals((Object)CAPTION_IRI) || c.getConceptID().equals((Object)DESCRIPTION_IRI)).sorted(Comparator.comparing(SmartsModuleClassificationPkg.Candidate::getRelevance).reversed()).findFirst();
        if (attr.isPresent()) {
            return attr;
        }
        return Optional.of(columnPkg.getCandidates().get(0));
    }

    private Optional<SmartsModuleClassificationPkg.Candidate> getEntity(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, OWLReasoner reasoner, OWLDataFactory factory) {
        Optional<SmartsModuleClassificationPkg.Candidate> attr = this.getAttribute(columnPkg);
        if (attr.isPresent()) {
            return columnPkg.getEntityCandidates(attr.get()).stream().sorted(Comparator.comparing(SmartsModuleClassificationPkg.Candidate::getRelevance).reversed()).findFirst();
        }
        return Optional.empty();
    }

    private Optional<SmartsModuleClassificationPkg.Candidate> getAttributeOfEntity(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Optional<SmartsModuleClassificationPkg.Candidate> entity) {
        if (entity.isPresent()) {
            return columnPkg.getCandidates().stream().filter(c -> columnPkg.getEntityCandidates((SmartsModuleClassificationPkg.Candidate)c).contains(entity.get())).findFirst();
        }
        return Optional.empty();
    }

    private boolean adjustAttributeConcept(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        ArrayList result = new ArrayList();
        dsPkg.getGroups().forEach(g -> {
            if (g.getGroupKey().isPresent()) {
                Map columnsByAttribute = g.getGroupMembers().stream().collect(Collectors.groupingBy(Pair::getFirst, Collectors.toList()));
                columnsByAttribute.entrySet().forEach(e -> {
                    Optional attr = (Optional)e.getKey();
                    List members = (List)e.getValue();
                    members.sort((c1, c2) -> Float.compare(((SmartsModuleClassificationPkg.ColumnClassificationPkg)c2.getSecond()).getCandidate(((SmartsModuleClassificationPkg.Candidate)attr.get()).getConceptID()).get().getRelevance(), ((SmartsModuleClassificationPkg.ColumnClassificationPkg)c1.getSecond()).getCandidate(((SmartsModuleClassificationPkg.Candidate)attr.get()).getConceptID()).get().getRelevance()));
                    for (int i = 1; i < members.size(); ++i) {
                        Pair member = (Pair)members.get(i);
                        Optional<SmartsModuleClassificationPkg.Candidate> toBeReplaced = ((SmartsModuleClassificationPkg.ColumnClassificationPkg)member.getSecond()).getCandidate(((SmartsModuleClassificationPkg.Candidate)attr.get()).getConceptID());
                        Optional<SmartsModuleClassificationPkg.Candidate> replacement = this.getReplacement(toBeReplaced.get());
                        if (!replacement.isPresent()) continue;
                        Set<SmartsModuleClassificationPkg.Candidate> entity = ((SmartsModuleClassificationPkg.ColumnClassificationPkg)member.getSecond()).getAllEntityCandidates().remove(attr.get());
                        ((SmartsModuleClassificationPkg.ColumnClassificationPkg)member.getSecond()).removeCandidate(((SmartsModuleClassificationPkg.Candidate)attr.get()).getConceptID());
                        ((SmartsModuleClassificationPkg.ColumnClassificationPkg)member.getSecond()).addCandidate(replacement);
                        ((SmartsModuleClassificationPkg.ColumnClassificationPkg)member.getSecond()).addEntityCandidates(replacement.get(), entity);
                        member.setFirst(replacement);
                        result.add(Boolean.TRUE);
                    }
                });
                g.getGroupMembers().stream().forEach(m -> {
                    SmartsModuleClassificationPkg.Candidate groupKey;
                    Set<SmartsModuleClassificationPkg.Candidate> entity = ((SmartsModuleClassificationPkg.ColumnClassificationPkg)m.getSecond()).getEntityCandidates((SmartsModuleClassificationPkg.Candidate)((Optional)m.getFirst()).get());
                    if (!entity.contains(groupKey = g.getGroupKey().get())) {
                        SmartsModuleClassificationPkg.Candidate newEntity = new SmartsModuleClassificationPkg.Candidate(groupKey.getConceptID());
                        newEntity.setDataHintRelevance(groupKey.getDataHintRelevance());
                        newEntity.setDataValueRelevance(groupKey.getDataValueRelevance());
                        newEntity.setLexicalRelevance(groupKey.getLexicalRelevance());
                        newEntity.setRelevance(groupKey.getRelevance());
                        newEntity.setConfidence(groupKey.getConfidence());
                        ((SmartsModuleClassificationPkg.ColumnClassificationPkg)m.getSecond()).addEntityCandidates((SmartsModuleClassificationPkg.Candidate)((Optional)m.getFirst()).get(), Collections.singleton(newEntity));
                        result.add(Boolean.TRUE);
                    }
                });
            }
        });
        return !result.isEmpty();
    }

    public static Collector<SmartsModuleClassificationPkg.ColumnClassificationPkg, ?, List<SmartsModuleClassificationPkg.ColumnClassificationPkg>> toSortedList() {
        return Collectors.collectingAndThen(Collectors.toList(), l -> l.stream().sorted((c1, c2) -> Float.compare(c2.getCandidates().get(0).getRelevance(), c1.getCandidates().get(0).getRelevance())).collect(Collectors.toList()));
    }

    private Optional<SmartsModuleClassificationPkg.Candidate> getReplacement(SmartsModuleClassificationPkg.Candidate current) {
        IRI replacementIRI;
        if (current.getConceptID().equals((Object)IDENTIFIER_IRI)) {
            replacementIRI = CAPTION_IRI;
        } else if (current.getConceptID().equals((Object)CAPTION_IRI)) {
            replacementIRI = DESCRIPTION_IRI;
        } else {
            return Optional.empty();
        }
        SmartsModuleClassificationPkg.Candidate replacement = new SmartsModuleClassificationPkg.Candidate(replacementIRI);
        replacement.setDataHintRelevance(current.getDataHintRelevance());
        replacement.setDataValueRelevance(current.getDataValueRelevance());
        replacement.setLexicalRelevance(current.getLexicalRelevance());
        replacement.setRelevance(current.getRelevance());
        replacement.setConfidence(current.getConfidence());
        return Optional.of(replacement);
    }
}

