/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.util;

import com.ibm.json.java.JSONObject;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.ClueManager;
import com.ibm.smarts.ontology.ontologymanager.OntologyResourceManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;

public class KnowledgeDiscoveryHelper {
    private static final String UTF_8 = "UTF-8";
    public static final String ATTR_CLUEMGR = "clueManager";
    public static final String ATTR_RESOURCEMGR = "resourceManager";
    public static final String ATTR_SERVICEINITOWNER = "serviceInitOwner";

    public static String getOntologyID(OWLOntology ontology) {
        return ((IRI)ontology.getOntologyID().getOntologyIRI().get()).toString();
    }

    public static IRI getIRI(OWLOntology ontology) {
        return (IRI)ontology.getOntologyID().getOntologyIRI().get();
    }

    public static OWLDataFactory getOWLDataFactory(OWLOntology ontology) {
        return ontology.getOWLOntologyManager().getOWLDataFactory();
    }

    public static boolean hasProperty(OWLAnnotation annotation, OWLAnnotationProperty property) {
        return annotation.getProperty().equals(property);
    }

    public static OWLLiteral getOWLLiteral(OWLAnnotation annotation) {
        return (OWLLiteral)annotation.getValue().asLiteral().get();
    }

    public static ClueManager<OWLOntology> getClueManager(RequestContext ctx) {
        Object clueMgr;
        Object object = clueMgr = Optional.ofNullable(ctx).isPresent() ? ctx.getAttribute(ATTR_CLUEMGR) : null;
        if (null == clueMgr) {
            throw new IllegalStateException("RequestContext is missing or ClueManager is missing in the RequestContxt!!!");
        }
        return (ClueManager)clueMgr;
    }

    public static OntologyResourceManager getOntologyResourceManager(RequestContext ctx) {
        Object resourceMgr;
        Object object = resourceMgr = Optional.ofNullable(ctx).isPresent() ? ctx.getAttribute(ATTR_RESOURCEMGR) : null;
        if (null == resourceMgr) {
            throw new IllegalStateException("RequestContext is missing or OntologyResourceManager is missing in the RequestContxt!!!");
        }
        return (OntologyResourceManager)resourceMgr;
    }

    public static boolean isAnyObjectNull(Object ... objects) {
        for (Object o : objects) {
            if (o != null) continue;
            return true;
        }
        return false;
    }

    public static String outputElapsedTimeInMicroSec(long beginNanoTime) {
        return Long.toString(TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - beginNanoTime)) + " \u00b5s";
    }

    public static String outputElapsedTimeInMilliSec(long beginNanoTime) {
        return Long.toString(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beginNanoTime)) + " ms";
    }

    public static Properties loadProperties(String path) throws IOException {
        return KnowledgeDiscoveryHelper.loadContent(path, Properties.class, true);
    }

    public static Properties loadProperties(String path, boolean isClassPath) throws IOException {
        return KnowledgeDiscoveryHelper.loadContent(path, Properties.class, isClassPath);
    }

    public static JSONObject loadJSONContent(String path) throws IOException {
        return KnowledgeDiscoveryHelper.loadContent(path, JSONObject.class, true);
    }

    public static String loadContentAsString(String path) throws IOException {
        return KnowledgeDiscoveryHelper.loadContent(path, String.class, true);
    }

    public static JSONObject loadJSONContent(String path, boolean isClassPath) throws IOException {
        return KnowledgeDiscoveryHelper.loadContent(path, JSONObject.class, isClassPath);
    }

    public static String loadContentAsString(String path, boolean isClassPath) throws IOException {
        return KnowledgeDiscoveryHelper.loadContent(path, String.class, isClassPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> T loadContent(String path, Class<T> clazz, boolean isClassPath) throws IOException {
        block7: {
            InputStream in;
            block6: {
                block5: {
                    T t;
                    in = null;
                    try {
                        in = isClassPath ? KnowledgeDiscoveryHelper.loadFromClasspath(path) : KnowledgeDiscoveryHelper.loadFromFS(path);
                        if (in == null) throw new IOException(String.format("%s is missing.", path));
                        if (!String.class.equals(clazz)) break block5;
                        t = clazz.cast(IOUtils.toString((InputStream)in, (String)UTF_8));
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)in);
                    return t;
                }
                if (!JSONObject.class.equals(clazz)) break block6;
                T t = clazz.cast(JSONObject.parse((InputStream)in));
                IOUtils.closeQuietly((InputStream)in);
                return t;
            }
            if (!Properties.class.equals(clazz)) break block7;
            Properties props = new Properties();
            props.load(in);
            T t = clazz.cast(props);
            IOUtils.closeQuietly((InputStream)in);
            return t;
        }
        throw new IOException("Unknown type to load");
    }

    private static InputStream loadFromFS(String path) throws IOException {
        FileInputStream in = null;
        File file = new File(path);
        if (file.exists()) {
            in = FileUtils.openInputStream((File)new File(path));
        }
        return in;
    }

    public static InputStream loadFromClasspath(String path) {
        InputStream in = KnowledgeDiscoveryHelper.class.getResourceAsStream(path);
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(path);
        }
        return in;
    }
}

