/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.ibm.smarts.core.exceptions.InternalException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ArrayWriter {
    public final String path;

    public ArrayWriter(String path) {
        this.path = path;
    }

    public boolean fileExists() {
        File f = new File(this.path);
        return f.exists();
    }

    private void ensureFolderExists() {
        File f = new File(this.path);
        File d = f.getParentFile();
        if (!d.exists()) {
            d.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDoubleArray(double[][] values) {
        this.ensureFolderExists();
        try (FileOutputStream fos = new FileOutputStream(this.path);){
            int bufferSizeMax = 1000;
            byte[] buffer = new byte[8000];
            int bufferSize = 0;
            ByteBuffer bb = ByteBuffer.wrap(buffer);
            bb.mark();
            int size1 = values.length;
            if (size1 > 0) {
                int size2 = values[0].length;
                for (int i = 0; i < size1; ++i) {
                    for (int j = 0; j < size2; ++j) {
                        double value = values[i][j];
                        bb.putDouble(value);
                        if (++bufferSize < 1000) continue;
                        fos.write(buffer);
                        bb.reset();
                        bufferSize = 0;
                    }
                }
                if (bufferSize > 0) {
                    fos.write(buffer, 0, bufferSize * 8);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InternalException((Throwable)e, "Writing double array to " + this.path, new Object[0]);
        }
    }

    public void readDoubleArray(double[][] values) {
        this.ensureFolderExists();
        File f = new File(this.path);
        try {
            FileInputStream fis = new FileInputStream(f);
            try {
                int bufferSizeMax = 1000;
                byte[] buffer = new byte[8000];
                int bufferIdx = 0;
                int bufferIdxMax = 0;
                ByteBuffer bb = ByteBuffer.wrap(buffer);
                int size1 = values.length;
                if (size1 > 0) {
                    int size2 = values[0].length;
                    for (int i = 0; i < size1; ++i) {
                        for (int j = 0; j < size2; ++j) {
                            double d;
                            if (bufferIdx >= bufferIdxMax) {
                                bufferIdx = 0;
                                int count = fis.read(buffer);
                                bufferIdxMax = count / 8;
                                bb = ByteBuffer.wrap(buffer, 0, count);
                            }
                            values[i][j] = d = bb.getDouble();
                            ++bufferIdx;
                        }
                    }
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
                throw new InternalException(th, "Reading double array at " + this.path, new Object[0]);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new InternalException((Throwable)e, "Reading double array at " + this.path + " (use fileExists() first)", new Object[0]);
        }
    }

    public static void verifyEqual(double[][] left, double[][] right) {
        int rightWidth;
        if (left == null || right == null) {
            throw new IllegalArgumentException("Missing left or right array");
        }
        if (left.length != right.length) {
            throw new IllegalArgumentException("Arrays not same size: left=" + left.length + " right=" + right.length);
        }
        int leftWidth = left.length == 0 ? 0 : left[0].length;
        int n = rightWidth = right.length == 0 ? 0 : right[0].length;
        if (leftWidth != rightWidth) {
            throw new IllegalArgumentException("Arrays not same width: left=" + leftWidth + " right=" + rightWidth);
        }
        int size1 = left.length;
        if (size1 > 0) {
            int size2 = left[0].length;
            for (int i = 0; i < size1; ++i) {
                for (int j = 0; j < size2; ++j) {
                    double leftValue = left[i][j];
                    double rightValue = right[i][j];
                    if (leftValue == rightValue) continue;
                    throw new RuntimeException("Unequals values at i=" + i + " j=" + j + ": " + leftValue + " vs " + rightValue);
                }
            }
        }
    }
}

