/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.datatype;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.smarts.model.datatype.BaseDataType;
import com.ibm.smarts.model.datatype.DataTypeDeserializer;
import com.ibm.smarts.model.datatype.DataTypeSerializer;
import com.ibm.smarts.model.datatype.NumericType;
import com.ibm.smarts.model.value.DecimalValue;
import com.ibm.smarts.model.value.Value;

@JsonTypeName(value="decimal")
@JsonDeserialize(using=DataTypeDeserializer.class)
@JsonSerialize(using=DataTypeSerializer.class)
public class DecimalType
extends NumericType {
    public static final int MIN_PRECISION = 1;
    public static final int MAX_PRECISION = 256;
    public static final int MAX_CACHED_PRECISION = 256;
    public static final int MAX_SPECIALIZED_PRECISION = 18;
    public static final int MIN_SCALE = -256;
    public static final int DEFAULT_PRECISION = 256;
    public static final int DEFAULT_SCALE = 2;
    private int precision;
    private int scale;

    public DecimalType() {
        this(256, 2);
    }

    public DecimalType(int precision) {
        this(precision, 2);
    }

    public DecimalType(int precision, int scale) {
        DecimalType.validatePrecisionAndScale(precision, scale);
        this.precision = precision;
        this.scale = scale;
    }

    private static void validatePrecisionAndScale(int precision, int scale) {
        boolean isUnlimitedUpperBoundry;
        boolean bl = isUnlimitedUpperBoundry = precision == Integer.MAX_VALUE;
        if (precision < 1 || precision > 256 && !isUnlimitedUpperBoundry || scale < -256 || scale > precision) {
            String msg = String.format("Invalid decimal type with precision (%d) and scale (%d).", precision, scale);
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public BaseDataType getBaseType() {
        return BaseDataType.DECIMAL;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public DecimalType withPrecisionAndScale(int precision, int scale) {
        if (this.precision == precision && this.scale == scale) {
            return this;
        }
        return new DecimalType(precision, scale);
    }

    @Override
    public boolean isExactNumeric() {
        return true;
    }

    @Override
    public Value newValue() {
        return new DecimalValue(this);
    }

    @Override
    public String toString() {
        return String.format("decimal(%d, %d)", this.precision, this.scale);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DecimalType)) {
            return false;
        }
        DecimalType other = (DecimalType)o;
        return this.precision == other.precision && this.scale == other.scale;
    }

    public int hashCode() {
        return this.getBaseType().hashCode() + this.precision + this.scale;
    }
}

