/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.schema.util;

import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.InScopeTable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class AnalysisScopes {
    public static final AnalysisScope EMPTY_SCOPE = new AnalysisScope();
    public static final AnalysisScope GLOBAL_SMARTS_MODULE_SCOPE = AnalysisScopes.createGlobalSmartsModuleScope();
    public static final int MAX_ALLOWABLE_TABLES_SIZE = 50;

    private AnalysisScopes() {
    }

    public static boolean hasOutScopeTable(AnalysisScope analysisScope) {
        return analysisScope != null && !analysisScope.getOutScopeTables().isEmpty();
    }

    public static boolean hasInScopeTable(AnalysisScope analysisScope) {
        return analysisScope != null && !analysisScope.getInScopeTables().isEmpty();
    }

    public static boolean isScopeExceededMaxSupportTables(AnalysisScope analysisScope) {
        return analysisScope != null && analysisScope.getInScopeTables().size() > 50;
    }

    public static List<String> getInScopeTableNames(AnalysisScope analysisScope) {
        if (analysisScope != null) {
            return analysisScope.getInScopeTables().stream().map(InScopeTable::getTableID).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static AnalysisScope emptyAnalysisScope() {
        return EMPTY_SCOPE;
    }

    public static AnalysisScope globalSmartsModuleAnalysisScope() {
        return GLOBAL_SMARTS_MODULE_SCOPE;
    }

    private static AnalysisScope createGlobalSmartsModuleScope() {
        AnalysisScope scope = new AnalysisScope();
        InScopeTable inScopeTable = new InScopeTable();
        inScopeTable.setTableID("SmartsModule");
        scope.getInScopeTables().add(inScopeTable);
        return scope;
    }
}

