/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.corenlp.analyzer;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.smarts.nlp.core.analyzer.NLPAnalyzer;
import com.ibm.smarts.nlp.core.corenlp.analyzer.CoreNLPResourceManager;
import com.ibm.smarts.nlp.core.corenlp.analyzer.PostProcessor;
import com.ibm.smarts.nlp.core.corenlp.analyzer.PreProcessor;
import com.ibm.smarts.nlp.core.corenlp.domain.CoreNLPResults;
import com.ibm.smarts.nlp.core.corenlp.domain.CoreNLPToken;
import com.ibm.smarts.nlp.core.corenlp.posmapping.POSMapper;
import com.ibm.smarts.schema.NLPDependency;
import com.ibm.smarts.schema.NLPDependencyNode;
import com.ibm.smarts.schema.NLPMentionsEntity;
import com.ibm.smarts.schema.TimeEntity;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreNLPAnalyzer
implements NLPAnalyzer<CoreNLPResults> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreNLPAnalyzer.class);
    static final String DATE_TYPE = "DATE";
    private StanfordCoreNLP pipeline;
    private HeadFinder headFinder;
    private POSMapper posMapper;
    private PreProcessor preProcessor;
    private PostProcessor postProcessor;

    public CoreNLPAnalyzer(Locale locale) {
        this.pipeline = CoreNLPResourceManager.getPipeline(locale);
        this.headFinder = CoreNLPResourceManager.getHeadFinder(locale);
        this.posMapper = CoreNLPResourceManager.getPOSMapper(locale);
        this.preProcessor = CoreNLPResourceManager.getPreProcessor(locale);
        this.postProcessor = CoreNLPResourceManager.getPostProcessor(locale);
    }

    private Annotation createDocument(String text) throws IllegalStateException {
        Annotation document = new Annotation(text);
        document.set(CoreAnnotations.DocDateAnnotation.class, (Object)new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        this.pipeline.annotate(document);
        return document;
    }

    public CoreMap analyzeToSentence(String text) {
        Annotation document = this.createDocument(text);
        List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
        if (sentences.isEmpty()) {
            return null;
        }
        return (CoreMap)sentences.get(0);
    }

    public List<CoreNLPToken> getTokens(CoreMap sentence) {
        ArrayList<CoreNLPToken> tokens = new ArrayList<CoreNLPToken>();
        for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
            String text = (String)token.get(CoreAnnotations.TextAnnotation.class);
            int index = (Integer)token.get(CoreAnnotations.IndexAnnotation.class);
            int charOffsetBegin = (Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            int charOffsetEnd = (Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            CoreNLPToken coreNLPToken = new CoreNLPToken(text, index, charOffsetBegin, charOffsetEnd);
            coreNLPToken.setLemma((String)token.get(CoreAnnotations.LemmaAnnotation.class));
            coreNLPToken.setNamedEntity((String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class));
            coreNLPToken.setPos((String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class));
            tokens.add(coreNLPToken);
        }
        if (this.posMapper != null) {
            this.posMapper.apply(tokens);
        }
        return tokens;
    }

    public Tree getParseTree(CoreMap sentence) {
        return (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
    }

    public Tree getHead(Tree parseTree) {
        if (this.headFinder != null) {
            return parseTree.headTerminal(this.headFinder);
        }
        return null;
    }

    @Override
    public CoreNLPResults analyzePhrase(String phrase) {
        String[] textStrArray = new String[]{phrase};
        String[] preProcessedPhrase = this.preProcessor.processPhrases(textStrArray);
        return this.process(phrase, preProcessedPhrase, false);
    }

    @Override
    public List<CoreNLPResults> analyze(String[] phrases) {
        return Arrays.asList(phrases).stream().map(phrase -> this.analyzePhrase((String)phrase)).collect(Collectors.toList());
    }

    public List<NLPMentionsEntity> getEntityMentions(String text) {
        Annotation document = this.createDocument(text);
        return this.getEntityMentions(document);
    }

    private List<NLPMentionsEntity> getEntityMentions(Annotation document) {
        ArrayList<NLPMentionsEntity> coreNLPMentionsEntities = new ArrayList<NLPMentionsEntity>();
        List mentions = (List)document.get(CoreAnnotations.MentionsAnnotation.class);
        if (null != mentions) {
            for (CoreMap mention : mentions) {
                String type = (String)mention.get(CoreAnnotations.EntityTypeAnnotation.class);
                Timex timex = (Timex)mention.get(TimeAnnotations.TimexAnnotation.class);
                String entityText = (String)mention.get(CoreAnnotations.TextAnnotation.class);
                String normalizedEntityTag = (String)mention.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
                int tokenBegin = (Integer)mention.get(CoreAnnotations.TokenBeginAnnotation.class);
                int tokenEnd = (Integer)mention.get(CoreAnnotations.TokenEndAnnotation.class);
                TimeEntity timeEntity = this.getTimeEntity(timex);
                NLPMentionsEntity entity = new NLPMentionsEntity();
                entity.setText(entityText);
                entity.setType(type);
                entity.setNormalizedEntityTag(normalizedEntityTag);
                entity.setTokenBegin(tokenBegin);
                entity.setTokenEnd(tokenEnd);
                entity.setTimeEntity(timeEntity);
                coreNLPMentionsEntities.add(entity);
            }
        }
        return coreNLPMentionsEntities;
    }

    private TimeEntity getTimeEntity(Timex timex) {
        if (timex == null) {
            return null;
        }
        Date date = null;
        TimeEntity t = new TimeEntity();
        if (timex.timexType().equals(DATE_TYPE) && timex.value() != null) {
            try {
                Calendar calendar = timex.getDate();
                if (calendar != null) {
                    date = calendar.getTime();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        t.setAltValue(timex.altVal());
        if (date != null) {
            t.setDate(date.getTime());
        }
        t.setType(timex.timexType());
        t.setValue(timex.value());
        return t;
    }

    public CoreNLPResults process(String text, String[] preProcessedText, boolean includeDependencies) {
        CoreNLPResults results = null;
        try {
            Annotation document = this.createDocument(preProcessedText[0]);
            List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
            if (sentences != null && !sentences.isEmpty()) {
                CoreMap sentence = (CoreMap)sentences.get(0);
                List<CoreNLPToken> tokens = this.getTokens(sentence);
                Tree tree = this.getParseTree(sentence);
                Tree head = this.getHead(tree);
                if (preProcessedText[0].length() != text.length()) {
                    this.postProcessor.adjustTokensOffsets(text, tokens);
                }
                results = new CoreNLPResults(text, tokens, tree, head);
                results.setEntities(this.getEntityMentions(document));
            }
        }
        catch (IllegalStateException e) {
            LOGGER.error("There was an error processing: {}", (Object)preProcessedText[0]);
            LOGGER.error(e.getMessage());
        }
        return results;
    }

    private Map<Integer, List<NLPDependency>> getDependecyMap(CoreMap s) {
        HashMap<Integer, List<NLPDependency>> map = new HashMap<Integer, List<NLPDependency>>();
        SemanticGraph semanticGraph = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        for (SemanticGraphEdge edge : semanticGraph.edgeListSorted()) {
            String relationshipType = edge.getRelation().toString();
            IndexedWord source = edge.getSource();
            NLPDependencyNode governor = new NLPDependencyNode();
            governor.setText(source.word());
            governor.setIndex(source.index());
            IndexedWord target = edge.getDependent();
            NLPDependencyNode dependent = new NLPDependencyNode();
            dependent.setText(target.word());
            dependent.setIndex(target.index());
            NLPDependency dependency = new NLPDependency();
            dependency.setDependent(dependent);
            dependency.setGovernor(governor);
            dependency.setType(relationshipType);
            Integer key = new Integer(source.index());
            if (map.containsKey(key)) {
                ((List)map.get(key)).add(dependency);
                continue;
            }
            ArrayList<NLPDependency> dependecies = new ArrayList<NLPDependency>();
            dependecies.add(dependency);
            map.put(key, dependecies);
        }
        return map;
    }

    @Override
    public CoreNLPResults tokenize(String sentence) {
        String[] sentenceStrArray = new String[]{sentence};
        return this.process(sentence, sentenceStrArray, false);
    }

    @Override
    public CoreNLPResults analyzeQuestion(String question) {
        String[] questionStrArray = new String[]{question};
        String[] preProcessedQuestion = this.preProcessor.preProcessPhrases(questionStrArray);
        return this.process(question, preProcessedQuestion, true);
    }
}

