/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.corenlp.annotator;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TokenOverrides
implements Annotator {
    private static final String LSB = "-LSB-";
    private static final String RSB = "-RSB-";
    private static final String LRB = "-LRB-";
    private static final String RRB = "-RRB-";
    private static final String LCB = "-LCB-";
    private static final String RCB = "-RCB-";
    private static final Map<String, String> bracketOverridesMap = new HashMap<String, String>();

    public TokenOverrides(String name, Properties props) {
    }

    public void annotate(Annotation annotation) {
        for (CoreLabel token : (List)annotation.get(CoreAnnotations.TokensAnnotation.class)) {
            String text = (String)token.get(CoreAnnotations.TextAnnotation.class);
            String bracketOverride = bracketOverridesMap.get(text);
            if (!StringUtils.isNotBlank((CharSequence)bracketOverride)) continue;
            token.set(CoreAnnotations.TextAnnotation.class, (Object)bracketOverride);
        }
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class)));
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.emptySet();
    }

    static {
        bracketOverridesMap.put(LSB, "[");
        bracketOverridesMap.put(RSB, "]");
        bracketOverridesMap.put(LRB, "(");
        bracketOverridesMap.put(RRB, ")");
        bracketOverridesMap.put(LCB, "{");
        bracketOverridesMap.put(RCB, "}");
    }
}

