/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.grammar;

import com.ibm.smarts.nlp.api.grammar.PartOfSpeech;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum FRPartOfSpeech {
    A("A", "adjective", PartOfSpeech.JJ),
    Adv("Adv", "adverb", PartOfSpeech.RB),
    CC("CC", "coordinating conjunction", PartOfSpeech.CC),
    CS("CS", "subordinating conjunction", PartOfSpeech.CC),
    D("D", "determiner", PartOfSpeech.DT),
    PONCT("PONCT", "punctuation mark", PartOfSpeech.PUNC),
    I("I", "interjection", PartOfSpeech.INTJ),
    NC("NC", "common noun", PartOfSpeech.NN),
    NP("NP", "proper noun", PartOfSpeech.NNP),
    Cl("Cl", "weak clitic pronoun", PartOfSpeech.PRP),
    PRO("PRO", "strong pronoun", PartOfSpeech.PRP),
    P("P", "preposition", PartOfSpeech.IN),
    V("V", "verb", PartOfSpeech.VB),
    ET("ET", "foreign word", PartOfSpeech.FW),
    PREF("PREF", "prefix", PartOfSpeech.JJ),
    AP("AP", "adjective phrase", PartOfSpeech.ADJP),
    AdP("AdP", "adverbial phrase", PartOfSpeech.ADVP),
    COORD("COORD", "coordinated phrases", PartOfSpeech.CONJP),
    VN("VN", "verbal nucleus", PartOfSpeech.VP),
    VPinf("VPinf", "infinitive clauses", PartOfSpeech.FRAG),
    VPpart("VPpart", "nonfinite clauses", PartOfSpeech.FRAG),
    Sint("Sint", "finite clauses", PartOfSpeech.FRAG),
    Srel("Srel", "finite clauses", PartOfSpeech.FRAG),
    Ssub("Ssub", "finite clauses", PartOfSpeech.FRAG),
    SENT("SENT", "sentences", PartOfSpeech.SINV);

    private final String description;
    private final PartOfSpeech enPos;
    private static final Map<String, FRPartOfSpeech> nameToValueMap;
    private final String value;

    private FRPartOfSpeech(String value, String description, PartOfSpeech enPos) {
        this.value = value;
        this.description = description;
        this.enPos = enPos;
    }

    public String descriptionString() {
        return this.value + "-" + this.description + " - " + this.name();
    }

    public static PartOfSpeech getEnPOS(String value) {
        FRPartOfSpeech pos = nameToValueMap.get(value);
        if (pos == null) {
            return PartOfSpeech.OTHER;
        }
        return pos.enPos;
    }

    static {
        nameToValueMap = new HashMap<String, FRPartOfSpeech>();
        for (FRPartOfSpeech pos : EnumSet.allOf(FRPartOfSpeech.class)) {
            nameToValueMap.put(pos.value, pos);
        }
    }
}

