/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.utils;

import com.ibm.bi.platform.moser.common.utils.V5QueryExpressionParserTokenValidator;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import org.apache.commons.collections.map.CaseInsensitiveMap;

public class IdentifierUtil {
    private static final String[] RESERVED_KEYWORDS = new String[]{"ABSOLUTE", "ACTION", "ADD", "ADMIN", "AFTER", "AGGREGATE", "ALIAS", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "ARRAY", "AS", "ASC", "ASSERTION", "AT", "AUTO", "AUTHORIZATION", "BEFORE", "BEGIN", "BETWEEN", "BINARY", "BIT", "BLOB", "BOOLEAN", "BOTH", "BREADTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHECK", "CLASS", "CLOB", "CLOSE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "COMPLETION", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONSTRUCTOR", "CONTAINS", "CONTINUE", "CORRESPONDING", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURRENTMEASURE", "CURSOR", "CYCLE", "DATA", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DEPTH", "DEREF", "DESC", "DESCRIBE", "DESCRIPTOR", "DESTROY", "DESTRUCTOR", "DETERMINISTIC", "DICTIONARY", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "DYNAMIC", "EACH", "ELSE", "END", "ENDS", "END-EXEC", "EQUALS", "ESCAPE", "EVERY", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXTERNAL", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FREE", "FULL", "FUNCTION", "GENERAL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "GROUPING", "HAVING", "HOST", "HOUR", "IDENTITY", "IF", "IGNORE", "IMMEDIATE", "IN", "IN_RANGE", "INDICATOR", "INITIALIZE", "INITIALLY", "INNER", "INOUT", "INPUT", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "ITERATE", "JOIN", "KEY", "LANGUAGE", "LARGE", "LAST", "LATERAL", "LEADING", "LEFT", "LESS", "LEVEL", "LIKE", "LIMIT", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATOR", "LOOKUP", "MAP", "MATCH", "MINUTE", "MISSING", "MODIFIES", "MODIFY", "MODULE", "MONTH", "MOVING", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NEXT", "NO", "NONE", "NOT", "NULL", "NUMBER", "NUMERIC", "OBJECT", "OF", "OFF", "OLD", "ON", "ONLY", "OPEN", "OPERATION", "OPTION", "OR", "ORDER", "ORDINALITY", "OUT", "OUTER", "OUTPUT", "PAD", "PARAMETER", "PARAMETERS", "PARTIAL", "PATH", "POSTFIX", "PRECISION", "PREFIX", "PREFILTER", "PREORDER", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "READS", "REAL", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "RELATIVE", "REPORT", "RESTRICT", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROLLUP", "ROUTINE", "ROW", "ROWS", "RUNNING", "SAVEPOINT", "SCHEMA", "SCROLL", "SCOPE", "SEARCH", "SECOND", "SECTION", "SELECT", "SEQUENCE", "SESSION", "SESSION_USER", "SET", "SETS", "SIZE", "SMALLINT", "SOME", "SPACE", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "START", "STARTS", "STATE", "STATEMENT", "STATIC", "STRING", "STRUCTURE", "SYSTEM_USER", "TABLE", "TEMPORARY", "TERMINATE", "THAN", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATION", "TREAT", "TRIGGER", "TRUE", "UNDER", "UNION", "UNIQUE", "UNKNOWN", "UNNEST", "UPDATE", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARIABLE", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WITHOUT", "WORK", "WRITE", "YEAR", "ZONE"};
    private static final String[] KEYWORDS = new String[]{"as", "at", "by", "in", "is", "ln", "no", "of", "on", "or", "to", "abs", "all", "and", "any", "asc", "avg", "day", "dec", "end", "exp", "for", "int", "max", "min", "mod", "not", "out", "row", "set", "sum", "top", "both", "call", "case", "cast", "ceil", "char", "cube", "date", "desc", "else", "from", "full", "hour", "into", "join", "last", "left", "like", "null", "over", "perc", "rank", "ravg", "real", "rmax", "rmin", "rsum", "rows", "sets", "some", "sqrt", "then", "time", "trim", "true", "user", "when", "with", "xavg", "xmax", "xmin", "xsum", "year", "zone", "count", "cross", "dbkey", "false", "first", "float", "floor", "group", "inner", "local", "lower", "month", "nchar", "ntile", "nulls", "order", "outer", "power", "range", "rdiff", "right", "table", "union", "upper", "using", "where", "xlast", "xperc", "xrank", "_local", "bigint", "cursor", "create", "delete", "double", "escape", "except", "exists", "filter", "having", "insert", "minute", "nullif", "others", "rcount", "rollup", "scroll", "second", "select", "stddev", "update", "values", "window", "within", "xcount", "xfirst", "xratio", "xntile", "_cursor", "_rowset", "between", "boolean", "ceiling", "current", "decimal", "declare", "extract", "integer", "leading", "natural", "numeric", "qualify", "tertile", "unknown", "varchar", "varying", "var_pop", "without", "xstddev", "coalesce", "distinct", "filename", "grouping", "interval", "national", "nvarchar", "position", "smallint", "snapshot", "trailing", "variance", "var_samp", "xtertile", "character", "cume_dist", "intersect", "following", "localtime", "partition", "precision", "preceding", "prefilter", "recursive", "returning", "substring", "timestamp", "updatable", "unbounded", "xvariance", "bit_length", "dense_rank", "last_value", "percentile", "row_number", "stddev_pop", "xmovingavg", "xmovingsum", "char_length", "first_value", "stddev_samp", "xstddev_pop", "current_date", "current_time", "octet_length", "percent_rank", "timezone_hour", "xvariance_pop", "localtimestamp", "percentile_cont", "percentile_disc", "ratio_to_report", "timezone_minute", "character_length", "current_timestamp"};
    private static final String[] PARSER_KEYWORDS = new String[]{"_ADDMEMBERTOSET", "_FORMAT", "AFTER", "AGGREGATE", "AND", "ALL", "ANY", "AS", "ASC", "AT", "AUTO", "AVERAGE", "BASC", "BDESC", "BEFORE", "BEFOREWITHMEMBER", "BETWEEN", "BOTH", "BY", "CASE", "CAST", "CONTAINS", "CORR", "COUNT", "COVARIANCE-POP", "COVARIANCE-SAMP", "CURRENT_DATE", "CURRENTMEASURE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DEFAULT", "DECOMPOSABLE", "DESC", "DESCENDANTS", "DETAIL", "DISTINCT", "ELSE", "EMPTY", "END", "ENDS", "EQUALS", "ESCAPE", "EXCEPT", "EXTRACT", "FIRST", "FLAG", "FOR", "FROM", "GENERATE", "HIERARCHIZE", "IF", "IMMEDIATELY", "IN", "INTERSECT", "INTERVAL", "IS", "JSON_EXISTS", "JSON_QUERY", "JSON_VALUE", "LAST", "LEADING", "LIKE", "LOCALTIME", "LOCALTIMESTAMP", "LOOKUP", "MAXIMUM", "MEDIAN", "MEMBER", "MINIMUM", "MISSING", "MOVING-AVERAGE", "MOVING-TOTAL", "NOT", "NULL", "NULLS", "OCCURRENCE", "OCCURRENCES_REGEX", "ON", "OR", "ORDER", "OVER", "OVERLAPS", "PARTITION", "PASSING", "PERCENTAGE", "PERCENTAGE_0", "PERCENTAGE_1", "PERCENTAGE_2", "PERCENTILE", "PERIOD", "POSITION", "POSITION_REGEX", "POST", "PRECEDES", "PREFILTER", "QUARTILE", "QUANTILE", "RANK", "REGRESSION-AVERAGE-X", "REGRESSION-AVERAGE-Y", "REGRESSION-COUNT", "REGRESSION-INTERCEPT", "REGRESSION-R2", "REGRESSION-SLOPE", "REGRESSION-SXX", "REGRESSION-SXY", "REGRESSION-SYY", "REPORT", "ROW", "ROWS", "RUNNING-AVERAGE", "RUNNING-COUNT", "RUNNING-DIFFERENCE", "RUNNING-MAXIMUM", "RUNNING-MINIMUM", "RUNNING-TOTAL", "SELF", "SET", "START", "STARTS", "STANDARD-DEVIATION", "STANDARD-DEVIATION-POP", "STANDARD-DEVIATION-SAMP", "SUBSTRING", "SUBSTRINGR", "SUBSTRING_REGEX", "SUCCEEDS", "TERTILE", "THEN", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TOTAL", "TO_JSON", "TRAILING", "TRIM", "TUPLE", "UNION", "VARIANCE", "VARIANCE-POP", "VARIANCE-SAMP", "WHEN", "WIDTH-BUCKET", "WITH", "WITHIN", "XMLQUERY", "XMLEXISTS", "BIT", "BIGINT", "CHAR", "CHARACTER", "DATE", "DAY", "DAYS", "DEC", "DECIMAL", "DOUBLE", "FLOAT", "HOUR", "HOURS", "INT", "INTEGER", "MINUTE", "MINUTES", "MONTH", "MONTHS", "NATIONAL", "NCHAR", "NUMERIC", "NVARCHAR", "PRECISION", "REAL", "SECOND", "SECONDS", "SMALLINT", "TIME", "TIMESTAMP", "VARCHAR", "VARYING", "YEAR", "YEARS", "ZONE"};
    private static final int UNDERSCORE = 95;
    private static final int OPEN_BRACKET = 91;
    private static final int CLOSE_BRACKET = 93;
    private static IdentifierUtil instance = new IdentifierUtil();
    private CaseInsensitiveMap keywordSet = new CaseInsensitiveMap();

    private IdentifierUtil() {
        for (String keyword : KEYWORDS) {
            this.keywordSet.put((Object)keyword, (Object)Boolean.TRUE);
        }
        for (String keyword : RESERVED_KEYWORDS) {
            this.keywordSet.put((Object)keyword, (Object)Boolean.TRUE);
        }
        for (String keyword : PARSER_KEYWORDS) {
            this.keywordSet.put((Object)keyword, (Object)Boolean.TRUE);
        }
    }

    public static String makeUniqueAndValidIdentifier(String name, CaseInsensitiveMap seenMap) {
        String newId = IdentifierUtil.makeValidIdentifier(name);
        newId = IdentifierUtil.removeExcessUnderscoresOneId(newId);
        newId = IdentifierUtil.changeIdentifierMatchingKeywords(newId);
        newId = IdentifierUtil.resolveNameConflictsOneId(newId, seenMap);
        return newId;
    }

    public static boolean isIdValid(String idToCheck) {
        if (idToCheck == null || idToCheck.isEmpty()) {
            return false;
        }
        int firstChar = idToCheck.codePointAt(0);
        if (!IdentifierUtil.isValidFirstCharacterForGeneration(firstChar)) {
            return false;
        }
        IntStream characters = idToCheck.codePoints();
        PrimitiveIterator.OfInt it = characters.iterator();
        while (it.hasNext()) {
            int codePoint = it.nextInt();
            boolean valid = IdentifierUtil.isValidInbetweenCharForGeneration(codePoint);
            if (valid) continue;
            return false;
        }
        return !IdentifierUtil.isKeyword(idToCheck);
    }

    public static boolean isKeyword(String str) {
        return IdentifierUtil.instance.keywordSet.containsKey((Object)str);
    }

    public static String[] convertToValidUniqueIdentifiers(String[] input) {
        String[] validIdentifiers = new String[input.length];
        if (!IdentifierUtil.copyValidIdentifiers(input, validIdentifiers)) {
            IdentifierUtil.makeValidIdentifiers(input, validIdentifiers);
        }
        IdentifierUtil.removeExcessUnderscores(validIdentifiers);
        IdentifierUtil.changeIdentifiersMatchingKeywords(validIdentifiers);
        IdentifierUtil.resolveNameConflicts(validIdentifiers);
        return validIdentifiers;
    }

    private static String changeIdentifierMatchingKeywords(String validId) {
        return IdentifierUtil.isKeyword(validId) ? validId + "_" : validId;
    }

    private static void changeIdentifiersMatchingKeywords(String[] validIdentifiers) {
        for (int i = 0; i < validIdentifiers.length; ++i) {
            validIdentifiers[i] = IdentifierUtil.changeIdentifierMatchingKeywords(validIdentifiers[i]);
        }
    }

    private static String removeExcessUnderscoresOneId(String validId) {
        String result = IdentifierUtil.removeSequencesOfUnderscores(validId);
        return result.length() == 1 ? result : result.replaceAll("_+\\b", "");
    }

    private static void removeExcessUnderscores(String[] validIdentifiers) {
        for (int i = 0; i < validIdentifiers.length; ++i) {
            validIdentifiers[i] = IdentifierUtil.removeExcessUnderscoresOneId(validIdentifiers[i]);
        }
    }

    private static String removeSequencesOfUnderscores(String identifier) {
        return identifier.replaceAll("__+", "_");
    }

    private static String resolveNameConflictsOneId(String validId, CaseInsensitiveMap uniqueIds) {
        int iSuffix = 0;
        String identifier = validId;
        while (uniqueIds.containsKey((Object)identifier)) {
            identifier = validId.charAt(validId.length() - 1) == '_' ? validId + ++iSuffix : validId + '_' + ++iSuffix;
        }
        return identifier;
    }

    private static void resolveNameConflicts(String[] validIdentifiers) {
        CaseInsensitiveMap uniqueIds = new CaseInsensitiveMap();
        for (int i = 0; i < validIdentifiers.length; ++i) {
            validIdentifiers[i] = IdentifierUtil.resolveNameConflictsOneId(validIdentifiers[i], uniqueIds);
            uniqueIds.put((Object)validIdentifiers[i], (Object)Boolean.TRUE);
        }
    }

    private static void makeValidIdentifiers(String[] input, String[] validIdentifiers) {
        for (int i = 0; i < input.length; ++i) {
            if (validIdentifiers[i] != null) continue;
            validIdentifiers[i] = IdentifierUtil.makeValidIdentifier(input[i]);
        }
    }

    private static String makeValidIdentifier(String identifier) {
        IntStream characters = identifier.codePoints();
        PrimitiveIterator.OfInt it = characters.iterator();
        StringBuilder sb = new StringBuilder();
        int firstChar = identifier.codePointAt(0);
        if (!IdentifierUtil.isValidFirstCharacterForGeneration(firstChar)) {
            sb.append("i");
        }
        while (it.hasNext()) {
            int codePoint = it.nextInt();
            boolean valid = IdentifierUtil.isValidInbetweenCharForGeneration(codePoint);
            if (!valid) {
                sb.append("_");
                continue;
            }
            sb.appendCodePoint(codePoint);
        }
        return sb.toString();
    }

    private static boolean copyValidIdentifiers(String[] input, String[] validIdentifiers) {
        boolean allValid = true;
        for (int i = 0; i < input.length; ++i) {
            String identifier = input[i];
            if (!IdentifierUtil.isValidIdentifier(identifier)) {
                allValid = false;
                continue;
            }
            validIdentifiers[i] = identifier;
        }
        return allValid;
    }

    private static boolean isValidFirstLastCharacterForValidation(int firstChar, int lastChar) {
        if (firstChar == 91 && lastChar == 93) {
            return true;
        }
        return IdentifierUtil.isValidFirstCharacterForGeneration(firstChar);
    }

    private static boolean isValidFirstCharacterForGeneration(int firstChar) {
        return V5QueryExpressionParserTokenValidator.isLetter(firstChar) || firstChar == 95;
    }

    private static boolean isValidInbetweenCharForValidation(int codePoint, int firstChar, int lastChar) {
        if (firstChar == 91 && lastChar == 93) {
            return true;
        }
        return IdentifierUtil.isValidInbetweenCharForGeneration(codePoint);
    }

    private static boolean isValidInbetweenCharForGeneration(int codePoint) {
        return V5QueryExpressionParserTokenValidator.isLetterOrDigit(codePoint) || codePoint == 95;
    }

    public static boolean isValidIdentifier(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return false;
        }
        IntStream characters = identifier.codePoints();
        PrimitiveIterator.OfInt it = characters.iterator();
        int firstChar = identifier.codePointAt(0);
        if (!IdentifierUtil.isValidFirstCharacterForGeneration(firstChar)) {
            return false;
        }
        while (it.hasNext()) {
            int codePoint = it.nextInt();
            if (IdentifierUtil.isValidInbetweenCharForGeneration(codePoint)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidIdentifierForValidation(String identifier) {
        int lastChar;
        if (identifier == null || identifier.isEmpty()) {
            return false;
        }
        IntStream characters = identifier.codePoints();
        PrimitiveIterator.OfInt it = characters.iterator();
        int last = identifier.length() - 1;
        int firstChar = identifier.codePointAt(0);
        if (!IdentifierUtil.isValidFirstLastCharacterForValidation(firstChar, lastChar = identifier.codePointAt(last))) {
            return false;
        }
        while (it.hasNext()) {
            int codePoint = it.nextInt();
            if (IdentifierUtil.isValidInbetweenCharForValidation(codePoint, firstChar, lastChar)) continue;
            return false;
        }
        return true;
    }
}

