/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.validation;

import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.ValidationMessage;

public class Diagnostic {
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    private int severity = 0;
    private String label;
    private int featureID;
    private MoserObject object;
    private ValidationMessage validationMessage;

    private static int getSeverityCode(String severity) {
        if ("ok".equals(severity)) {
            return 0;
        }
        if ("error".equals(severity)) {
            return 4;
        }
        if ("warning".equals(severity)) {
            return 2;
        }
        if ("info".equals(severity)) {
            return 1;
        }
        return 0;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setValidationMessage(ValidationMessage message) {
        this.validationMessage = message;
        int msgSeverity = Diagnostic.getSeverityCode(message.getSeverity());
        if (this.severity < msgSeverity) {
            this.severity = msgSeverity;
        }
    }

    public ValidationMessage getValidationMessages() {
        return this.validationMessage;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setFeatureID(int featureID) {
        this.featureID = featureID;
    }

    public int getFeatureID() {
        return this.featureID;
    }

    public MoserObject getObject() {
        return this.object;
    }

    public void setObject(MoserObject obj) {
        this.object = obj;
    }

    public void setProperties(MoserObject object, String data, ValidationMessage message, int featureId) {
        this.setValidationMessage(message);
        this.setLabel(data);
        this.setFeatureID(featureId);
        this.setObject(object);
    }
}

