/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.phrasespec;

import java.util.List;
import simplenlg.features.DiscourseFunction;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.framework.PhraseCategory;
import simplenlg.framework.PhraseElement;
import simplenlg.phrasespec.NPPhraseSpec;

public class PPPhraseSpec
extends PhraseElement {
    public PPPhraseSpec(NLGFactory phraseFactory) {
        super(PhraseCategory.PREPOSITIONAL_PHRASE);
        this.setFactory(phraseFactory);
    }

    public void setPreposition(Object preposition) {
        if (preposition instanceof NLGElement) {
            this.setHead(preposition);
        } else {
            NLGElement prepositionalElement = this.getFactory().createWord(preposition, LexicalCategory.PREPOSITION);
            this.setHead(prepositionalElement);
        }
    }

    public NLGElement getPreposition() {
        return this.getHead();
    }

    public void setObject(Object object) {
        NPPhraseSpec objectPhrase = this.getFactory().createNounPhrase(object);
        objectPhrase.setFeature("discourse_function", (Object)DiscourseFunction.OBJECT);
        this.addComplement(objectPhrase);
    }

    public NLGElement getObject() {
        List<NLGElement> complements = this.getFeatureAsElementList("complements");
        for (NLGElement complement : complements) {
            if (complement.getFeature("discourse_function") != DiscourseFunction.OBJECT) continue;
            return complement;
        }
        return null;
    }
}

