/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.function;

import com.ibm.smarts.common.mq.function.SmartsModuleFunction;
import com.ibm.smarts.common.mq.function.SmartsModuleFunctionResult;
import com.ibm.smarts.common.mq.message.SmartsModuleMessage;
import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.mq.MessageProducerProvider;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.nlp.core.tasks.TokenizeColumnsTaskImpl;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.HashMap;

public class TokenizeColumnsFunction
extends SmartsModuleFunction<SmartsModuleMessage> {
    private final SmartNLP nlp;

    TokenizeColumnsFunction(String taskId, IStoreProvider storeProvider, SmartNLP nlp) {
        super(taskId, storeProvider, SmartsModuleMessage.class);
        this.nlp = nlp;
    }

    public SmartsModuleFunctionResult doApply(RequestContext rc, MessageProducerProvider producerProvider, SmartsModuleMessage message) {
        String moduleId = message.getSmartsModuleId();
        String datasetId = message.getDatasetId();
        SmartsTaskContext taskContext = new SmartsTaskContext(moduleId, datasetId, null, rc, this.storeProvider);
        taskContext.setProperty("nlp", (Object)this.nlp);
        TokenizeColumnsTaskImpl impl = new TokenizeColumnsTaskImpl();
        try {
            impl.execute(taskContext);
        }
        catch (InternalException ex) {
            return new SmartsModuleFunctionResult();
        }
        HashMap<String, SmartsModuleMessage> outgoingMessages = new HashMap<String, SmartsModuleMessage>();
        outgoingMessages.put("smartsmodule.fanout.column.token", new SmartsModuleMessage(message.getSmartsModuleId(), message.getDatasetId(), message.getResourceURI()));
        return new SmartsModuleFunctionResult(outgoingMessages);
    }
}

