/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.grammar;

import com.ibm.smarts.nlp.api.grammar.PartOfSpeech;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ESPartOfSpeech {
    ao0000("ao0000", "Adjective (ordinal)", PartOfSpeech.JJ),
    aq0000("aq0000", "Adjective (descriptive)", PartOfSpeech.JJ),
    cc("cc", "Conjunction (coordinating)", PartOfSpeech.CC),
    cs("cs", "Conjunction (subordinating)", PartOfSpeech.CC),
    da0000("da0000", "Exclamative", PartOfSpeech.DT),
    di0000("di0000", "Article (indefinite)", PartOfSpeech.DT),
    dn0000("dn0000", "Numeral\ttres, doscientas", PartOfSpeech.DT),
    dp0000("dp0000", "Possessive\tsus, mi", PartOfSpeech.DT),
    dt0000("dt0000", "Interrogative", PartOfSpeech.DT),
    f0("f0", "Other", PartOfSpeech.PUNC),
    faa("faa", "Inverted exclamation mark", PartOfSpeech.PUNC),
    fat("fat", "Exclamation mark", PartOfSpeech.PUNC),
    fc("fc", "Comma", PartOfSpeech.COMMA),
    fd("fd", "Colon", PartOfSpeech.COLON),
    fe("fe", "Double quote", PartOfSpeech.OTHER),
    fg("fg", "Hyphen", PartOfSpeech.OTHER),
    fh("fh", "Forward slash", PartOfSpeech.OTHER),
    fia("fia", "Inverted question mark", PartOfSpeech.PUNC),
    fit("fit", "Question mark", PartOfSpeech.PUNC),
    fp("fp", "Period full-stop", PartOfSpeech.PUNC),
    fpa("fpa", "Left parenthesis", PartOfSpeech.LPAREN),
    fpt("fpt", "Right parenthesis", PartOfSpeech.RPAREN),
    fs("fs", "Ellipsis", PartOfSpeech.PUNC),
    ft("ft", "Percent", PartOfSpeech.NN),
    fx("fx", "Semicolon", PartOfSpeech.OTHER),
    fz("fz", "Single quote", PartOfSpeech.OTHER),
    i("i", "Interjection", PartOfSpeech.INTJ),
    nc00000("nc00000", "Unknown common noun (neologism, loanword)", PartOfSpeech.NN),
    nc0n000("nc0n000", "Common noun (invariant number)", PartOfSpeech.NN),
    nc0p000("nc0p000", "Common noun (plural)", PartOfSpeech.NNS),
    nc0s000("nc0s000", "Common noun (singular)", PartOfSpeech.NN),
    np00000("np00000", "Proper noun", PartOfSpeech.NNP),
    p0000000("p0000000", "Impersonal", PartOfSpeech.PRP),
    pd000000("pd000000", "Demonstrative pronoun", PartOfSpeech.PRP),
    pe000000("pe000000", "Exclamative", PartOfSpeech.PRP),
    pi000000("pi000000", "Indefinite pronoun", PartOfSpeech.PRP),
    pn000000("pn000000", "Numeral pronoun", PartOfSpeech.PRP),
    pp000000("pp000000", "Personal pronoun", PartOfSpeech.PRP),
    pr000000("pr000000", "Relative pronoun", PartOfSpeech.PRP),
    pt000000("pt000000", "Interrogative pronoun", PartOfSpeech.PRP),
    px000000("px000000", "Possessive pronoun", PartOfSpeech.PRP$),
    rg("rg", "Adverb (general)", PartOfSpeech.RB),
    rn("rn", "Adverb (negating)", PartOfSpeech.RB),
    sp000("sp000", "Preposition", PartOfSpeech.IN),
    vag0000("vag0000", "Verb (auxiliary, gerund)", PartOfSpeech.VB),
    vaic000("vaic000", "Verb (auxiliary, indicative, conditional)", PartOfSpeech.VB),
    vaif000("vaif000", "Verb (auxiliary, indicative, future)", PartOfSpeech.VB),
    vaii000("vaii000", "Verb (auxiliary, indicative, imperfect)", PartOfSpeech.VB),
    vaip000("vaip000", "Verb (auxiliary, indicative, present)", PartOfSpeech.VB),
    vais000("vais000", "Verb (auxiliary, indicative, preterite)", PartOfSpeech.VB),
    vam0000("vam0000", "Verb (auxiliary, imperative)", PartOfSpeech.VB),
    van0000("van0000", "Verb (auxiliary, infinitive)", PartOfSpeech.VB),
    vap0000("vap0000", "Verb (auxiliary, participle)", PartOfSpeech.VB),
    vasi000("vasi000", "Verb (auxiliary, subjunctive, imperfect)", PartOfSpeech.VB),
    vasp000("vasp000", "Verb (auxiliary, subjunctive, present)", PartOfSpeech.VB),
    vmg0000("vmg0000", "Verb (main, gerund)", PartOfSpeech.VB),
    vmic000("vmic000", "Verb (main, indicative, conditional)", PartOfSpeech.VB),
    vmif000("vmif000", "Verb (main, indicative, future)", PartOfSpeech.VB),
    vmii000("vmii000", "Verb (main, indicative, imperfect)", PartOfSpeech.VB),
    vmip000("vmip000", "Verb (main, indicative, present)", PartOfSpeech.VB),
    vmis000("vmis000", "Verb (main, indicative, preterite)", PartOfSpeech.VB),
    vmm0000("vmm0000", "Verb (main, imperative)", PartOfSpeech.VB),
    vmn0000("vmn0000", "Verb (main, infinitive)", PartOfSpeech.VB),
    vmp0000("vmp0000", "Verb (main, participle)", PartOfSpeech.VB),
    vmsi000("vmsi000", "Verb (main, subjunctive, imperfect)", PartOfSpeech.VB),
    vmsp000("vmsp000", "Verb (main, subjunctive, present)", PartOfSpeech.VB),
    vsg0000("vsg0000", "Verb (semiauxiliary, gerund)", PartOfSpeech.VB),
    vsic000("vsic000", "Verb (semiauxiliary, indicative, conditional)", PartOfSpeech.VB),
    vsif000("vsif000", "Verb (semiauxiliary, indicative, future)", PartOfSpeech.VB),
    vsii000("vsii000", "Verb (semiauxiliary, indicative, imperfect)", PartOfSpeech.VB),
    vsip000("vsip000", "Verb (semiauxiliary, indicative, present)", PartOfSpeech.VB),
    vsis000("vsis000", "Verb (semiauxiliary, indicative, preterite)", PartOfSpeech.VB),
    vsm0000("vsm0000", "Verb (semiauxiliary, imperative)", PartOfSpeech.VB),
    vsn0000("vsn0000", "Verb (semiauxiliary, infinitive)", PartOfSpeech.VB),
    vsp0000("vsp0000", "Verb (semiauxiliary, participle)", PartOfSpeech.VB),
    vssf000("vssf000", "Verb (semiauxiliary, subjunctive, future)", PartOfSpeech.VB),
    vssi000("vssi000", "Verb (semiauxiliary, subjunctive, imperfect)", PartOfSpeech.VB),
    vssp000("vssp000", "Verb (semiauxiliary, subjunctive, present)", PartOfSpeech.VB),
    w("w", "Date", PartOfSpeech.NN),
    z0("z0", "Numeral", PartOfSpeech.CD),
    zm("zm", "Numeral qualifier (currency)", PartOfSpeech.NN),
    zu("zu", "Numeral qualifier (other units)", PartOfSpeech.NN),
    word("word", "Emoticon or other symbol", PartOfSpeech.PUNC),
    conj("conj", "Conjunction\tNo obstante", PartOfSpeech.CONJP),
    gerundi("gerundi", "Gerund", PartOfSpeech.NP),
    grupa("grup.a", "Adjective group", PartOfSpeech.ADJP),
    grupadv("grup.adv", "Adverb group", PartOfSpeech.ADVP),
    grupcc("grup.cc", "Coordinating conjunction group", PartOfSpeech.CONJP),
    grupcs("grup.cs", "Subordinating conjunction group", PartOfSpeech.CONJP),
    grupnom("grup.nom", "Noun group", PartOfSpeech.NP),
    grupprep("grup.prep", "Preposition group", PartOfSpeech.PP),
    gruppron("grup.pron", "Pronoun group", PartOfSpeech.PRP),
    grupverb("grup.verb", "Verb group", PartOfSpeech.VP),
    grupw("grup.w", "Date group", PartOfSpeech.NP),
    grupz("grup.z", "Numeral group", PartOfSpeech.QP),
    inc("inc", "Inserted element", PartOfSpeech.FRAG),
    infinitiu("infinitiu", "Infinitive", PartOfSpeech.X),
    interjeccio("interjeccio", "Interjection", PartOfSpeech.INTJ),
    morfemapronominal("morfema.pronominal", "Pronominal morpheme", PartOfSpeech.PRP),
    morfemaverbal("morfema.verbal", "Verbal morpheme", PartOfSpeech.VB),
    neg("neg", "Negation", PartOfSpeech.JJ),
    participi("participi", "Participle", PartOfSpeech.VBN),
    prep("prep", "Preposition", PartOfSpeech.PP),
    relatiu("relatiu", "Relative pronoun", PartOfSpeech.WP),
    ROOT("ROOT", "Sentence root", PartOfSpeech.TOP),
    S("S", "Clause", PartOfSpeech.S),
    sa("s.a", "Adjective phrase", PartOfSpeech.ADJP),
    sadv("sadv", "Adverbial phrase", PartOfSpeech.ADVP),
    sentence("sentence", "Main sentence", PartOfSpeech.SINV),
    sn("sn", "Noun phrase", PartOfSpeech.NP),
    sp("sp", "Prepositional phrase", PartOfSpeech.PP),
    spec("spec", "Specifier", PartOfSpeech.X);

    private final String description;
    private final PartOfSpeech enPos;
    private static final Map<String, ESPartOfSpeech> nameToValueMap;
    private final String value;

    private ESPartOfSpeech(String value, String description, PartOfSpeech enPos) {
        this.value = value;
        this.description = description;
        this.enPos = enPos;
    }

    public String descriptionString() {
        return this.value + "-" + this.description + " - " + this.name();
    }

    public static PartOfSpeech getEnPOS(String value) {
        ESPartOfSpeech pos = nameToValueMap.get(value);
        if (pos == null) {
            return PartOfSpeech.OTHER;
        }
        return pos.enPos;
    }

    static {
        nameToValueMap = new HashMap<String, ESPartOfSpeech>();
        for (ESPartOfSpeech pos : EnumSet.allOf(ESPartOfSpeech.class)) {
            nameToValueMap.put(pos.value, pos);
        }
    }
}

