/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.uima;

import com.ibm.smarts.nlp.core.uima.LWSpellAid;
import com.ibm.smarts.nlp.core.uima.LWSpellAidImpl;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class LWSpellAidManager {
    private static final LWSpellAidManager MANAGER = new LWSpellAidManager();
    private static final Map<String, LWSpellAid> SPELLAID_REGISTRY = new HashMap<String, LWSpellAid>(1);

    static void register(String language, LWSpellAid aid) {
        if (aid != null && aid.isAvailable()) {
            SPELLAID_REGISTRY.put(language, aid);
        }
    }

    public LWSpellAid getSpellAid(String languageCode) {
        return SPELLAID_REGISTRY.get(languageCode);
    }

    public static LWSpellAidManager getInstance() {
        return MANAGER;
    }

    public void dispose() {
        for (String key : SPELLAID_REGISTRY.keySet()) {
            SPELLAID_REGISTRY.get(key).dispose();
        }
        SPELLAID_REGISTRY.clear();
    }

    static {
        Properties propsEN = new Properties();
        propsEN.setProperty("language", "en");
        propsEN.setProperty("dictionary", "dictionary/0/en-XX-LLex-7030.dic");
        propsEN.setProperty("checkOnlyAscii", "TRUE");
        LWSpellAidManager.register(Locale.ENGLISH.getLanguage(), new LWSpellAidImpl(propsEN));
        Properties propsES = new Properties();
        propsES.setProperty("language", "es");
        propsES.setProperty("dictionary", "dictionary/10/es-ES-LLex-7006.dic");
        LWSpellAidManager.register(Locale.forLanguageTag("es").getLanguage(), new LWSpellAidImpl(propsES));
    }
}

