/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier;

import com.ibm.smarts.core.api.BaseApi;
import com.ibm.smarts.internal.ontology.api.ClueManager;
import com.ibm.smarts.internal.ontology.api.ConceptClassifier;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.ontologymanager.OntologyResourceManager;
import java.util.List;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.model.OWLOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConceptClassifier<T, R>
extends BaseApi
implements ConceptClassifier<T, R> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseConceptClassifier.class);
    protected OntologyResourceManager resourceManager;
    protected ClueManager<?> clueManager;

    protected BaseConceptClassifier() {
    }

    protected BaseConceptClassifier(OntologyResourceManager resourceMgr, ClueManager<?> clueMgr) {
        this.resourceManager = resourceMgr;
        this.clueManager = clueMgr;
    }

    protected void setResourceManager(OntologyResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    protected void setClueManager(ClueManager<?> clueManager) {
        this.clueManager = clueManager;
    }

    protected ClueManager<?> getClueManager() {
        return this.clueManager;
    }

    protected OntologyResourceManager getResourceManager() {
        return this.resourceManager;
    }

    protected List<Ontology<OWLOntology>> resolveDomains(String ontologyID) {
        List detectDomains = this.getResourceManager().getDomainOntologyManager().getOntologies();
        return detectDomains.stream().filter(o -> o.getOntologyID().equals(ontologyID)).collect(Collectors.toList());
    }
}

