/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.model.value.IntegerValue;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.ontology.classifier.AbstractClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.reasoner.ClassCollector;
import com.ibm.smarts.ontology.reasoner.DataHintReasoner;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.ObjectFactory;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.schema.TokenInfo;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.slf4j.MDC;

public abstract class AbstractSmartsModuleClassificationStep
extends AbstractClassificationStep<SmartsModuleClassificationPkg> {
    public static final String DATASET_ID = "DatasetID";
    public static final String COLUMN_NAME = "ColumnID";
    public static final String COLUMN_INDEX = "ColumnIndex";
    protected static final float DEFAULT_SCORE = 0.01f;
    protected static final float DEFAULT_MEASURE_SCORE = 0.0115f;
    protected static final String CATEGORICAL_ID = "http://www.ibm.com/ontologies/waca/application#Categorical";
    protected static final String CONTINUOUS_ID = "http://www.ibm.com/ontologies/waca/application#Continuous";
    protected static final String MEASURE_TYPE_ID = "http://www.ibm.com/ontologies/waca/application#MeasureType";
    protected static final String TIMETYPE_ID = "http://www.ibm.com/ontologies/waca/application#TimeType";
    protected static final String EMPTY_ID = "http://www.ibm.com/ontologies/waca/application#Empty";
    protected static final String TEMPORAL_ID = "http://www.ibm.com/ontologies/waca/domain/common#Temporal";
    protected static final String GEOGRAPHY_ID = "http://www.ibm.com/ontologies/waca/domain/common#Geography";
    protected static final String IDENTIFIER_ID = "http://www.ibm.com/ontologies/waca/domain/common#Identifier";
    protected static final String ACTUAL = "Actual";
    protected static final String ACTUAL_ID = "http://www.ibm.com/ontologies/waca/domain/common#Actual";
    protected static final String PLANNED_ID = "http://www.ibm.com/ontologies/waca/domain/common#Planned";
    protected static final IRI ACTUAL_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/domain/common#Actual");
    protected static final IRI PLANNED_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/domain/common#Planned");
    protected static final IRI CATEGORICAL_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#Categorical");
    protected static final IRI CONTINUOUS_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#Continuous");
    protected static final IRI TEMPORAL_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/domain/common#Temporal");
    protected static final IRI GEOGRAPHY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/domain/common#Geography");
    protected static final IRI AGGREGATION_ROOT_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/domain/common#Aggregation");
    protected static final IRI IDENTIFIER_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/domain/common#Identifier");
    protected static final IRI ROWIDENTIFIER_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/domain/common#RowIdentifier");
    protected static final IRI CAPTION_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/domain/common#Caption");
    protected static final IRI DESCRIPTION_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/domain/common#Description");
    protected static final IRI HAS_ATTRIBUTE_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#hasAttribute");
    protected static final IRI HAS_PATTERN_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#hasPattern");
    protected static final IRI NOT_INDEXABLE_CLASS_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#notIndexable");
    protected static final IRI HAS_BOOST_FACTOR_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#hasBoostFactor");
    protected static final IRI HAS_PART_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#hasPart");
    protected static final IRI HAS_DATA_HINT_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#hasDataHint");
    protected static final IRI DATA_MIN_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataMin");
    protected static final IRI DATA_VALUE_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataValue");
    protected static final IRI DATA_VALUE_LENGTH_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataValueLength");
    protected static final IRI DATA_COUNT_PROPETY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataCount");
    protected static final IRI DATA_DISTINCT_COUNT_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataDistinctCount");
    protected static final IRI DATA_NULL_COUNT_PROPETY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataNullCount");
    protected static final IRI DATA_UNIQUE_VALUE_RATIO_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataUniqueValueRatio");
    protected static final IRI DATA_REPETITION_RATIO_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataRepetitionRatio");
    protected static final IRI DATA_COLUMN_INDEX_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataColumnIndex");
    protected static final IRI DATA_DENSITY_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataDensity");
    protected static final IRI DATA_DECORATION_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataDecoration");
    protected static final IRI DATA_QUARTILE_UPPER_RATIO_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataQuartileUpperRatio");
    protected static final IRI DATA_QUARTILE_LOWER_RATIO_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataQuartileLowerRatio");
    protected static final IRI DATA_STEP_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataStep");
    protected static final IRI BOOST_FACTOR_WEIGHT_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#boostFactorWeight");
    protected static final List<IRI> COMMON_DOMAIN_CONCEPT_IRIS = Arrays.asList(MEASURE_ROOT_IRI, ENTITY_ROOT_IRI, IDENTIFIER_IRI, ROWIDENTIFIER_IRI);
    public static final IRI DATA_MAX_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataMax");
    private static final int SAMPLE_SIZE_CAP = 50;
    protected final ObjectFactory objFactory;
    private Random random = new SecureRandom();

    protected AbstractSmartsModuleClassificationStep(RequestContext requestContext) {
        super(requestContext);
        this.objFactory = new ObjectFactory();
    }

    protected List<String> getCleanedSampleData(ColumnInfo column) {
        List sample = column.getSampleDistinctValues();
        if (sample.isEmpty()) {
            sample = column.getSamples();
        }
        List cleanedSample = sample.stream().filter(Objects::nonNull).filter(s -> !StringUtils.isBlank((CharSequence)s)).collect(Collectors.toList());
        return cleanedSample.subList(0, Math.min(cleanedSample.size(), 50));
    }

    protected void clearMDC() {
        MDC.remove((String)DATASET_ID);
        MDC.remove((String)COLUMN_INDEX);
        MDC.remove((String)COLUMN_NAME);
    }

    protected void mdcDSInfo(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        MDC.put((String)DATASET_ID, (String)("[" + dsPkg.getDataset().getId() + "]"));
    }

    protected void mdcColInfo(int index, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg) {
        MDC.put((String)COLUMN_INDEX, (String)("[" + index + "]"));
        MDC.put((String)COLUMN_NAME, (String)("[" + columnPkg.getColumnInfo().getName() + "]"));
    }

    protected boolean isApplicatoinConcept(ConceptInfo concept) {
        return ConceptsUtil.getOntologyId((ConceptInfo)concept).equals("http://www.ibm.com/ontologies/waca/application");
    }

    protected boolean isDomainConcept(ConceptInfo concept) {
        return !this.isApplicatoinConcept(concept);
    }

    protected boolean isTemporal(Optional<SmartsModuleClassificationPkg.Candidate> candidate, OWLReasoner reasoner, OWLDataFactory factory) {
        if (candidate.isPresent()) {
            return reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(candidate.get().getConceptID()), true).containsEntity((OWLObject)factory.getOWLClass(TEMPORAL_IRI));
        }
        return false;
    }

    protected boolean isTemporal(ConceptInfo concept, OWLReasoner reasoner, OWLDataFactory factory) {
        return concept.getConceptID().equals(TEMPORAL_ID) || reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(IRI.create((String)concept.getConceptID())), true).containsEntity((OWLObject)factory.getOWLClass(TEMPORAL_IRI));
    }

    protected boolean isGeography(ConceptInfo concept, OWLReasoner reasoner, OWLDataFactory factory) {
        return concept.getConceptID().equals(GEOGRAPHY_ID) || reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(IRI.create((String)concept.getConceptID())), true).containsEntity((OWLObject)factory.getOWLClass(GEOGRAPHY_IRI));
    }

    protected boolean isMoserTaxonomyConcept(ConceptInfo concept, OWLReasoner reasoner, OWLDataFactory factory) {
        return this.isTemporal(concept, reasoner, factory) || this.isGeography(concept, reasoner, factory);
    }

    protected boolean isMeasureConcept(ConceptInfo concept, OWLReasoner reasoner, OWLDataFactory factory) {
        return IRI.create((String)concept.getConceptID()).equals((Object)MEASURE_ROOT_IRI) || reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(IRI.create((String)concept.getConceptID())), false).containsEntity((OWLObject)factory.getOWLClass(MEASURE_ROOT_IRI));
    }

    protected boolean isMeasureColumn(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, OWLReasoner reasoner, OWLDataFactory factory) {
        return columnPkg.getCandidates().stream().filter(c -> c.getRelevance() > 0.0f).anyMatch(c -> this.isMeasure((SmartsModuleClassificationPkg.Candidate)c, reasoner, factory));
    }

    protected boolean isMeasureColumn(SemanticInfo column, OWLReasoner reasoner, OWLDataFactory factory) {
        return column.getConcepts().stream().filter(c -> Float.compare(c.getConfidence(), 0.0f) > 0).anyMatch(c -> this.isMeasureConcept((ConceptInfo)c, reasoner, factory));
    }

    protected boolean isActualMeasureColumn(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, OWLReasoner reasoner, OWLDataFactory factory) {
        Optional<SmartsModuleClassificationPkg.Candidate> can = columnPkg.getCandidates().stream().filter(c -> c.getRelevance() > 0.0f).sorted(Comparator.comparingDouble(SmartsModuleClassificationPkg.Candidate::getRelevance).reversed()).findFirst();
        if (can.isPresent()) {
            return this.isActualMeasure(can.get(), reasoner, factory);
        }
        return false;
    }

    protected boolean hasActualMeasureConcept(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, OWLReasoner reasoner, OWLDataFactory factory) {
        return columnPkg.getCandidates().stream().filter(c -> c.getRelevance() > 0.0f).anyMatch(c -> this.isActualMeasure((SmartsModuleClassificationPkg.Candidate)c, reasoner, factory));
    }

    protected boolean isMeasure(SmartsModuleClassificationPkg.Candidate candidate, OWLReasoner reasoner, OWLDataFactory factory) {
        return this.isAbstractMeasure(candidate) || this.isActualMeasure(candidate, reasoner, factory);
    }

    protected boolean isAbstractMeasure(SmartsModuleClassificationPkg.Candidate candidate) {
        return candidate.getConceptID().equals((Object)MEASURE_ROOT_IRI);
    }

    protected boolean isAbstractEntity(SmartsModuleClassificationPkg.Candidate candidate) {
        return candidate.getConceptID().equals((Object)ENTITY_ROOT_IRI);
    }

    protected boolean isActualMeasure(SmartsModuleClassificationPkg.Candidate candidate, OWLReasoner reasoner, OWLDataFactory factory) {
        return reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(candidate.getConceptID()), false).containsEntity((OWLObject)factory.getOWLClass(MEASURE_ROOT_IRI));
    }

    protected boolean isAggregation(ConceptInfo concept, OWLReasoner reasoner, OWLDataFactory factory) {
        return reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(IRI.create((String)concept.getConceptID())), false).containsEntity((OWLObject)factory.getOWLClass(AGGREGATION_ROOT_IRI));
    }

    protected boolean isEntity(ConceptInfo conceptInfo, OWLReasoner reasoner, OWLDataFactory factory) {
        return this.isEntity(IRI.create((String)conceptInfo.getConceptID()), reasoner, factory);
    }

    protected boolean isEntity(SmartsModuleClassificationPkg.Candidate candidate, OWLReasoner reasoner, OWLDataFactory factory) {
        return this.isEntity(candidate.getConceptID(), reasoner, factory);
    }

    protected boolean isEntity(IRI conceptIRI, OWLReasoner reasoner, OWLDataFactory factory) {
        if (conceptIRI.equals((Object)ENTITY_ROOT_IRI)) {
            return true;
        }
        NodeSet supers = reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(conceptIRI), false);
        return supers.containsEntity((OWLObject)factory.getOWLClass(ENTITY_ROOT_IRI)) && !supers.containsEntity((OWLObject)factory.getOWLClass(IDENTIFIER_IRI));
    }

    protected boolean isIdentifierColumn(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, OWLReasoner reasoner, OWLDataFactory factory) {
        return columnPkg.getCandidates().stream().filter(c -> c.getRelevance() > 0.0f).anyMatch(c -> this.isIdentifier((SmartsModuleClassificationPkg.Candidate)c, reasoner, factory));
    }

    protected boolean isIdentifierColumn(SemanticInfo column, OWLReasoner reasoner, OWLDataFactory factory) {
        return column.getConcepts().stream().filter(c -> Float.compare(c.getConfidence(), 0.0f) > 0).anyMatch(c -> this.isIdentifierConcept((ConceptInfo)c, reasoner, factory));
    }

    protected boolean isIdentifier(SmartsModuleClassificationPkg.Candidate candidate, OWLReasoner reasoner, OWLDataFactory factory) {
        if (candidate.getConceptID().equals((Object)IDENTIFIER_IRI)) {
            return true;
        }
        return reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(candidate.getConceptID()), false).containsEntity((OWLObject)factory.getOWLClass(IDENTIFIER_IRI));
    }

    protected boolean isIdentifierConcept(ConceptInfo concept, OWLReasoner reasoner, OWLDataFactory factory) {
        if (IRI.create((String)concept.getConceptID()).equals((Object)IDENTIFIER_IRI)) {
            return true;
        }
        return reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(IRI.create((String)concept.getConceptID())), false).containsEntity((OWLObject)factory.getOWLClass(IDENTIFIER_IRI));
    }

    protected boolean isApplicableConcept(IRI concept, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology, OWLDataFactory factory, OWLReasoner reasoner) {
        HashMap<IRI, List<ConceptInfo>> propertyValues = new HashMap<IRI, List<ConceptInfo>>();
        List<ConceptInfo> patterns = columnPkg.getConcepts();
        propertyValues.put(HAS_PATTERN_PROPERTY_IRI, patterns);
        return Float.compare(DataHintReasoner.evaluateDataHintRestriction(factory.getOWLClass(concept), propertyValues, columnPkg.getDataPropertyValues(), (List<String>)columnPkg.getColumnInfo().getSamples(), (OWLOntology)ontology.getValue(), reasoner, this.currentReqCtx), 0.0f) > 0;
    }

    protected static OWL2Datatype getOWL2Datatype(ColumnInfo column) {
        OWL2Datatype dataType = null;
        switch (column.getDataType().getBaseType()) {
            case BOOLEAN: {
                dataType = OWL2Datatype.XSD_BOOLEAN;
                break;
            }
            case STRING: 
            case UNKNOWN: {
                dataType = OWL2Datatype.XSD_STRING;
                break;
            }
            case INTEGER: 
            case LONG: 
            case BYTE: 
            case SHORT: {
                dataType = OWL2Datatype.XSD_INTEGER;
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                dataType = OWL2Datatype.XSD_DOUBLE;
                break;
            }
            case DECIMAL: {
                dataType = OWL2Datatype.XSD_DECIMAL;
                break;
            }
            case DATE: {
                dataType = OWL2Datatype.XSD_DATE_TIME;
                break;
            }
            case TIME: 
            case TIMESTAMP: {
                dataType = OWL2Datatype.XSD_DATE_TIME_STAMP;
                break;
            }
            default: {
                dataType = OWL2Datatype.XSD_STRING;
            }
        }
        return dataType;
    }

    @Deprecated
    protected float getEntityScore(OWLClass entity, OWLReasoner reasoner) {
        return 0.01f * (float)reasoner.getSuperClasses((OWLClassExpression)entity, false).getNodes().size();
    }

    protected Set<OWLClass> getEntities(OWLClass aClass, OWLOntology ontology, OWLReasoner reasoner, OWLDataFactory factory) {
        OWLObjectProperty hasAttributeObjectProperty = factory.getOWLObjectProperty(HAS_ATTRIBUTE_PROPERTY_IRI);
        return ClassCollector.collectClassesHasObjectPropertyWithFillerInSignature(hasAttributeObjectProperty, aClass, ontology, reasoner, false).stream().collect(Collectors.toSet());
    }

    protected void addConcept(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, IRI conceptID, ObjectFactory objFactory, float confidence) {
        ConceptInfo concept = objFactory.createConceptInfo();
        concept.setConceptID(conceptID.toString());
        concept.setConfidence(confidence);
        columnPkg.addConcept(concept);
    }

    protected float computeConfidenceScore(SmartsModuleClassificationPkg.Candidate e) {
        return Math.min(1.0f, Math.max(e.getRelevance(), e.getLexicalRelevance()) * SmartsModuleClassificationPkg.Candidate.LEXICAL_FACTOR + e.getDataHintRelevance() * SmartsModuleClassificationPkg.Candidate.DATAHINT_FACTOR + e.getDataValueRelevance() * SmartsModuleClassificationPkg.Candidate.DATAVALUE_FACTOR);
    }

    protected Stream<SmartsModuleClassificationPkg.Candidate> getEntities(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg) {
        return columnPkg.getCandidates().stream().map(columnPkg::getEntityCandidates).flatMap(Collection::stream);
    }

    protected Optional<SmartsModuleClassificationPkg.ColumnClassificationPkg> getGroupIDOrDetailMemberColumn(SmartsModuleClassificationPkg.LogicalGroup group, boolean idOnly) {
        Optional<Pair<Optional<SmartsModuleClassificationPkg.Candidate>, SmartsModuleClassificationPkg.ColumnClassificationPkg>> idGroupMember = this.getGroupIDOrDetailMember(group, idOnly);
        if (idGroupMember.isPresent()) {
            return Optional.of(idGroupMember.get().getSecond());
        }
        return Optional.empty();
    }

    protected Optional<Pair<Optional<SmartsModuleClassificationPkg.Candidate>, SmartsModuleClassificationPkg.ColumnClassificationPkg>> getGroupIDOrDetailMember(SmartsModuleClassificationPkg.LogicalGroup group, boolean idOnly) {
        Optional<Pair<Optional<SmartsModuleClassificationPkg.Candidate>, SmartsModuleClassificationPkg.ColumnClassificationPkg>> idGroupMember = group.getGroupMembers().stream().filter(m -> ((SmartsModuleClassificationPkg.Candidate)((Optional)m.getFirst()).get()).getConceptID().equals((Object)IDENTIFIER_IRI)).findFirst();
        if (idGroupMember.isPresent() || idOnly) {
            return idGroupMember;
        }
        idGroupMember = group.getGroupMembers().stream().sorted(Comparator.comparingInt(c -> this.getStatisticByType(((SmartsModuleClassificationPkg.ColumnClassificationPkg)c.getSecond()).getColumnInfo(), StatisticType.DISTINCT_COUNT)).reversed()).findFirst();
        return idGroupMember;
    }

    protected Optional<SmartsModuleClassificationPkg.ColumnClassificationPkg> getGroupIDMember(SmartsModuleClassificationPkg.LogicalGroup group) {
        return group.getGroupMembers().stream().filter(m -> ((SmartsModuleClassificationPkg.Candidate)((Optional)m.getFirst()).get()).getConceptID().equals((Object)IDENTIFIER_IRI)).map(Pair::getSecond).findFirst();
    }

    protected int getStatisticByType(ColumnInfo column, StatisticType type) {
        return column.getStatistics().stream().filter(s -> s.getType().equals((Object)type)).map(Statistic::getValue).findFirst().orElse((Value)new IntegerValue(0)).intValue();
    }

    protected int getNameMatchingScore(SmartsModuleClassificationPkg.LogicalGroup group, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg) {
        Optional<SmartsModuleClassificationPkg.ColumnClassificationPkg> groupIDMember = this.getGroupIDOrDetailMemberColumn(group, false);
        if (!groupIDMember.isPresent()) {
            return -1;
        }
        return this.getNameMatchingScore(groupIDMember.get().getColumnInfo(), columnPkg.getColumnInfo());
    }

    protected int getNameMatchingScore(Optional<SmartsModuleClassificationPkg.ColumnClassificationPkg> column1, Optional<SmartsModuleClassificationPkg.ColumnClassificationPkg> column2) {
        if (!column1.isPresent() || !column2.isPresent()) {
            return -1;
        }
        return this.getNameMatchingScore(column1.get().getColumnInfo(), column2.get().getColumnInfo());
    }

    protected int getNameMatchingScore(ColumnInfo column1, ColumnInfo column2) {
        Set commonLammas;
        Set groupLammas = ((PhraseInfo)column1.getLabel().getPhrases().get(0)).getTokens().stream().filter(t -> !t.getPOS().equalsIgnoreCase("unknown")).map(TokenInfo::getLemma).collect(Collectors.toSet());
        Set columnLammas = ((PhraseInfo)column2.getLabel().getPhrases().get(0)).getTokens().stream().filter(t -> !t.getPOS().equalsIgnoreCase("unknown")).map(TokenInfo::getLemma).collect(Collectors.toSet());
        if (columnLammas.size() == 1 && groupLammas.size() == 1) {
            return 1;
        }
        if (groupLammas.size() >= columnLammas.size()) {
            groupLammas.retainAll(columnLammas);
            commonLammas = groupLammas;
        } else {
            columnLammas.retainAll(groupLammas);
            commonLammas = columnLammas;
        }
        return commonLammas.isEmpty() ? 0 : commonLammas.size() + 1;
    }

    protected boolean meetOneManyRatioRequirement(ColumnInfo left, ColumnInfo right) {
        int leftDistinctCount = this.getStatisticByType(left, StatisticType.DISTINCT_COUNT);
        int rightDistinctCount = this.getStatisticByType(right, StatisticType.DISTINCT_COUNT);
        double ratio = (double)rightDistinctCount / (double)leftDistinctCount;
        return Double.compare(ratio, 1.5) >= 0;
    }

    protected Set<OWLClass> collectHasPartRestriction(OWLClass cClass, OWLOntology ontology) {
        return this.getChildrenLevelConcepts(cClass, ontology, HAS_PART_PROPERTY_IRI);
    }

    protected int getDescendantLevelsConcepts(Set<OWLClass> descendants, OWLClass cClass, OWLOntology ontology) {
        Set<OWLClass> children = this.collectHasPartRestriction(cClass, ontology);
        children.removeAll(descendants);
        descendants.addAll(children);
        children.stream().forEach(c -> this.getDescendantLevelsConcepts(descendants, (OWLClass)c, ontology));
        return children.size();
    }

    protected ConceptInfo createConceptInfo(SmartsModuleClassificationPkg.Candidate candidate) {
        ConceptInfo eConcept = this.objFactory.createConceptInfo();
        eConcept.setConceptID(candidate.getConceptID().toString());
        eConcept.setConfidence(this.computeConfidenceScore(candidate));
        return eConcept;
    }

    protected boolean shouldExecute(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, DeltaAnalysisScope deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty ... props) {
        if (deltaAnalysisScope == null) {
            return true;
        }
        DeltaAnalysisScope.ScopedColumns scopedColumns = deltaAnalysisScope.getScopedColumns();
        if (scopedColumns.equals((Object)DeltaAnalysisScope.ScopedColumns.SOME)) {
            boolean shouldExecute = false;
            Set modifiableProps = (Set)deltaAnalysisScope.getColumnPropertiesDelta().get(columnPkg.getColumnInfo().getIdForExpression());
            if (modifiableProps != null && !modifiableProps.isEmpty()) {
                for (DeltaAnalysisScope.ModifiableProperty prop : props) {
                    if (!modifiableProps.contains(prop)) continue;
                    shouldExecute = true;
                    break;
                }
            }
            return shouldExecute;
        }
        return scopedColumns.equals((Object)DeltaAnalysisScope.ScopedColumns.ALL);
    }

    protected boolean shouldSkip(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, DeltaAnalysisScope deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty ... props) {
        if (deltaAnalysisScope == null) {
            return false;
        }
        if (deltaAnalysisScope.getScopedColumns().equals((Object)DeltaAnalysisScope.ScopedColumns.SOME)) {
            if (deltaAnalysisScope.getColumnPropertiesDelta() != null && ((Set)deltaAnalysisScope.getColumnPropertiesDelta().get(columnPkg.getColumnInfo().getIdForExpression())).containsAll(Arrays.asList(props))) {
                return true;
            }
        } else if (deltaAnalysisScope.getScopedColumns().equals((Object)DeltaAnalysisScope.ScopedColumns.ALL)) {
            return false;
        }
        return false;
    }

    protected boolean onlyPropModified(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, DeltaAnalysisScope deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty props) {
        boolean onlyPropModified = false;
        if (deltaAnalysisScope == null) {
            return onlyPropModified;
        }
        Set modifiableProps = (Set)deltaAnalysisScope.getColumnPropertiesDelta().get(columnPkg.getColumnInfo().getIdForExpression());
        if (modifiableProps != null && modifiableProps.size() == 1 && ((DeltaAnalysisScope.ModifiableProperty)modifiableProps.iterator().next()).equals((Object)props)) {
            onlyPropModified = true;
        }
        return onlyPropModified;
    }

    protected boolean hasModifiedDelta(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, DeltaAnalysisScope deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty prop) {
        boolean hasModifiedDelta = false;
        if (deltaAnalysisScope != null && columnPkg.getColumnInfo().getSemanticInfo() != null && columnPkg.getColumnInfo().getSemanticInfo().getOverwrites() != null) {
            Set modifiableProps;
            if (deltaAnalysisScope.getScopedColumns().equals((Object)DeltaAnalysisScope.ScopedColumns.ALL)) {
                hasModifiedDelta = columnPkg.getColumnInfo().getSemanticInfo().getOverwrites().containsKey((Object)prop.name());
            } else if (deltaAnalysisScope.getScopedColumns().equals((Object)DeltaAnalysisScope.ScopedColumns.SOME) && (modifiableProps = (Set)deltaAnalysisScope.getColumnPropertiesDelta().get(columnPkg.getColumnInfo().getIdForExpression())) != null && !modifiableProps.isEmpty()) {
                if (modifiableProps.contains(prop)) {
                    hasModifiedDelta = true;
                } else if (modifiableProps.contains(DeltaAnalysisScope.ModifiableProperty.ALL)) {
                    hasModifiedDelta = columnPkg.getColumnInfo().getSemanticInfo().getOverwrites().containsKey((Object)prop.name());
                }
            }
        }
        return hasModifiedDelta;
    }
}

