/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class CandidateConsolidation
extends AbstractSmartsModuleClassificationStep {
    private List<Ontology<OWLOntology>> mOntologies = null;

    protected CandidateConsolidation(List<Ontology<OWLOntology>> ontologies, RequestContext requestContext) {
        super(requestContext);
        this.mOntologies = ontologies;
    }

    @Override
    public void execute(SmartsModuleClassificationPkg smPkg) {
        smPkg.setModified(smPkg.getDatasetClassificationPkgs().parallelStream().map(this::consolidate).reduce(Boolean::logicalOr).orElse(false));
        this.clearMDC();
    }

    private boolean consolidate(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        this.mdcDSInfo(dsPkg);
        boolean bModified = false;
        List<SmartsModuleClassificationPkg.ColumnClassificationPkg> inScopeColPkgs = dsPkg.getInScopeColumnClassificationPkgs();
        if (inScopeColPkgs.isEmpty()) {
            return bModified;
        }
        for (int i = 0; i < inScopeColPkgs.size(); ++i) {
            if (!this.shouldExecute(inScopeColPkgs.get(i), dsPkg.getDelatAnalysisScope(), DeltaAnalysisScope.ModifiableProperty.ALL, DeltaAnalysisScope.ModifiableProperty.NAME) || !this.consolidate(i, inScopeColPkgs.get(i))) continue;
            bModified = true;
        }
        return bModified;
    }

    private boolean consolidate(int index, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg) {
        this.mdcColInfo(index, columnPkg);
        return this.mOntologies.stream().map(o -> this.consolidate(columnPkg, (Ontology<OWLOntology>)o)).reduce(Boolean::logicalOr).orElse(false);
    }

    private boolean consolidate(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology) {
        LOGGER.info("Consolidating entity candidate for [{}]", (Object)columnPkg.getColumnInfo().getId());
        OWLDataFactory factory = ((OWLOntology)ontology.getValue()).getOWLOntologyManager().getOWLDataFactory();
        OWLReasoner reasoner = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getDomainOntologyManager().getReasoner(ontology);
        List candidatesToRemove = Collections.synchronizedList(new ArrayList(columnPkg.getCandidates().size() / 2));
        Stream candidatesStream = this.isExecParallel() ? columnPkg.getCandidates().parallelStream() : columnPkg.getCandidates().stream();
        candidatesStream.forEach(current -> {
            OWLClass removableClass = factory.getOWLClass(current.getConceptID());
            columnPkg.getCandidates().stream().filter(other -> other != current).forEach(other -> {
                if (reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(other.getConceptID()), false).getFlattened().contains(removableClass) && (Float.compare(other.getRelevance(), current.getRelevance()) >= 0 || current.getConceptID().equals((Object)ENTITY_ROOT_IRI) && Float.compare(other.getRelevance(), 0.0f) > 0)) {
                    LOGGER.info("Remove Candidate {}({}) that is a super class of another candidate {}({})", new Object[]{removableClass.getIRI().getShortForm(), Float.valueOf(current.getRelevance()), other.getConceptID().getShortForm(), Float.valueOf(other.getRelevance())});
                    candidatesToRemove.add(current);
                }
            });
        });
        columnPkg.getCandidates().removeAll(candidatesToRemove);
        if (columnPkg.getColumnInfo().getKeyType() != null) {
            LOGGER.info("Increase Confidence of Identifier candidate for key column [{}]", (Object)columnPkg.getColumnInfo().getId());
            columnPkg.removeCandidate(MEASURE_ROOT_IRI);
            Optional<SmartsModuleClassificationPkg.Candidate> identifier = columnPkg.getCandidate(IDENTIFIER_IRI);
            if (identifier.isPresent()) {
                identifier.get().setRelevance(1.0f);
                identifier.get().setConfidence(1.0f);
            } else {
                columnPkg.addCandidate(Optional.of(new SmartsModuleClassificationPkg.Candidate(IDENTIFIER_IRI).setRelevance(1.0f).setConfidence(1.0f)));
            }
        }
        return !candidatesToRemove.isEmpty();
    }
}

