/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.text;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.ClueManager;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.BaseConceptClassifier;
import com.ibm.smarts.ontology.classifier.text.CandidateElection;
import com.ibm.smarts.ontology.classifier.text.Ensemble;
import com.ibm.smarts.ontology.classifier.text.TextSemanticAnalysisPipeline;
import com.ibm.smarts.ontology.classifier.text.TextSemanticAnalysisPkg;
import com.ibm.smarts.ontology.ontologymanager.OntologyResourceManager;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.TextInfo;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.semanticweb.owlapi.model.OWLOntology;

public class TextConceptClassifier
extends BaseConceptClassifier<TextInfo, List<List<ConceptInfo>>> {
    public TextConceptClassifier() {
    }

    protected TextConceptClassifier(OntologyResourceManager resourceMgr, ClueManager<?> clueMgr) {
        super(resourceMgr, clueMgr);
    }

    public List<List<ConceptInfo>> classify(RequestContext requestContext, TextInfo text) {
        return (List)this.handle(requestContext, ctx -> this.semanticAnalysis((RequestContext)ctx, text));
    }

    private String detectDomains(RequestContext requestContext) {
        Object id = requestContext.getAttribute("smarts.ontology.selected");
        if (null == id) {
            id = this.getResourceManager().getKnowledgeDiscoveryConfig().getProperty("smarts.ontology.selected");
        }
        String idStr = (String)id;
        LOGGER.warn("Selected ontology id: " + idStr);
        return idStr;
    }

    private List<List<ConceptInfo>> semanticAnalysis(RequestContext requestContext, TextInfo text) {
        Instant before = Instant.now();
        requestContext.setAttribute("clueManager", (Object)this.clueManager);
        requestContext.setAttribute("resourceManager", (Object)this.resourceManager);
        TextSemanticAnalysisPkg pkg = new TextSemanticAnalysisPkg(text);
        TextSemanticAnalysisPipeline pipeline = this.buildPipeline(requestContext, this.resolveDomains(this.detectDomains(requestContext)));
        pipeline.getIterator().forEachRemaining(s -> {
            Instant b = Instant.now();
            s.execute(pkg);
            LOGGER.info(String.format("%s step took [%s]ms", s.getName(), Duration.between(b, Instant.now()).toMillis()));
        });
        LOGGER.info(String.format("** Total classification took [%s]ms", Duration.between(before, Instant.now()).toMillis()));
        return pkg.getConcepts();
    }

    private TextSemanticAnalysisPipeline buildPipeline(RequestContext requestContext, List<Ontology<OWLOntology>> ontologies) {
        TextSemanticAnalysisPipeline pl = new TextSemanticAnalysisPipeline();
        pl.register(new CandidateElection(ontologies, requestContext));
        pl.register(new Ensemble(requestContext));
        return pl;
    }
}

