/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.util;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;

public class LRUCache<K, V> {
    private final int capacity;
    private ConcurrentLinkedQueue<K> cache;
    private ConcurrentHashMap<K, V> map;

    public LRUCache(int capacity) {
        this.capacity = capacity;
        this.cache = new ConcurrentLinkedQueue();
        this.map = new ConcurrentHashMap(capacity);
    }

    public List<V> getAll() {
        return this.map.values().stream().collect(Collectors.toList());
    }

    public V get(K key) {
        if (key == null) {
            throw new IllegalArgumentException("Key can not be null");
        }
        return this.map.get(key);
    }

    public void put(K key, V value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Key or Value can not be null");
        }
        if (this.map.containsKey(key)) {
            this.cache.remove(key);
        }
        while (this.cache.size() >= this.capacity) {
            K expiredKey = this.cache.poll();
            if (expiredKey == null) continue;
            this.map.remove(expiredKey);
        }
        this.cache.add(key);
        this.map.put(key, value);
    }

    public void dispose() {
        if (null != this.cache) {
            this.cache.clear();
            this.cache = null;
        }
        if (null != this.map) {
            this.map.clear();
            this.map = null;
        }
    }

    public void clear() {
        if (null != this.cache) {
            this.cache.clear();
        }
        if (null != this.map) {
            this.map.clear();
        }
    }
}

