/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.similarity.classifier.common.api;

import com.ibm.smarts.nlp.embedding.WordEmbedding;
import com.ibm.smarts.nlp.embedding.WordEmbeddingRegistry;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordEmbeddingProvider {
    private static final String EMBEDDING_REGISTRY_KEY = "similarityClassifierEmbeddings";
    private static final String OOV_EMBEDDING_REGISTRY_KEY = "similarityClassifierOovEmbeddings";
    private static final Logger LOGGER = LoggerFactory.getLogger(WordEmbeddingProvider.class);
    private static final String CONFIG_SUB_FOLDER = "similarity-classifier";
    private static final String EMBEDDINGS_FILE = "similarity_classifier_word_embeddings.gz";
    private static final String PRUNED_WORDS_FILE = "similarity_classifier_pruned_words.gz";
    private static final String OOV_EMBEDDINGS_FILE = "bigram.gz";
    private static final String ENCODING = "UTF-8";
    private static final int EMBEDDING_DIMENSION = 300;

    private WordEmbeddingProvider() {
    }

    public static void initialize(Properties config) {
        long startTime = System.currentTimeMillis();
        String configFolder = config.getProperty("smarts.core.configFolder");
        String embeddingsFilePath = configFolder + File.separator + CONFIG_SUB_FOLDER + File.separator + EMBEDDINGS_FILE;
        String prunedWordsFilePath = configFolder + File.separator + CONFIG_SUB_FOLDER + File.separator + PRUNED_WORDS_FILE;
        String oovEmbeddingsFilePath = configFolder + File.separator + CONFIG_SUB_FOLDER + File.separator + OOV_EMBEDDINGS_FILE;
        WordEmbeddingProvider.initialize(embeddingsFilePath, prunedWordsFilePath, oovEmbeddingsFilePath);
        LOGGER.debug("Initialization time = [{}]ms", (Object)(System.currentTimeMillis() - startTime));
    }

    public static void initialize(String embeddingsFilePath, String prunedWordsFilePath) {
        try {
            WordEmbeddingRegistry.getInstance().registerEmbedding(EMBEDDING_REGISTRY_KEY, embeddingsFilePath, prunedWordsFilePath, 300, ENCODING);
        }
        catch (IOException e) {
            LOGGER.error("Similarity classifier initialization failed.\nEmbeddings File = [{}]\nPruned Words File = [{}]", (Object)embeddingsFilePath, (Object)prunedWordsFilePath);
        }
    }

    public static void initialize(String embeddingsFilePath, String prunedWordsFilePath, String oovEmbeddingsFilePath) {
        WordEmbeddingProvider.initialize(embeddingsFilePath, prunedWordsFilePath);
        try {
            WordEmbeddingRegistry.getInstance().registerEmbedding(OOV_EMBEDDING_REGISTRY_KEY, oovEmbeddingsFilePath, null, 300, ENCODING);
        }
        catch (IOException e) {
            LOGGER.error("Similarity classifier initialization failed.\nOovEmbeddings File = [{}]", (Object)oovEmbeddingsFilePath);
        }
    }

    public static WordEmbedding getWordEmbedding() {
        return WordEmbeddingRegistry.getInstance().getWordEmbedding(EMBEDDING_REGISTRY_KEY);
    }

    public static WordEmbedding getBigramEmbedding() {
        return WordEmbeddingRegistry.getInstance().getWordEmbedding(OOV_EMBEDDING_REGISTRY_KEY);
    }
}

