/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.similarity.classifier.common.core;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorUtility {
    private static final Logger LOGGER = LoggerFactory.getLogger(VectorUtility.class);

    private VectorUtility() {
    }

    public static float[] add(float[] vector1, float[] vector2) {
        if (vector1.length != vector2.length) {
            LOGGER.error("Vector lengths not same while performing sum.");
            throw new IllegalArgumentException("Vector lengths not same while performing sum.");
        }
        float[] result = new float[vector1.length];
        IntStream.range(0, vector1.length).forEach(i -> {
            result[i] = vector1[i] + vector2[i];
        });
        return result;
    }

    public static float[] avg(List<float[]> vectors) {
        if (vectors == null || vectors.isEmpty()) {
            LOGGER.debug("Cannot compute the average of an empty/null list, returning an empty array.");
            return new float[0];
        }
        if (vectors.size() == 1) {
            return vectors.get(0);
        }
        int len = vectors.get(0).length;
        return vectors.stream().map(v -> VectorUtility.multiply(v, 1.0f / (float)vectors.size())).reduce(new float[len], VectorUtility::add);
    }

    public static float[] max(float[] vector1, float[] vector2) {
        if (vector1.length != vector2.length) {
            LOGGER.error("Vector lengths not same while performing max.");
            throw new IllegalArgumentException("Vector lengths not same while performing max.");
        }
        float[] result = new float[vector1.length];
        IntStream.range(0, vector1.length).forEach(i -> {
            result[i] = Math.max(vector1[i], vector2[i]);
        });
        return result;
    }

    public static float[] max(List<float[]> vectors) {
        if (vectors == null || vectors.isEmpty()) {
            LOGGER.debug("Cannot compute the element-wise of an empty/null list, returning an empty array.");
            return new float[0];
        }
        if (vectors.size() == 1) {
            return vectors.get(0);
        }
        Optional max = vectors.stream().reduce(VectorUtility::max);
        return max.isPresent() ? (float[])max.get() : new float[]{};
    }

    public static float[] subtract(float[] vector1, float[] vector2) {
        if (vector1.length != vector2.length) {
            LOGGER.error("Vector lengths not same while performing subtraction.");
            throw new IllegalArgumentException("Vector lengths not same while performing subtraction.");
        }
        float[] result = new float[vector1.length];
        IntStream.range(0, vector1.length).forEach(i -> {
            result[i] = vector1[i] - vector2[i];
        });
        return result;
    }

    public static double dot(float[] vector1, float[] vector2) {
        if (vector1.length != vector2.length) {
            LOGGER.error("Vector lengths not same while performing dot product.");
            throw new IllegalArgumentException("Vector lengths not same while performing dot product.");
        }
        double sum = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            sum += (double)(vector1[i] * vector2[i]);
        }
        return sum;
    }

    public static float[] multiply(float[] x, float a) {
        float[] y = new float[x.length];
        IntStream.range(0, x.length).forEach(i -> {
            y[i] = a * x[i];
        });
        return y;
    }

    public static float[] convex(float[] vector1, float[] vector2, float alpha) {
        if (vector1.length != vector2.length) {
            LOGGER.error("Vector lengths must be equal when computing a convex combination.");
            throw new IllegalArgumentException("Vector lengths must be equal when computing a convex combination.");
        }
        if (alpha > 1.0f || alpha < 0.0f) {
            LOGGER.error("To compute a convex combination, the scalar should be selected from the interval [0,1]");
            throw new IllegalArgumentException("To compute a convex combination, the scalar should be selected from the interval [0,1]");
        }
        return VectorUtility.add(VectorUtility.multiply(vector1, alpha), VectorUtility.multiply(vector2, 1.0f - alpha));
    }

    public static double norm(float[] vector) {
        if (null == vector) {
            LOGGER.error("Cannot compute the norm of a null vector.");
            throw new IllegalArgumentException("Cannot compute the norm of a null vector.");
        }
        return Math.sqrt(VectorUtility.dot(vector, vector));
    }
}

