/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl;

import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.ca.core.impl.search.CaSearchClient;
import com.ibm.smarts.ca.core.impl.store.SmartsCaClueStore;
import com.ibm.smarts.ca.core.impl.store.SmartsCaDataClueStore;
import com.ibm.smarts.ca.core.impl.store.SmartsCaFeatureStore;
import com.ibm.smarts.ca.core.impl.store.SmartsCaOntoVersionStore;
import com.ibm.smarts.ca.core.impl.store.SmartsCaPersistenceProvider;
import com.ibm.smarts.ca.core.impl.useractions.SmartsCaUserActionStore;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.store.api.IMultiRecordTrigger;
import com.ibm.smarts.store.api.TypeNames;
import com.ibm.smarts.store.api.config.StoreConfig;
import com.ibm.smarts.store.api.multirec.MRTRecord;
import com.ibm.smarts.store.api.multirec.MultiRecordTrigger;
import com.ibm.smarts.store.api.provider.IClueStore;
import com.ibm.smarts.store.api.provider.IDataClueStore;
import com.ibm.smarts.store.api.provider.IDataSourceStore;
import com.ibm.smarts.store.api.provider.IFeatureStore;
import com.ibm.smarts.store.api.provider.IFlowExecutorStore;
import com.ibm.smarts.store.api.provider.IInMemoryModuleStore;
import com.ibm.smarts.store.api.provider.IMRTStore;
import com.ibm.smarts.store.api.provider.IObjectStore;
import com.ibm.smarts.store.api.provider.IOntoVersionStore;
import com.ibm.smarts.store.api.provider.IPersistenceProvider;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.store.api.provider.IUserActionStore;
import com.ibm.smarts.store.inmem.InMemTypedStore;
import com.ibm.smarts.store.provider.SmartsMRTStore;
import com.ibm.smarts.store.provider.SmartsModuleStore;
import java.util.Locale;
import java.util.Properties;

public class SmartsCaStoreProvider
implements IStoreProvider {
    public final SmartsModuleStore moduleStore;
    public final InMemTypedStore<MRTRecord> mrtStore;
    private final IFlowExecutorStore flowExecutorStore;
    private final IObjectStore objectStore;
    public final Properties searchServiceConfig;

    public SmartsCaStoreProvider(SmartsModuleStore moduleStore, InMemTypedStore<MRTRecord> mrtStore, IFlowExecutorStore flowExecutorStore, IObjectStore objectStore, Properties searchServiceConfig) {
        this.moduleStore = moduleStore;
        this.mrtStore = mrtStore;
        this.flowExecutorStore = flowExecutorStore;
        this.objectStore = objectStore;
        this.searchServiceConfig = searchServiceConfig;
    }

    public IInMemoryModuleStore getModuleStore(RequestContext requestContext) {
        return this.moduleStore;
    }

    public IInMemoryModuleStore getModuleStore(StoreConfig config, RequestContext requestContext) {
        return this.moduleStore;
    }

    public IClueStore getClueStore(RequestContext requestContext) {
        return this.smartsCaClueStore(requestContext.locale, requestContext);
    }

    public IClueStore getClueStore(Locale localeOverride, RequestContext requestContext) {
        return this.smartsCaClueStore(localeOverride, requestContext);
    }

    private SmartsCaClueStore smartsCaClueStore(Locale locale, RequestContext requestContext) {
        CaSearchClient searchClient = this.caSearchClient(requestContext);
        StoreConfig sc = new StoreConfig(locale, TypeNames.CLUE);
        return new SmartsCaClueStore(sc, searchClient);
    }

    public IDataClueStore getDataClueStore(RequestContext requestContext) {
        return this.smartsCaDataClueStore(requestContext.locale, requestContext);
    }

    public IDataClueStore getDataClueStore(Locale locale, RequestContext requestContext) {
        return this.smartsCaDataClueStore(locale, requestContext);
    }

    private SmartsCaDataClueStore smartsCaDataClueStore(Locale locale, RequestContext requestContext) {
        CaSearchClient searchClient = this.caSearchClient(requestContext);
        StoreConfig sc = new StoreConfig(locale, TypeNames.DATA_CLUE);
        return new SmartsCaDataClueStore(sc, searchClient);
    }

    public IFeatureStore getFeatureStore(RequestContext requestContext) {
        CaSearchClient searchClient = this.caSearchClient(requestContext);
        StoreConfig sc = new StoreConfig(requestContext.locale, TypeNames.FEATURE);
        return new SmartsCaFeatureStore(sc, searchClient);
    }

    public IMRTStore getMRTStore() {
        return new SmartsMRTStore(this.mrtStore);
    }

    public IOntoVersionStore getOntoVersionStore(RequestContext requestContext) {
        return this.smartsCaOntoVersionStore(requestContext.locale, requestContext);
    }

    public IOntoVersionStore getOntoVersionStore(Locale localeOverride, RequestContext requestContext) {
        return this.smartsCaOntoVersionStore(localeOverride, requestContext);
    }

    private SmartsCaOntoVersionStore smartsCaOntoVersionStore(Locale locale, RequestContext requestContext) {
        CaSearchClient searchClient = this.caSearchClient(requestContext);
        StoreConfig sc = new StoreConfig(locale, TypeNames.CLUE);
        return new SmartsCaOntoVersionStore(sc, searchClient);
    }

    public <T> IMultiRecordTrigger<T> getMultiRecordTrigger(String type, RequestContext requestContext, Class<T> klass) {
        return new MultiRecordTrigger(type, requestContext, klass, this.mrtStore);
    }

    private CaSearchClient caSearchClient(RequestContext requestContext) {
        SmartsCaClientManager clientManager;
        ObjectCreator creator = (ObjectCreator)requestContext.getRequestAttribute("com.ibm.smarts.rest.clientManager");
        SmartsCaClientManager smartsCaClientManager = clientManager = creator != null ? (SmartsCaClientManager)((Object)creator.create(requestContext)) : null;
        if (clientManager == null) {
            throw new InternalException("CA client manager not found in request context", new Object[]{requestContext});
        }
        return clientManager.getSearchClient();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[SmartsCaStoreProvider");
        sb.append(" moduleStore=" + this.moduleStore);
        sb.append(" mrtStore=" + this.mrtStore);
        sb.append(" searchServiceConfig=" + this.searchServiceConfig);
        sb.append("]");
        String ret = sb.toString();
        return ret;
    }

    public IPersistenceProvider getPersistenceProvider(StoreConfig config) {
        return new SmartsCaPersistenceProvider();
    }

    public IPersistenceProvider getPersistenceProvider(StoreConfig config, RequestContext context) {
        return new SmartsCaPersistenceProvider();
    }

    public IUserActionStore getUserActionStore(StoreConfig config, RequestContext requestContext) {
        try {
            return new SmartsCaUserActionStore(config, requestContext);
        }
        catch (Exception e) {
            throw new InternalException("Exception thrown when creating SmartsCaUserActionStore.", new Object[]{e});
        }
    }

    public IDataSourceStore getDataSourceStore(StoreConfig config, RequestContext requestContext) {
        throw new InternalException("Smarts CA has no support yet for a data source store.", new Object[]{requestContext});
    }

    public IFlowExecutorStore getFlowExecutorStore() {
        return this.flowExecutorStore;
    }

    public <T> IObjectStore<T> getObjectStore() {
        return this.objectStore;
    }
}

