/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.rest.handlers;

import com.ibm.smarts.ca.rest.handlers.SmartsCaBaseRestApi;
import com.ibm.smarts.ca.rest.handlers.SmartsCaModuleApiImpl;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.schema.CancelOption;
import com.ibm.smarts.schema.SmartsModule;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="module")
@Api(value="smartsmodules", description="Rest API to get SmartsModules")
public class SmartsCaModuleApi
extends SmartsCaBaseRestApi {
    final SmartsCaModuleApiImpl moduleImpl;

    public SmartsCaModuleApi() {
        this.setUpContext();
        this.moduleImpl = new SmartsCaModuleApiImpl(this.system);
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a Smarts module", response=SmartsModule.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Smarts module not found")})
    public Response syncGet(@ApiParam(value="Data module store ID", required=true) @PathParam(value="id") String id, @ApiParam(value="Include failed Datasets") @DefaultValue(value="False") @QueryParam(value="includeFailedDatasets") Boolean includeFailedDatasets, @ApiParam(value="Include bi-variates") @DefaultValue(value="False") @QueryParam(value="includeBivariates") Boolean includeBivariates, @ApiParam(value="Include column embedding") @DefaultValue(value="False") @QueryParam(value="includeColumnEmbedding") Boolean includeColumnEmbedding, @ApiParam(value="Build and return a shallow SmartsModule if absent") @DefaultValue(value="False") @QueryParam(value="shallowBuildIfAbsent") Boolean shallowBuildIfAbsent, @ApiParam(value="Return only concepts") @DefaultValue(value="False") @QueryParam(value="conceptsOnly") Boolean conceptsOnly) {
        return this.handleRest(context -> {
            SmartsModuleOptions smartsModuleOptions = new SmartsModuleOptions.SmartsModuleOptionsBuilder().addFailedDataSets(includeFailedDatasets.booleanValue()).addBivariates(includeBivariates.booleanValue()).addColumnEmbedding(includeColumnEmbedding.booleanValue()).addConceptsOnly(conceptsOnly.booleanValue()).build();
            return this.moduleImpl.getSmartModule((RequestContext)context, id, smartsModuleOptions, shallowBuildIfAbsent);
        });
    }

    @GET
    @Path(value="{id}/progressSummary")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get progress of data module analysis")
    @ApiResponses(value={@ApiResponse(code=200, message="Analysis is complete"), @ApiResponse(code=202, message="Analysis is not complete")})
    public Response syncGetProgressSummary(@ApiParam(value="Data module store ID", required=true) @PathParam(value="id") String id, @ApiParam(value="AnalysisScope to reduce the datasets to check") @QueryParam(value="analysisScope") String analysisScope) {
        return this.handleRest(context -> this.moduleImpl.getSmartsModuleProgressSummary((RequestContext)context, id, analysisScope));
    }

    @GET
    @Path(value="{id}/status")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get status of smarts module")
    @ApiResponses(value={@ApiResponse(code=200, message="Smarts module status is fetched"), @ApiResponse(code=404, message="Smarts module not found")})
    public Response syncGetStatus(@ApiParam(value="Data module store ID", required=true) @PathParam(value="id") String id) {
        return this.handleRest(context -> this.moduleImpl.getSmartsModuleStatus((RequestContext)context, id));
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Cancel data module analysis")
    @ApiResponses(value={@ApiResponse(code=202, message="Analysis is canceled"), @ApiResponse(code=404, message="Smarts module not found")})
    public Response syncCancel(@ApiParam(value="Smarts module store ID", required=true) @PathParam(value="id") String id, @ApiParam(value="delete") @QueryParam(value="delete") Boolean delete) {
        boolean pDelete = delete != null ? delete : true;
        CancelOption cancelOption = pDelete ? CancelOption.CANCEL_WITH_DELETE : CancelOption.CANCEL;
        return this.handleRest(context -> this.moduleImpl.cancelSmartModule((RequestContext)context, id, cancelOption));
    }

    @POST
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Start analyzing a data module")
    @ApiResponses(value={@ApiResponse(code=404, message="Data module not found")})
    public Response createSmartsModule(@ApiParam(value="Asset store ID", required=true) @PathParam(value="id") String assetId, @ApiParam(value="Data module URI", required=true) @QueryParam(value="moduleUri") String moduleUri, @ApiParam(value="Data module type", required=true, allowableValues="module, base_module, database, uploadedFile") @QueryParam(value="type") String moduleType, @ApiParam(value="Analysis Mode", required=false, allowableValues="deep, shallow") @DefaultValue(value="deep") @QueryParam(value="analysisMode") String analysisMode, @ApiParam(value="Connection Specification. {\"connections\":[{\"datasource\":\"GOSALES\",\"connection\":\"gosales\", \"signon\": \"usr2\"}]}", required=false) @QueryParam(value="connections") String connections, @ApiParam(value="Load options", required=false) String loadOptionsRequest) {
        return this.handleRest(context -> this.moduleImpl.createSmartModule((RequestContext)context, assetId, moduleType, moduleUri, analysisMode, loadOptionsRequest, connections));
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a shallow smart module with the given moser module passed in the body")
    @ApiResponses(value={@ApiResponse(code=404, message="Data module not found")})
    public Response createSmartsModuleFromModule(@ApiParam(value="Query subjects to perform analysis on", required=false) @QueryParam(value="scope") List<String> includeList, @ApiParam(value="Module", required=true) String bodyModule) {
        return this.handleRest(context -> {
            if (bodyModule == null || bodyModule.isEmpty()) {
                return this.badRequest();
            }
            return this.moduleImpl.createSmartModuleFromModule((RequestContext)context, bodyModule, includeList);
        });
    }

    @GET
    @Path(value="{id}/keywords")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get keywords of data module analysis")
    @ApiResponses(value={@ApiResponse(code=200, message="Data module keywords"), @ApiResponse(code=404, message="Smarts module not found")})
    public Response syncGetKeywords(@ApiParam(value="Data module store ID", required=true) @PathParam(value="id") String id) {
        return this.handleRest(context -> this.moduleImpl.getSmartModuleKeywords((RequestContext)context, id));
    }
}

