/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.common.learning.Sentiment;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.exceptions.json.JsonDeserializeException;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.visualization.recommender.schema.AutoGrouping;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import com.ibm.smarts.visualization.recommender.schema.IRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.schema.VisColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
public class VisRecommendation {
    private String chartType;
    private String label;
    private String title;
    private String description;
    private List<VisColumn> columns;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private double score;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> unbound;
    private boolean ruleBreaker;
    private boolean isMandatorySlotsMissing;
    private Map<String, AutoGrouping> autoGroupingMap = new HashMap<String, AutoGrouping>();
    private List<BaseFilter> filters = new ArrayList<BaseFilter>();
    private Sentiment sentiment = Sentiment.NONE;

    public VisRecommendation(String chartType, String label, String title, String description, List<VisColumn> columns, Map<String, AutoGrouping> autoGroupingMap, List<BaseFilter> filters) {
        this.chartType = chartType;
        this.label = label;
        this.title = title;
        this.description = description;
        this.columns = columns;
        if (autoGroupingMap != null) {
            this.autoGroupingMap = autoGroupingMap;
        }
        if (filters != null) {
            this.setFilters(filters);
        }
    }

    public VisRecommendation(String chartType, String label, String title, String description, List<VisColumn> columns) {
        this.chartType = chartType;
        this.label = label;
        this.title = title;
        this.description = description;
        this.columns = columns;
    }

    public VisRecommendation(String chartType, String label, String title, String description, List<VisColumn> columns, List<String> unbound, boolean isMandatorySlotsMissing) {
        this(chartType, label, title, description, columns);
        this.unbound = unbound;
        this.isMandatorySlotsMissing = isMandatorySlotsMissing;
    }

    public VisRecommendation(String chartType, String label, String title, String description, List<VisColumn> columns, List<String> unbound, boolean isMandatorySlotsMissing, Map<String, AutoGrouping> autoGroupingMap, List<BaseFilter> filters) {
        this(chartType, label, title, description, columns);
        this.unbound = unbound;
        this.isMandatorySlotsMissing = isMandatorySlotsMissing;
        if (autoGroupingMap != null) {
            this.autoGroupingMap.putAll(autoGroupingMap);
        }
        if (filters != null) {
            this.setFilters(filters);
        }
    }

    public VisRecommendation(String chartType, String label, String title, String description, List<VisColumn> columns, double score) {
        this(chartType, label, title, description, columns);
        this.score = score;
    }

    public VisRecommendation(String chartType, String label, String title, String description, List<VisColumn> columns, double score, Map<String, AutoGrouping> autoGroupingMap, Map<String, AggregationType> aggregationMap, List<BaseFilter> filters) {
        this(chartType, label, title, description, columns);
        this.score = score;
        if (autoGroupingMap != null) {
            this.autoGroupingMap.putAll(autoGroupingMap);
        }
        if (filters != null) {
            this.setFilters(filters);
        }
    }

    public VisRecommendation(String chartType, String label, String title, String description, List<VisColumn> columns, Double score, List<String> unbound, Map<String, AutoGrouping> autoGroupingMap, List<BaseFilter> filters) {
        this(chartType, label, title, description, columns, score, unbound, false, autoGroupingMap, filters);
    }

    @JsonCreator
    public VisRecommendation(@JsonProperty(value="chartType") String chartType, @JsonProperty(value="label") String label, @JsonProperty(value="title") String title, @JsonProperty(value="description") String description, @JsonProperty(value="columns") List<VisColumn> columns, @JsonProperty(value="score") Double score, @JsonProperty(value="unbound") List<String> unbound, @JsonProperty(value="isMandatorySlotsMissing") boolean isMandatorySlotsMissing, @JsonProperty(value="autoGroupingMap") Map<String, AutoGrouping> autoGroupingMap, @JsonProperty(value="filters") List<BaseFilter> filters) {
        this(chartType, label, title, description, columns, unbound, isMandatorySlotsMissing, autoGroupingMap, filters);
        this.score = score;
    }

    public boolean isMandatorySlotsMissing() {
        return this.isMandatorySlotsMissing;
    }

    public VisRecommendation(IRecommendedVisualization rv) {
        this.chartType = rv.getLabel();
        this.label = rv.getNaturalLanguageLabel();
        this.title = rv.getNaturalLanguageTitle();
        this.description = rv.getNaturalLanguageDescription();
        this.columns = rv.getColumnBindings().stream().map(b -> new VisColumn((Binding)b, rv.getAggregationMap().get(b.getColumns().get(0)))).collect(Collectors.toList());
        this.score = rv.getScore();
        this.autoGroupingMap.putAll(rv.getAutoGrouping().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new AutoGrouping(((AutoGrouping)e.getValue()).size))));
        this.setFilters(rv.getBaseFilterList());
        this.setSentiment(rv.getSentiment());
    }

    private void setSentiment(Sentiment sentiment) {
        this.sentiment = sentiment;
    }

    public Sentiment getSentiment() {
        return this.sentiment;
    }

    public String getChartType() {
        return this.chartType;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VisRecommendation)) {
            return false;
        }
        VisRecommendation that = (VisRecommendation)o;
        return Double.compare(that.getScore(), this.getScore()) == 0 && this.isRuleBreaker() == that.isRuleBreaker() && this.isMandatorySlotsMissing() == that.isMandatorySlotsMissing() && Objects.equals(this.getChartType(), that.getChartType()) && Objects.equals(this.getLabel(), that.getLabel()) && Objects.equals(this.getTitle(), that.getTitle()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getColumns(), that.getColumns()) && Objects.equals(this.getUnbound(), that.getUnbound()) && Objects.equals(this.getAutoGroupingMap(), that.getAutoGroupingMap()) && Objects.equals(this.getFilters(), that.getFilters()) && this.getSentiment() == that.getSentiment();
    }

    public int hashCode() {
        return Objects.hash(this.getChartType(), this.getLabel(), this.getTitle(), this.getDescription(), this.getColumns(), this.getScore(), this.getUnbound(), this.isRuleBreaker(), this.isMandatorySlotsMissing(), this.getAutoGroupingMap(), this.getFilters(), this.getSentiment());
    }

    public String toString() {
        return "VisRecommendation{chartType='" + this.chartType + '\'' + ", label='" + this.label + '\'' + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", columns=" + this.columns + ", score=" + this.score + ", unbound=" + this.unbound + ", ruleBreaker=" + this.ruleBreaker + ", isMandatorySlotsMissing=" + this.isMandatorySlotsMissing + ", autoGroupingMap=" + this.autoGroupingMap + ", filters=" + this.filters + ", sentiment=" + this.sentiment + '}';
    }

    public List<VisColumn> getColumns() {
        return this.columns;
    }

    public Double getScore() {
        return this.score;
    }

    public List<String> getUnbound() {
        return this.unbound;
    }

    public void setScore(double d) {
        this.score = d;
    }

    public boolean isRuleBreaker() {
        return this.ruleBreaker;
    }

    public void setRuleBreaker(boolean b) {
        this.ruleBreaker = b;
    }

    public void setChartType(String chartType) {
        this.chartType = chartType;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setColumns(List<VisColumn> columns) {
        this.columns = columns;
    }

    public void setUnbound(List<String> unbound) {
        this.unbound = unbound;
    }

    public void setMandatorySlotsMissing(boolean mandatorySlotsMissing) {
        this.isMandatorySlotsMissing = mandatorySlotsMissing;
    }

    public Map<String, AutoGrouping> getAutoGroupingMap() {
        return this.autoGroupingMap;
    }

    public void setAutoGroupingMap(Map<String, AutoGrouping> autoGroupingMap) {
        this.autoGroupingMap = autoGroupingMap;
    }

    public List<BaseFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<BaseFilter> filters) {
        this.filters = filters;
    }

    public String toJSON() {
        return CommonJAXBHelper.marshalToJSON((Object)this, (boolean)true);
    }

    public static VisRecommendation fromJSON(String str) {
        try {
            return (VisRecommendation)CommonJAXBHelper.unmarshalFromJSON(VisRecommendation.class, (String)str);
        }
        catch (JsonDeserializeException e) {
            return null;
        }
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        json.put((Object)"chartType", (Object)this.chartType);
        json.put((Object)"label", (Object)this.label);
        json.put((Object)"title", (Object)this.title);
        json.put((Object)"description", (Object)this.description);
        json.put((Object)"score", (Object)this.score);
        if (this.columns != null) {
            JSONArray jsonColumns = new JSONArray();
            this.columns.stream().forEach(c -> jsonColumns.add((Object)c.toJSONObject()));
            json.put((Object)"columns", (Object)jsonColumns);
        }
        if (this.unbound != null) {
            JSONArray jsonUnbound = new JSONArray();
            this.unbound.stream().forEach(arg_0 -> ((JSONArray)jsonUnbound).add(arg_0));
            json.put((Object)"unbound", (Object)jsonUnbound);
        }
        JSONObject autoGroupingMapJson = new JSONObject();
        this.autoGroupingMap.entrySet().forEach(e -> autoGroupingMapJson.put(e.getKey(), (Object)((AutoGrouping)e.getValue()).toJSONObject()));
        json.put((Object)"autoGroupingMap", (Object)autoGroupingMapJson);
        JSONArray filtersJson = new JSONArray();
        if (this.filters != null) {
            this.filters.forEach(f -> filtersJson.add((Object)f.toJSONObject()));
        }
        json.put((Object)"autoGroupingMap", (Object)autoGroupingMapJson);
        json.put((Object)"filters", (Object)filtersJson);
        json.put((Object)"sentiment", (Object)this.sentiment.toString());
        return json;
    }
}

