/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.utilities.model;

import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.api.ICredentials;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.Feature;
import com.ibm.smarts.schema.FeatureType;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.TokenInfo;
import com.ibm.smarts.schema.util.OntologyCommon;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FeatureExtractor {
    public static List<Feature> extractFeature(RequestContext rc, SmartsModule smartsModule, String assetRef) {
        List dataSets;
        String userID;
        String tenantID;
        if (rc == null) {
            throw new IllegalArgumentException("request context is null");
        }
        if (smartsModule == null) {
            return Collections.emptyList();
        }
        ICredentials creds = rc.getCredentials();
        if (creds != null) {
            tenantID = creds.getTenantId();
            userID = creds.getUserId();
        } else {
            tenantID = "notenant";
            userID = "nouser";
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        Feature smartsModuleNameFeature = FeatureExtractor.createFeature(smartsModule, null, tenantID, assetRef);
        smartsModuleNameFeature.setFeatureType(FeatureType.SMARTSMODULE_NAME);
        smartsModuleNameFeature.setFeatureKey(smartsModule.getName());
        if (smartsModule.getLabel() != null) {
            smartsModuleNameFeature.setFeatureTextInfo(CommonJAXBHelper.marshalToJSON((Object)smartsModule.getLabel()));
        }
        if (smartsModule.getName() != null) {
            smartsModuleNameFeature.setFeatureKeyLC(smartsModule.getName().toLowerCase());
        }
        features.add(smartsModuleNameFeature);
        String description = smartsModule.getDescription();
        if (StringUtils.isNotBlank((CharSequence)description)) {
            Feature smartsModuleDescriptionFeature = FeatureExtractor.createFeature(smartsModule, null, tenantID, assetRef);
            smartsModuleDescriptionFeature.setFeatureType(FeatureType.SMARTSMODULE_DESC);
            smartsModuleDescriptionFeature.setFeatureKey(description);
            if (smartsModule.getDescriptionLabel() != null) {
                smartsModuleDescriptionFeature.setFeatureTextInfo(CommonJAXBHelper.marshalToJSON((Object)smartsModule.getDescriptionLabel()));
            }
            smartsModuleDescriptionFeature.setFeatureKeyLC(description.toLowerCase());
            features.add(smartsModuleDescriptionFeature);
        }
        if ((dataSets = smartsModule.getDatasets()) != null) {
            for (DatasetInfo dataSet : dataSets) {
                if (dataSet == null) continue;
                Feature dataSetFeature = FeatureExtractor.createFeature(smartsModule, dataSet, tenantID, assetRef);
                dataSetFeature.setFeatureType(FeatureType.DATASET_NAME);
                dataSetFeature.setFeatureKey(dataSet.getName());
                if (dataSet.getName() != null) {
                    dataSetFeature.setFeatureKeyLC(dataSet.getName().toLowerCase());
                }
                FeatureExtractor.extractLexicalInfo(dataSetFeature, dataSet.getLabel());
                features.add(dataSetFeature);
                List<Feature> columnFeatures = FeatureExtractor.addColumnFeatures(dataSet, smartsModule, tenantID, assetRef);
                features.addAll(columnFeatures);
            }
        }
        long timeNow = System.currentTimeMillis();
        features.forEach(f -> {
            f.setTenantID(tenantID);
            f.setUserID(tenantID);
            f.setCreationDate(timeNow);
            f.setLastModifiedDate(timeNow);
        });
        return features;
    }

    private static List<Feature> addColumnFeatures(DatasetInfo dataSet, SmartsModule smartsModule, String tenantID, String assetRef) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        List columns = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataSet);
        if (columns == null) {
            return features;
        }
        for (ColumnInfo column : columns) {
            List concepts;
            if (column == null) continue;
            Feature columnFeature = FeatureExtractor.createFeature(smartsModule, dataSet, tenantID, assetRef);
            columnFeature.setFeatureType(FeatureType.COLUMN_NAME);
            columnFeature.setFeatureKey(column.getName());
            if (column.getName() != null) {
                columnFeature.setFeatureKeyLC(column.getName().toLowerCase());
            }
            columnFeature.setColumnInfoRef(column.getId());
            columnFeature.setIdForExpression(column.getIdForExpression());
            FeatureExtractor.extractLexicalInfo(columnFeature, column.getLabel());
            SemanticInfo semanticInfo = column.getSemanticInfo();
            if (semanticInfo != null && (concepts = semanticInfo.getConcepts()) != null) {
                FeatureExtractor.addConcepts(ConceptsRegistry.instance().getConcepts(concepts.stream().map(ConceptInfo::getConceptID).collect(Collectors.toList())), columnFeature);
            }
            column.getSamples().clear();
            column.getSampleDistinctValues().clear();
            column.getSampleDistinctValueCounts().clear();
            columnFeature.setColumnInfo(CommonJAXBHelper.marshalToJSON((Object)column));
            features.add(columnFeature);
        }
        return features;
    }

    private static void extractLexicalInfo(Feature featureToIndex, TextInfo label) {
        if (label != null) {
            featureToIndex.setFeatureTextInfo(CommonJAXBHelper.marshalToJSON((Object)label));
            List phrases = label.getPhrases();
            if (phrases != null) {
                for (PhraseInfo phrase : phrases) {
                    List tokens;
                    if (phrase == null || (tokens = phrase.getTokens()) == null) continue;
                    StringBuilder lemmaBuf = new StringBuilder();
                    StringBuilder tokenizedBuf = new StringBuilder();
                    for (int i = 0; i < tokens.size() - 1; ++i) {
                        TokenInfo token = (TokenInfo)tokens.get(i);
                        if (token == null) continue;
                        lemmaBuf.append(token.getLemma() + " ");
                        tokenizedBuf.append(token.getText() + " ");
                    }
                    TokenInfo lastToken = (TokenInfo)tokens.get(tokens.size() - 1);
                    lemmaBuf.append(lastToken.getLemma());
                    tokenizedBuf.append(lastToken.getText());
                    featureToIndex.setFeatureKeyLemma(lemmaBuf.toString());
                    featureToIndex.setFeatureKeyTokenized(tokenizedBuf.toString());
                }
            }
        }
    }

    private static Feature createFeature(SmartsModule smartsModule, DatasetInfo dataSet, String tenantID, String assetRef) {
        Feature feature = new Feature();
        feature.setAssetRef(assetRef);
        if (smartsModule != null) {
            feature.setSmartsModuleRef(smartsModule.getId());
        }
        if (dataSet != null) {
            feature.setDatasetRef(dataSet.getId());
        }
        long dateLong = 123L;
        feature.setCreationDate(dateLong);
        feature.setLastModifiedDate(dateLong);
        feature.setTenantID(tenantID);
        return feature;
    }

    private static void addConcepts(List<Concept> concepts, Feature columnFeature) {
        Set conceptsAndAncestors = concepts.stream().flatMap(c -> c.getAncestors().stream()).collect(Collectors.toSet());
        conceptsAndAncestors.addAll(concepts);
        List filteredConcepts = conceptsAndAncestors.stream().filter(concept -> concept.getIRI().contains("/common#")).map(Concept::getName).filter(cName -> !OntologyCommon.getUnsearcableConceptShortNames().contains(cName) && !columnFeature.getSearchableConcepts().contains(cName)).collect(Collectors.toList());
        columnFeature.getSearchableConcepts().addAll(filteredConcepts);
    }
}

