/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core;

import com.ibm.smarts.fields.recommender.api.RecommendationStatus;
import com.ibm.smarts.fields.recommender.core.AnalysisStep;
import com.ibm.smarts.fields.recommender.core.BaseFieldsAnalysisContext;
import com.ibm.smarts.fields.recommender.core.exceptions.IFRInvalidInputException;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.InScopeTable;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class FieldsInputScopeValidation<T extends BaseFieldsAnalysisContext>
implements AnalysisStep<T> {
    @Override
    public void execute(@Nonnull T fieldsAnalysisContext) {
        Optional.ofNullable(((BaseFieldsAnalysisContext)fieldsAnalysisContext).getRequestContext()).orElseThrow(() -> new IFRInvalidInputException(RecommendationStatus.INVALID_REQUESTCONTEXT));
        Optional.ofNullable(((BaseFieldsAnalysisContext)fieldsAnalysisContext).getSmartsModule()).orElseThrow(() -> new IFRInvalidInputException(RecommendationStatus.INVALID_MISSING_SMARTSMODULE));
        Optional.ofNullable(((BaseFieldsAnalysisContext)fieldsAnalysisContext).getAnalysisScope()).ifPresent(as -> this.validateAnalysisScope((AnalysisScope)as, fieldsAnalysisContext.getSmartsModule()));
    }

    protected List<String> getFieldsFilterUID(InScopeTable ist) {
        return ist.getInScopeFieldIDs().stream().map(fid -> this.toFieldUID((String)fid, ist.getTableID())).collect(Collectors.toList());
    }

    protected boolean validateAnalysisScope(AnalysisScope as, SmartsModule smartsModule) {
        if (as.getInScopeTables().isEmpty() || as.getInScopeTables().stream().allMatch(ist -> this.isInvalidInScopeTable((InScopeTable)ist, smartsModule))) {
            throw new IFRInvalidInputException(RecommendationStatus.INVALID_ANALYSIS_SCOPE_TABLE);
        }
        if (as.getInScopeTables().stream().anyMatch(ist -> this.hasInvalidField((InScopeTable)ist, smartsModule))) {
            throw new IFRInvalidInputException(RecommendationStatus.INVALID_ANALYSIS_SCOPE_FIELD);
        }
        return true;
    }

    protected boolean hasInvalidField(InScopeTable ist, SmartsModule smartsModule) {
        Optional<DatasetInfo> dsInfo;
        if (ist.getInScopeFieldIDs() != null && !ist.getInScopeFieldIDs().isEmpty() && (dsInfo = smartsModule.getDatasets().stream().filter(table -> table.getId().equals(ist.getTableID())).findFirst()).isPresent()) {
            DatasetInfo ds = dsInfo.get();
            if (ist.getInScopeFieldIDs().stream().anyMatch(fID -> SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds).stream().noneMatch(col -> col.getId().equals(fID)))) {
                return true;
            }
        }
        return false;
    }

    protected boolean isInvalidInScopeTable(InScopeTable table, SmartsModule smartsModule) {
        return smartsModule.getDatasets().stream().noneMatch(ds -> ds.getId().equals(table.getTableID()));
    }
}

