/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core.influencers;

import com.ibm.smarts.fields.recommender.core.AbstractAnalysisStep;
import com.ibm.smarts.fields.recommender.core.influencers.InfluencersAnalysisContext;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import com.ibm.smarts.schema.FieldsRecommendation;
import com.ibm.smarts.schema.FieldsRecommendationType;
import com.ibm.smarts.schema.util.Builder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class Ensemble
extends AbstractAnalysisStep<InfluencersAnalysisContext> {
    private static final int UPPER_LIMIT = 250;

    @Override
    public void execute(@Nonnull InfluencersAnalysisContext rfac) {
        FieldsRecommendation recommendation = (FieldsRecommendation)Builder.create(FieldsRecommendation.class).with(fr -> fr.setType(FieldsRecommendationType.INFLUENCER)).build();
        ArrayList records = new ArrayList(rfac.getInfluencersCandidates().size());
        rfac.getInfluencersCandidates().stream().filter(r -> !this.isTarget((InfluencersAnalysisContext.InfluencerCandidate)r, rfac)).forEach(r -> {
            r.setStatsScore((float)(1.0 - Math.exp(-r.getStatsScore())));
            r.setConfidence((float)((double)r.getInfluentialScore() * 0.5 + (double)r.getStatsScore() * 0.5));
            records.add(Builder.create(FieldRecommendationRecord.class).with(frr -> frr.setFieldID(r.getField().getId())).with(frr -> frr.setFieldIDForExpression(r.getField().getIdForExpression())).with(frr -> frr.setTableID(r.getTableID())).with(frr -> frr.setConfidence(r.getConfidence())).build());
        });
        List results = records.stream().sorted(Comparator.comparing(FieldRecommendationRecord::getConfidence).reversed().thenComparing(FieldRecommendationRecord::getFieldID)).collect(Collectors.toList());
        if (!rfac.hasNoCorrelationLimit() && Float.compare(rfac.getCorrelationLowerLimit(), 0.0f) > 0 && !this.isMeasureCalculation(rfac.getTargetField())) {
            results = results.stream().filter(f -> Float.compare(f.getConfidence(), 0.0f) > 0).collect(Collectors.toList());
        }
        if (results.size() > 250) {
            results = results.subList(0, 250);
        }
        recommendation.getRecommendedFields().addAll(results);
        rfac.setRecommendation(recommendation);
    }

    private boolean isTarget(InfluencersAnalysisContext.InfluencerCandidate candidate, InfluencersAnalysisContext rfac) {
        return candidate.getTableID().equals(rfac.getTargetFieldTableID()) && candidate.getField().getId().equals(rfac.getTargetFieldID());
    }
}

