/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core.influencers;

import com.ibm.smarts.fields.recommender.core.BaseFieldsAnalysisContext;
import com.ibm.smarts.fields.recommender.core.influencers.InfluencersAnalysisContext;
import com.ibm.smarts.fields.recommender.core.influencers.InfluentialRelationshipDiscovery;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.ontology.service.KnowledgeDiscoveryService;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.util.OntologyCommon;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndirectInfluentialRelationshipDiscovery
extends InfluentialRelationshipDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndirectInfluentialRelationshipDiscovery.class);

    IndirectInfluentialRelationshipDiscovery(KnowledgeDiscoveryService kds) {
        super(kds);
    }

    @Override
    public void execute(@Nonnull InfluencersAnalysisContext rfac) {
        DatasetInfo targetTable = this.getTargetTable(rfac);
        if (targetTable.getBivariateStatistics().isEmpty()) {
            LOGGER.warn("The target dataset [{}] doesn't have bivariates.", (Object)targetTable.getName());
            this.getInScopeFieldStream(rfac, targetTable).forEach(col -> {
                rfac.addCorrlatedColumn((ColumnInfo)col, this.toFieldUID(col.getId(), targetTable.getId()), targetTable.getId());
                LOGGER.debug("Added column [{}] in dataset [{}] to target [{}]", new Object[]{col.getId(), targetTable.getId(), rfac.getTargetFieldID()});
                this.addInfluentialConcept(rfac, targetTable, (ColumnInfo)col);
            });
        } else {
            boolean isMeasureCalculation = this.isMeasureCalculation(rfac.getTargetField());
            Map<Pair<String, String>, BivariateStatistics> bvMap = this.getBVMapAndStoreIfAbsent(rfac, targetTable);
            this.getInScopeFieldStream(rfac, targetTable).forEach(col -> {
                BivariateStatistics bv = this.getBivariate(bvMap, rfac.getTargetFieldID(), col.getId());
                if (isMeasureCalculation || this.semanticValid((ColumnInfo)col, rfac) && this.valueInRange(bv, rfac, CORR_MEASURE)) {
                    if (this.shouldAddCorrelatedColumn((ColumnInfo)col, rfac)) {
                        rfac.addCorrlatedColumn((ColumnInfo)col, this.toFieldUID(col.getId(), targetTable.getId()), targetTable.getId());
                        LOGGER.info("Added correlated column [{}] in dataset [{}] to target [{}]", new Object[]{col.getId(), targetTable.getId(), rfac.getTargetFieldID()});
                    }
                    this.addInfluentialConcept(rfac, targetTable, (ColumnInfo)col);
                }
            });
        }
        if (rfac.hasNoCorrelationLimit()) {
            LOGGER.warn("Since there isn't any correlation limit, indirect discover relationship from joinable tables.");
            this.getJoinableDatasets(rfac).filter(ds -> !ds.getId().equals(targetTable.getId())).forEach(ds -> this.getInScopeFieldStream(rfac, (DatasetInfo)ds).forEach(col -> {
                rfac.addCorrlatedColumn((ColumnInfo)col, this.toFieldUID(col.getId(), ds.getId()), ds.getId(), 0.1f);
                LOGGER.debug("Added column [{}] in dataset [{}] to target [{}]", new Object[]{col.getId(), ds.getId(), rfac.getTargetFieldID()});
                this.addInfluentialConcept(rfac, (DatasetInfo)ds, (ColumnInfo)col);
            }));
        }
    }

    private Stream<ColumnInfo> getInScopeFieldStream(InfluencersAnalysisContext rfac, DatasetInfo targetTable) {
        return SmartsModuleUtil.getFlattenedColumns((BaseItemObject)targetTable).stream().filter(col -> rfac.isInScope(targetTable.getId(), this.toFieldUID(col.getId(), targetTable.getId()), (ColumnInfo)col));
    }

    private void addInfluentialConcept(InfluencersAnalysisContext rfac, DatasetInfo table, ColumnInfo col) {
        List<ConceptInfo> newTargets = this.resolveTargetConcepts(col, rfac);
        newTargets.stream().filter(tc -> this.isEligibleTarget((ConceptInfo)tc, rfac)).filter(c -> !OntologyCommon.getCommonConceptIDs().contains(c.getConceptID())).forEach(tc -> this.discoverInfluencialConcepts((ConceptInfo)tc, rfac));
        LOGGER.info("Found influential concepts for column [{}] in dataset [{}] : [{}]", new Object[]{col.getId(), table.getId(), rfac.getInfluencerConceptMap().keySet()});
    }

    private boolean shouldAddCorrelatedColumn(ColumnInfo col, BaseFieldsAnalysisContext rfac) {
        boolean okAdd = false;
        if (this.hasConcept(col, "http://www.ibm.com/ontologies/waca/domain/common#Measure", false)) {
            okAdd = rfac.isIncludeCorrelatedMeasure();
        }
        return okAdd || this.hasConcept(col, "http://www.ibm.com/ontologies/waca/domain/common#Entity", false);
    }

    private boolean semanticValid(ColumnInfo field, InfluencersAnalysisContext rfac) {
        if (Objects.isNull(field.getSemanticInfo())) {
            LOGGER.info("Exclude Field [{}] that doesn't have semanticInfo", (Object)field.getId());
            return false;
        }
        boolean isSemanticVaid = true;
        if (this.getDomainConcepts(field).anyMatch(c -> this.semanticSimilar(rfac, (ConceptInfo)c))) {
            isSemanticVaid = false;
        }
        if (!isSemanticVaid) {
            LOGGER.info("Exclude Field [{}] that has concept too similar to the target [{}]", (Object)field.getId(), (Object)rfac.getTargetFieldID());
        }
        return isSemanticVaid;
    }

    private Stream<ConceptInfo> getDomainConcepts(ColumnInfo field) {
        return field.getSemanticInfo().getConcepts().stream().filter(c -> ConceptsUtil.getOntologyId((ConceptInfo)c).equals("http://www.ibm.com/ontologies/waca/domain/common"));
    }

    private boolean semanticSimilar(InfluencersAnalysisContext rfac, ConceptInfo c) {
        if (!OntologyCommon.getCommonConceptIDs().contains(c.getConceptID())) {
            return rfac.getTargetConcepts().stream().filter(tc -> tc.getConceptID().equals(c.getConceptID())).peek(tc -> LOGGER.debug("Semantic similarity checking: [{}]", (Object)(tc.getConceptID() + " | " + c.getConceptID()))).anyMatch(tc -> {
                float delta = Math.abs(tc.getConfidence() - c.getConfidence());
                return Float.compare(rfac.getSemanticDelta(), delta) >= 0;
            });
        }
        return false;
    }

    private boolean semanticValidParents(ConceptInfo c, InfluencersAnalysisContext rfac) {
        Concept concept = ConceptsRegistry.instance().getConcept(c.getConceptID());
        if (concept.getParents().isEmpty()) {
            return true;
        }
        if (concept.getParents().stream().anyMatch(p -> this.semanticSimilar(rfac, p.toConceptInfo(c.getConfidence())))) {
            return false;
        }
        return concept.getParents().stream().allMatch(p -> this.semanticValidParents(p.toConceptInfo(c.getConfidence()), rfac));
    }
}

