/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core.influencers;

import com.ibm.smarts.fields.recommender.api.RecommendationStatus;
import com.ibm.smarts.fields.recommender.core.AbstractAnalysisStep;
import com.ibm.smarts.fields.recommender.core.BaseFieldsAnalysisContext;
import com.ibm.smarts.fields.recommender.core.exceptions.IFRServerException;
import com.ibm.smarts.fields.recommender.core.influencers.InfluencersAnalysisContext;
import com.ibm.smarts.ontology.exceptions.InvalidOntologyDomainException;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.ontology.service.KnowledgeDiscoveryService;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluentialRelationshipDiscovery
extends AbstractAnalysisStep<InfluencersAnalysisContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluentialRelationshipDiscovery.class);
    private static final ConcurrentHashMap<String, List<Pair<String, Float>>> cache = new ConcurrentHashMap();
    private final KnowledgeDiscoveryService kds;

    InfluentialRelationshipDiscovery(KnowledgeDiscoveryService kds) {
        this.kds = kds;
    }

    @Override
    public void execute(@Nonnull InfluencersAnalysisContext rfac) {
        ColumnInfo target = this.resolveTargetColumnInfo(rfac);
        if (!this.canContinue(rfac, target)) {
            rfac.setCanContinue(false);
            return;
        }
        List<ConceptInfo> targetConcepts = this.resolveTargetConcepts(target, rfac);
        rfac.setTargetConcepts(targetConcepts);
        this.discoverInfluencialConcepts(targetConcepts, rfac);
        LOGGER.info("Found influential concepts for column [{}] in dataset [{}]: [{}]", new Object[]{rfac.getTargetFieldID(), rfac.getTargetFieldTableID(), rfac.getInfluencerConceptMap().keySet()});
    }

    private boolean canContinue(BaseFieldsAnalysisContext rfac, ColumnInfo target) {
        if (this.isSemanticEligible(target)) {
            return true;
        }
        return rfac.isAllowCategoryTarget() && !this.isDegenerateCategory(target);
    }

    private boolean isDegenerateCategory(ColumnInfo col) {
        return col.getSemanticInfo().getConcepts().stream().anyMatch(c -> "http://www.ibm.com/ontologies/waca/application#UniqueValue".equals(c.getConceptID()) || "http://www.ibm.com/ontologies/waca/application#Empty".equals(c.getConceptID()) || "http://www.ibm.com/ontologies/waca/application#Singleton".equals(c.getConceptID()) || "http://www.ibm.com/ontologies/waca/application#LowValueRepetition".equals(c.getConceptID()));
    }

    protected boolean isEligibleTarget(ConceptInfo possibleTarget, InfluencersAnalysisContext rfac) {
        try {
            List<Pair<String, Float>> influencers = this.getInfluencialConcepts(possibleTarget);
            return influencers.stream().noneMatch(entry -> rfac.getSpecificTargetConcepts().contains(entry.getLeft()));
        }
        catch (InvalidOntologyDomainException ex) {
            throw new IFRServerException(RecommendationStatus.INTERNAL_INVALID_ONTOLOGY_DOMAIN, (Throwable)ex);
        }
    }

    protected void discoverInfluencialConcepts(List<ConceptInfo> targetConcepts, InfluencersAnalysisContext rfac) {
        targetConcepts.forEach(c -> this.discoverInfluencialConcepts((ConceptInfo)c, rfac));
    }

    protected void discoverInfluencialConcepts(ConceptInfo c, InfluencersAnalysisContext rfac) {
        try {
            List<Pair<String, Float>> influencers = this.getInfluencialConcepts(c);
            influencers.stream().filter(pair -> !rfac.getSpecificTargetConcepts().contains(pair.getLeft())).forEach(pair -> rfac.getInfluencerConceptMap().compute((String)pair.getLeft(), (k, v) -> v == null || Float.compare(((Float)pair.getRight()).floatValue(), v.floatValue()) > 0 ? (Float)pair.getRight() : v));
            if (Float.compare(rfac.getSemanticDelta(), 0.0f) == 0) {
                rfac.getInfluencerConceptMap().putIfAbsent(c.getConceptID(), Float.valueOf(0.1f));
            }
        }
        catch (InvalidOntologyDomainException ex) {
            throw new IFRServerException(RecommendationStatus.INTERNAL_INVALID_ONTOLOGY_DOMAIN, (Throwable)ex);
        }
    }

    private List<Pair<String, Float>> getInfluencialConcepts(ConceptInfo concept) {
        return cache.computeIfAbsent(concept.getConceptID(), k -> this.kds.getInfluencerReasoner().inferInfluencers(concept));
    }

    protected List<ConceptInfo> resolveTargetConcepts(ColumnInfo target, BaseFieldsAnalysisContext rfac) {
        if (Objects.isNull(target.getSemanticInfo())) {
            return new ArrayList<ConceptInfo>(0);
        }
        return target.getSemanticInfo().getConcepts().stream().filter(c -> ConceptsUtil.getOntologyId((ConceptInfo)c).equals("http://www.ibm.com/ontologies/waca/domain/common")).filter(c -> Float.compare(c.getConfidence(), rfac.getSemanticRelavenceThreshold()) > 0).collect(Collectors.toList());
    }

    private ColumnInfo resolveTargetColumnInfo(InfluencersAnalysisContext rfac) {
        Optional<DatasetInfo> ds = rfac.getSmartsModule().getDatasets().stream().filter(table -> table.getId().equals(rfac.getTargetFieldTableID())).findFirst();
        return SmartsModuleUtil.getFlattenedColumns((BaseItemObject)((BaseItemObject)ds.get())).stream().filter(col -> col.getId().equals(rfac.getTargetFieldID())).findFirst().get();
    }
}

