/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.combinations.generator.internal;

import com.ibm.smarts.combinations.generator.api.ICombinationGenerator;
import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.combinations.generator.api.IDataGroup;
import com.ibm.smarts.combinations.generator.api.IFilter;
import com.ibm.smarts.combinations.generator.exceptions.ColumnNotFoundException;
import com.ibm.smarts.combinations.generator.exceptions.NoLogicalGroupFoundException;
import com.ibm.smarts.combinations.generator.internal.DataColumn;
import com.ibm.smarts.combinations.generator.internal.DataCombinationStatus;
import com.ibm.smarts.combinations.generator.internal.DataGroup;
import com.ibm.smarts.combinations.generator.internal.DataItemComb;
import com.ibm.smarts.combinations.generator.internal.DataSet;
import com.ibm.smarts.combinations.generator.util.FilteringSpec;
import com.ibm.smarts.combinations.generator.util.FilteringSpecGenerator;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.Hierarchy;
import com.ibm.smarts.schema.LogicalGroup;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinationGenerator
implements ICombinationGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CombinationGenerator.class);
    private static final int HIERARCHY_COMBINATION_MAXIMUM_SIZE = 2;
    private static final int HIERARCHY_COMBINATION_MINIMUM_SIZE = 1;
    private static final int DEFAULT_COMBINATION_MIN_SIZE = 1;
    private static final int DEFAULT_COMBINATION_MAX_SIZE = 5;
    private static final String CAPTION = "http://www.ibm.com/ontologies/waca/domain/common#Caption";
    InputStream stream;
    private static final int TIMEOUT = 1000;
    FilteringSpec filter;
    private final ExecutorService executorService;

    public CombinationGenerator(int combinatorThreadPoolSize) {
        this.executorService = Executors.newFixedThreadPool(combinatorThreadPoolSize);
    }

    public CombinationGenerator(String path, int combinatorThreadPoolSize) throws FileNotFoundException {
        this.stream = new BufferedInputStream(new FileInputStream(path));
        this.filter = new FilteringSpecGenerator(this.stream).getFilteringSpec();
        this.executorService = Executors.newFixedThreadPool(combinatorThreadPoolSize);
    }

    public CombinationGenerator(InputStream stream, int combinatorThreadPoolSize) {
        this.stream = stream;
        this.filter = new FilteringSpecGenerator(stream).getFilteringSpec();
        this.executorService = Executors.newFixedThreadPool(combinatorThreadPoolSize);
    }

    private List<IDataColumn> getColumns(DatasetInfo dataset, Map<String, IFilter> columnFilterMap, SmartsModule datamodule, String primaryColumn) {
        return this.toDataColumns(SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataset), dataset, columnFilterMap, datamodule, primaryColumn);
    }

    @Override
    public List<IDataGroup<IDataColumn>> getDataGroups(SmartsModule dataModule, Map<String, IFilter> columnFilterMap) {
        LinkedList<IDataGroup<IDataColumn>> res = new LinkedList<IDataGroup<IDataColumn>>();
        DataItemComb dataComb = new DataItemComb();
        dataModule.getDatasets().forEach(dataSet -> {
            if (!SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataSet).isEmpty()) {
                List<IDataColumn> columns = this.getColumns((DatasetInfo)dataSet, columnFilterMap, dataModule, null);
                DataCombinationStatus<IDataColumn> dcStatus = this.filter != null ? dataComb.getCombs(columns, this.filter, this.executorService, 1000L) : dataComb.getCombs(columns, 1, 5, this.executorService, 1000L);
                DataGroup dg = new DataGroup(dataSet.getId(), dcStatus.getCombinations());
                res.add(dg);
                IDataGroup<IDataColumn> hierarchicalDataGroup = this.getDataGroupsWithHierarchy(dataModule, (DatasetInfo)dataSet, columnFilterMap);
                dg.addCombinations(hierarchicalDataGroup.getCombintions());
            }
        });
        return res;
    }

    private List<IDataGroup<IDataColumn>> getDataGroups(SmartsModule dataModule, List<String> selectedIds, Optional<Integer> min, Optional<Integer> max, Map<String, IFilter> columnFilterMap, String primaryColumn) throws ColumnNotFoundException {
        DataCombinationStatus<IDataColumn> dcStatus;
        if (selectedIds == null || selectedIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList res = new ArrayList();
        DataItemComb dataComb = new DataItemComb();
        LinkedList<String> selectedIdsCopy = new LinkedList<String>(selectedIds);
        ArrayList<IDataColumn> selectedCols = new ArrayList<IDataColumn>();
        ArrayList allSelectedColumns = new ArrayList();
        for (String columnID : selectedIds) {
            dataModule.getDatasets().forEach(dataSet -> {
                List<IDataColumn> allDataSetCols = this.getColumns((DatasetInfo)dataSet, columnFilterMap, dataModule, primaryColumn);
                Optional<IDataColumn> foundColumn = allDataSetCols.stream().filter(Objects::nonNull).filter(c -> c.getIdForExpression().equals(columnID)).findAny();
                if (foundColumn.isPresent()) {
                    allSelectedColumns.add(foundColumn.get());
                }
            });
        }
        dataModule.getDatasets().forEach(dataSet -> {
            List<IDataColumn> allDataSetCols = this.getColumns((DatasetInfo)dataSet, columnFilterMap, dataModule, primaryColumn);
            ListIterator itr = selectedIdsCopy.listIterator();
            ArrayList<IDataColumn> columnsFoundInThisDataSet = new ArrayList<IDataColumn>();
            while (itr.hasNext()) {
                String id = (String)itr.next();
                try {
                    columnsFoundInThisDataSet.add(this.getColumn(allDataSetCols, id));
                    itr.remove();
                }
                catch (ColumnNotFoundException ex) {
                    LOGGER.debug("Column not found in this dataset", ex.getCause());
                }
            }
            IDataGroup<IDataColumn> hierarchicalDataGroup = this.addMissingSelectedColumnsInCombination(allSelectedColumns, (DatasetInfo)dataSet, (List<IDataColumn>)columnsFoundInThisDataSet);
            if (hierarchicalDataGroup != null) {
                res.addAll(hierarchicalDataGroup.getCombintions());
            }
            selectedCols.addAll(columnsFoundInThisDataSet);
        });
        if (!selectedIdsCopy.isEmpty()) {
            throw new ColumnNotFoundException("These Columns were not found in the smartModule:" + selectedIdsCopy);
        }
        if (!(this.filter == null || min.isPresent() && max.isPresent())) {
            dcStatus = !selectedCols.isEmpty() ? dataComb.getCombs(selectedCols, this.filter, this.executorService, 1000L) : null;
        } else if (min.isPresent() && max.isPresent()) {
            dcStatus = !selectedCols.isEmpty() ? dataComb.getCombs(selectedCols, min.get(), max.get(), this.executorService, 1000L) : null;
        } else {
            DataCombinationStatus<IDataColumn> dataCombinationStatus = dcStatus = !selectedCols.isEmpty() ? dataComb.getCombs(selectedCols, 1, 5, this.executorService, 1000L) : null;
        }
        if (dcStatus != null) {
            List combinations = dcStatus.getCombinations().stream().filter(c -> c.size() == selectedIds.size()).collect(Collectors.toList());
            res.addAll(combinations);
        }
        return Arrays.asList(new DataGroup(null, res));
    }

    @Override
    public List<IDataGroup<IDataColumn>> getDataGroupsUsingAllColumns(SmartsModule dataModule, List<String> filteredIds, Map<String, IFilter> columnFilterMap, String primaryColumn) throws ColumnNotFoundException {
        return this.getDataGroups(dataModule, filteredIds, Optional.of(filteredIds.size()), Optional.of(filteredIds.size()), columnFilterMap, primaryColumn);
    }

    @Override
    public List<IDataGroup<IDataColumn>> getDataGroups(SmartsModule dataModule, List<String> filteredIds, Map<String, IFilter> columnFilterMap) throws ColumnNotFoundException {
        return this.getDataGroups(dataModule, filteredIds, Optional.empty(), Optional.empty(), columnFilterMap, null);
    }

    public IDataColumn getColumn(List<IDataColumn> columns, String columnID) throws ColumnNotFoundException {
        Optional<IDataColumn> column = columns.stream().filter(c -> columnID.equals(c.getIdForExpression())).findFirst();
        if (!column.isPresent()) {
            throw new ColumnNotFoundException("could not find column: " + columnID);
        }
        return column.get();
    }

    private IDataGroup<IDataColumn> addMissingSelectedColumnsInCombination(List<IDataColumn> allSelectedColumns, DatasetInfo dataSet, List<IDataColumn> columnsFoundInThisDataSet) {
        IDataGroup<IDataColumn> hierarchicalDataGroup = null;
        if (!columnsFoundInThisDataSet.isEmpty() && (hierarchicalDataGroup = this.getDataGroupsWithHierarchyWithFilter(dataSet, columnsFoundInThisDataSet)) != null && hierarchicalDataGroup.getCombintions() != null && !hierarchicalDataGroup.getCombintions().isEmpty()) {
            for (List<IDataColumn> combination : hierarchicalDataGroup.getCombintions()) {
                ArrayList toAdd = new ArrayList();
                allSelectedColumns.forEach(selected -> {
                    if (combination.stream().noneMatch(combo -> combo.getId().equals(selected.getId())) && combination.stream().noneMatch(col -> col.getHierarchy().contains(selected))) {
                        toAdd.add(selected);
                    }
                });
                combination.addAll(toAdd);
            }
        }
        return hierarchicalDataGroup;
    }

    private IDataGroup<IDataColumn> getDataGroupsWithHierarchyWithFilter(DatasetInfo dataSet, List<IDataColumn> filteredColumns) {
        List<IDataColumn> mergedHierarchicalFilteredColumns = IDataColumn.formHierarchy(filteredColumns);
        if (mergedHierarchicalFilteredColumns.isEmpty()) {
            return null;
        }
        if (mergedHierarchicalFilteredColumns.size() == filteredColumns.size()) {
            return null;
        }
        DataGroup<IDataColumn> dg = new DataGroup<IDataColumn>(dataSet.getId(), Arrays.asList(mergedHierarchicalFilteredColumns));
        dg.setHierarchical(true);
        return dg;
    }

    private IDataGroup<IDataColumn> getDataGroupsWithHierarchy(SmartsModule dataModule, DatasetInfo dataSet, Map<String, IFilter> columnFilterMap) {
        ArrayList resCombinations = new ArrayList();
        List hierarchies = dataSet.getHierarchies();
        List logicalGroups = dataSet.getLogicalGroups();
        List<IDataColumn> prepedHierarchyColumns = hierarchies.stream().map(h -> this.prepHierarchy((Hierarchy)h, logicalGroups, columnFilterMap, dataModule)).map(prepedHierarchy -> {
            int size = prepedHierarchy.size();
            IDataColumn leaf = (IDataColumn)prepedHierarchy.get(size - 1);
            IDataColumn hierarchyNode = leaf.shallowCopy();
            hierarchyNode.setHierarchy((List<IDataColumn>)prepedHierarchy);
            return hierarchyNode;
        }).collect(Collectors.toList());
        DataItemComb combGenerator = new DataItemComb();
        List<Object> hierarchyColumnsCombinations = new ArrayList();
        if (!prepedHierarchyColumns.isEmpty()) {
            hierarchyColumnsCombinations = combGenerator.getCombs(prepedHierarchyColumns, 1, 2, this.executorService, 1000L).getCombinations();
        }
        hierarchyColumnsCombinations.stream().forEach(hierarchyCombo -> {
            ArrayList<IDataColumn> exclusionList = new ArrayList<IDataColumn>();
            ArrayList<IDataColumn> leafColumns = new ArrayList<IDataColumn>();
            for (IDataColumn hColumn : hierarchyCombo) {
                List<IDataColumn> hierarchy = hColumn.getHierarchy();
                if (hierarchy != null && hierarchy.size() > 1) {
                    exclusionList.addAll(hierarchy.subList(0, hierarchy.size() - 1));
                }
                leafColumns.add(hColumn);
            }
            List exclusionListIds = exclusionList.stream().map(IDataColumn::getIdForExpression).collect(Collectors.toList());
            List<IDataColumn> columnsForCombinations = this.toDataColumns(SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataSet), dataSet, columnFilterMap, dataModule, null).stream().filter(column -> !exclusionListIds.contains(column.getIdForExpression())).map(column -> {
                for (IDataColumn c : leafColumns) {
                    if (!c.getIdForExpression().equals(column.getIdForExpression())) continue;
                    return c;
                }
                return column;
            }).collect(Collectors.toList());
            List<List<IDataColumn>> hCombinations = this.filter != null ? combGenerator.getCombs(columnsForCombinations, this.filter, this.executorService, 1000L).getCombinations() : combGenerator.getCombs(columnsForCombinations, 1, 5, this.executorService, 1000L).getCombinations();
            List filteredHCombinations = hCombinations.stream().filter(combination -> {
                for (IDataColumn col : combination) {
                    if (!col.isHierchical()) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            resCombinations.addAll(filteredHCombinations);
        });
        DataGroup<IDataColumn> dataGroup = new DataGroup<IDataColumn>(dataSet.getId(), resCombinations);
        dataGroup.setHierarchical(true);
        return dataGroup;
    }

    @Override
    public List<IDataColumn> getValidHierarchy(SmartsModule dataModule, List<IDataColumn> columns, Map<String, IFilter> columnFilterMap) {
        if (columns == null || columns.isEmpty()) {
            return Collections.emptyList();
        }
        for (DatasetInfo dataset : dataModule.getDatasets()) {
            int i;
            ArrayList<IDataColumn> tempColumns = new ArrayList<IDataColumn>(columns);
            List hierarchies = dataset.getHierarchies();
            List logicalGroups = dataset.getLogicalGroups();
            ArrayList hierarchiesTracker = new ArrayList(hierarchies.size());
            ArrayList<List<IDataColumn>> prepedHierarchies = new ArrayList<List<IDataColumn>>();
            for (i = 0; i < hierarchies.size(); ++i) {
                hierarchiesTracker.add(new ArrayList());
                prepedHierarchies.add(this.prepHierarchy((Hierarchy)hierarchies.get(i), logicalGroups, columnFilterMap, dataModule));
            }
            for (i = 0; i < prepedHierarchies.size(); ++i) {
                for (IDataColumn column : (List)prepedHierarchies.get(i)) {
                    int index = tempColumns.indexOf(column);
                    if (index == -1) continue;
                    IDataColumn matchedColumn = (IDataColumn)tempColumns.remove(index);
                    ((List)hierarchiesTracker.get(i)).add(matchedColumn);
                }
            }
            if (!tempColumns.isEmpty()) continue;
            for (i = 0; i < hierarchiesTracker.size(); ++i) {
                if (((List)hierarchiesTracker.get(i)).size() != columns.size()) continue;
                return (List)prepedHierarchies.get(i);
            }
        }
        return Collections.emptyList();
    }

    private List<IDataColumn> toDataColumns(List<ColumnInfo> list, DatasetInfo dataset, Map<String, IFilter> columnFilterMap, SmartsModule dataModule, String primaryColumn) {
        ArrayList<IDataColumn> res = new ArrayList<IDataColumn>();
        List<List<IDataColumn>> prepedHierarchies = this.getPrepedHierarchies(dataset, columnFilterMap, dataModule);
        for (ColumnInfo c : list) {
            res.add(new DataColumn(c, new DataSet(dataset), this.getParentHierarchyIfExist(c, prepedHierarchies), columnFilterMap.get(c.getIdForExpression()), primaryColumn == null ? false : primaryColumn.equals(c.getIdForExpression())));
        }
        return res;
    }

    private List<IDataColumn> getParentHierarchyIfExist(ColumnInfo column, List<List<IDataColumn>> hierarchies) {
        for (List<IDataColumn> hierarchy : hierarchies) {
            if (!this.contains(column, hierarchy)) continue;
            return hierarchy;
        }
        return Collections.emptyList();
    }

    private List<List<IDataColumn>> getPrepedHierarchies(DatasetInfo dataset, Map<String, IFilter> columnFilterMap, SmartsModule dataModule) {
        List hierarchies = dataset.getHierarchies();
        List logicalGroups = dataset.getLogicalGroups();
        ArrayList<List<IDataColumn>> result = new ArrayList<List<IDataColumn>>();
        for (int i = 0; i < hierarchies.size(); ++i) {
            result.add(this.prepHierarchy((Hierarchy)hierarchies.get(i), logicalGroups, columnFilterMap, dataModule));
        }
        return result;
    }

    public List<IDataColumn> prepHierarchy(Hierarchy hierarchy, List<LogicalGroup> logicalGroups, Map<String, IFilter> columnFilterMap, SmartsModule module) {
        ArrayList<IDataColumn> result = new ArrayList<IDataColumn>();
        hierarchy.getLevel().forEach(level -> {
            try {
                result.add(this.getRepresentativeColumnForLevel((Hierarchy.Level)level, logicalGroups, columnFilterMap, module));
            }
            catch (NoLogicalGroupFoundException e) {
                LOGGER.error("We were unable to find the logical group representing this level. This comes from the smart module it should never happen that thereis no logicalGroup for the given levelGroupId" + e);
            }
        });
        return result;
    }

    public IDataColumn getRepresentativeColumnForLevel(Hierarchy.Level level, List<LogicalGroup> logicalGroups, Map<String, IFilter> columnFilterMap, SmartsModule module) throws NoLogicalGroupFoundException {
        String rootLevelGroupID = level.getGroupId();
        List levelMembers = null;
        for (LogicalGroup logicalGroup : logicalGroups) {
            if (!logicalGroup.getId().equals(rootLevelGroupID)) continue;
            levelMembers = logicalGroup.getMember();
            break;
        }
        if (levelMembers != null && !levelMembers.isEmpty()) {
            IDataColumn firstColumn = this.getColumnInternal(module, columnFilterMap, ((LogicalGroup.Member)levelMembers.get(0)).getColumnId());
            if (levelMembers.size() == 1) {
                return firstColumn;
            }
            for (int i = 1; i < levelMembers.size(); ++i) {
                if (!((LogicalGroup.Member)levelMembers.get(i)).getAttribute().getConceptID().equals(CAPTION)) continue;
                return this.getColumnInternal(module, columnFilterMap, ((LogicalGroup.Member)levelMembers.get(i)).getColumnId());
            }
            return firstColumn;
        }
        throw new NoLogicalGroupFoundException("We couldn't find a logical Group from smart module with the provided id for this given level" + level);
    }

    private boolean contains(ColumnInfo column, List<IDataColumn> list) {
        for (IDataColumn c : list) {
            if (!c.getIdForExpression().equals(column.getIdForExpression())) continue;
            return true;
        }
        return false;
    }

    @Override
    public IDataColumn getColumn(SmartsModule dataModule, String columnId, Map<String, IFilter> columnFilterMap, boolean isPrimary) {
        for (DatasetInfo set : dataModule.getDatasets()) {
            for (ColumnInfo col : SmartsModuleUtil.getFlattenedColumns((BaseItemObject)set)) {
                if (!col.getIdForExpression().equals(columnId)) continue;
                List<List<IDataColumn>> prepedHierarchy = this.getPrepedHierarchies(set, columnFilterMap, dataModule);
                return new DataColumn(col, new DataSet(set), this.getParentHierarchyIfExist(col, prepedHierarchy), columnFilterMap != null ? columnFilterMap.get(columnId) : null, isPrimary);
            }
        }
        return null;
    }

    private IDataColumn getColumnInternal(SmartsModule dataModule, Map<String, IFilter> columnFilterMap, String columnId) {
        for (DatasetInfo set : dataModule.getDatasets()) {
            for (ColumnInfo col : SmartsModuleUtil.getFlattenedColumns((BaseItemObject)set)) {
                if (!col.getId().equals(columnId)) continue;
                return new DataColumn(col, new DataSet(set), columnFilterMap != null ? columnFilterMap.get(columnId) : null);
            }
        }
        return null;
    }
}

