/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.combinations.generator.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.combinations.generator.util.GroupSpec;
import java.util.List;
import java.util.Optional;

public class FilteringSpec {
    private int minCombinations = 0;
    private int maxCombinations = 4;
    private List<GroupSpec> allowedGroups;

    @JsonCreator
    public FilteringSpec(@JsonProperty(value="minComb") int minComb, @JsonProperty(value="maxComb") int maxComb, @JsonProperty(value="allowedGroups") List<GroupSpec> allowedGroups) {
        this.minCombinations = minComb;
        this.maxCombinations = maxComb;
        this.allowedGroups = allowedGroups;
    }

    public int getMin() {
        return this.minCombinations;
    }

    public int getMax() {
        return this.maxCombinations;
    }

    public List<GroupSpec> getAllowedGroups() {
        return this.allowedGroups;
    }

    public GroupSpec getAllowedGroup(int numberOfColumns) {
        Optional<GroupSpec> spec = this.allowedGroups.stream().filter(group -> group.getcombinationSize() == numberOfColumns).findFirst();
        if (spec.isPresent()) {
            return spec.get();
        }
        return null;
    }

    public String toString() {
        return "minCombinations:" + this.minCombinations + "\nmaxCombinations:" + this.maxCombinations + "\n allowedGroups:" + this.allowedGroups.toString();
    }
}

