/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.store.api.multirec;

import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.core.util.ToString;
import com.ibm.smarts.store.api.IMultiRecordTrigger;
import com.ibm.smarts.store.api.ITypedStore;
import com.ibm.smarts.store.api.multirec.MRTRecord;
import com.ibm.smarts.store.api.query.StoreStatus;
import com.ibm.smarts.store.api.util.StoreAsyncHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiRecordTrigger<T>
implements IMultiRecordTrigger<T> {
    private final Logger LOGGER = LoggerFactory.getLogger(MultiRecordTrigger.class);
    public final String type;
    private final RequestContext rc;
    private final Class<T> klass;
    private final ITypedStore<MRTRecord> store;

    public MultiRecordTrigger(String type, RequestContext rc, Class<T> klass, ITypedStore<MRTRecord> store) {
        this.type = type;
        this.rc = rc;
        this.klass = klass;
        this.store = store;
    }

    public String toString() {
        return ToString.with((Object)this).field("type", (Object)this.type).field("class", this.klass).field("store", this.store).field("requestContext", (Object)this.rc).get();
    }

    @Override
    public Class<T> getRecordClass() {
        return this.klass;
    }

    @Override
    public String getType() {
        return this.type;
    }

    private String getRecordId(String key) {
        return MultiRecordTrigger.getRecordId(this.type, key);
    }

    public static String getRecordId(String type, String key) {
        return type + ":" + key;
    }

    @Override
    public StoreStatus apply(String key, T record, Function<List<T>, Boolean> completionPredicate, Function<List<T>, Void> completionFunc) {
        CompletableFuture<StoreStatus> f = this.applyAsync(key, record, completionPredicate, completionFunc);
        return StoreAsyncHelper.get(f);
    }

    @Override
    public CompletableFuture<StoreStatus> applyAsync(String key, T record, Function<List<T>, Boolean> completionPredicate, Function<List<T>, Void> completionFunc) {
        AtomicBoolean isCompleted = new AtomicBoolean(false);
        String recordId = this.getRecordId(key);
        CompletableFuture<StoreStatus> ssApplyF = this.store.createOrApplyAsync(recordId, mrtRecord_in -> {
            MRTRecord mrtRecord = mrtRecord_in;
            if (mrtRecord == null) {
                mrtRecord = new MRTRecord();
                mrtRecord.type = this.type;
                mrtRecord.key = key;
                mrtRecord.records = new ArrayList<String>();
            }
            String recordJson = JsonParserHelper.toJson((Object)record);
            mrtRecord.records.add(recordJson);
            List<T> records = this.getRecords(mrtRecord.records);
            isCompleted.set((Boolean)completionPredicate.apply(records));
            if (isCompleted.get()) {
                try {
                    completionFunc.apply(records);
                }
                catch (Throwable th) {
                    this.LOGGER.error("Exception in completion function. MRT=" + this, th);
                    throw th;
                }
            }
            return mrtRecord;
        });
        CompletionStage ssMaybeDeleteF = ssApplyF.thenCompose(ss -> {
            if (!isCompleted.get()) {
                return CompletableFuture.completedFuture(ss);
            }
            CompletableFuture<StoreStatus> ret = this.store.deleteByIdAsync(recordId);
            return ret;
        });
        return ssMaybeDeleteF;
    }

    private List<T> getRecords(List<String> jsons) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (String json : jsons) {
            Object rec = JsonParserHelper.fromJson((String)json, this.klass);
            ret.add(rec);
        }
        return ret;
    }
}

